package org.eclipse.draw2d {
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.LineAttributes;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class Shape extends Figure {
  public var lineWidth: int;
  private var lastLineWidth: int;
  public var lineStyle: int;
  private var lineAttributes: LineAttributes;
  private var fill: Boolean;
  private var outline: Boolean;
  private var xorFill: Boolean;
  private var xorOutline: Boolean;
  private var antialias: int;
  private var alpha: int;
  public function Shape() {
    this.setOpaque__Z(false);
    lineAttributes = new LineAttributes(new Arguments(org.eclipse.swt.graphics.LineAttributes.LineAttributes__F, [0.0]));
    fill = true;
    outline = true;
    xorFill = false;
    xorOutline = false;
    antialias = -1;
    alpha = 255;
    lineWidth = int(lineAttributes.width);
    lineStyle = lineAttributes.style;
    lastLineWidth = lineWidth;
    return;
  }
  public function fillShape__Lorg_eclipse_draw2d_Graphics_2(graphics: Graphics): void { } // abstract
  public function outlineShape__Lorg_eclipse_draw2d_Graphics_2(graphics: Graphics): void { } // abstract
  public override function paintFigure__Lorg_eclipse_draw2d_Graphics_2(graphics: Graphics): void {
    graphics.setAntialias__I(antialias);
    graphics.setAlpha__I(alpha);
    super.paintFigure__Lorg_eclipse_draw2d_Graphics_2(graphics);
    if (!this.isEnabled__()) {
      graphics.translate__II(1, 1);
      graphics.setBackgroundColor__Lorg_eclipse_swt_graphics_Color_2(org.eclipse.draw2d.ColorConstants$$fields.buttonLightest);
      graphics.setForegroundColor__Lorg_eclipse_swt_graphics_Color_2(org.eclipse.draw2d.ColorConstants$$fields.buttonLightest);
      if (fill) {
        this.paintFill__Lorg_eclipse_draw2d_Graphics_2(graphics);
      }
      if (outline) {
        this.paintOutline__Lorg_eclipse_draw2d_Graphics_2(graphics);
      }
      graphics.setBackgroundColor__Lorg_eclipse_swt_graphics_Color_2(org.eclipse.draw2d.ColorConstants$$fields.buttonDarker);
      graphics.setForegroundColor__Lorg_eclipse_swt_graphics_Color_2(org.eclipse.draw2d.ColorConstants$$fields.buttonDarker);
      graphics.translate__II(-1, -1);
    }
    if (fill) {
      this.paintFill__Lorg_eclipse_draw2d_Graphics_2(graphics);
    }
    if (outline) {
      this.paintOutline__Lorg_eclipse_draw2d_Graphics_2(graphics);
    }
    return;
  }
  private function paintOutline__Lorg_eclipse_draw2d_Graphics_2(graphics: Graphics): void {
    lineAttributes.width = this.getLineWidthFloat__();
    lineAttributes.style = this.getLineStyle__();
    graphics.setLineAttributes__Lorg_eclipse_swt_graphics_LineAttributes_2(lineAttributes);
    if (xorOutline) {
      var oldAdv: Boolean = graphics.getAdvanced__();
      graphics.setAdvanced__Z(false);
      graphics.setXORMode__Z(true);
      this.outlineShape__Lorg_eclipse_draw2d_Graphics_2(graphics);
      graphics.setAdvanced__Z(oldAdv);
    } else {
      this.outlineShape__Lorg_eclipse_draw2d_Graphics_2(graphics);
    }
    return;
  }
  private function paintFill__Lorg_eclipse_draw2d_Graphics_2(graphics: Graphics): void {
    if (xorFill) {
      var oldAdv: Boolean = graphics.getAdvanced__();
      graphics.setAdvanced__Z(false);
      graphics.setXORMode__Z(true);
      this.fillShape__Lorg_eclipse_draw2d_Graphics_2(graphics);
      graphics.setAdvanced__Z(oldAdv);
    } else {
      this.fillShape__Lorg_eclipse_draw2d_Graphics_2(graphics);
    }
    return;
  }
  public function setFill__Z(b: Boolean): void {
    if (fill != b) {
      fill = b;
      this.repaint__();
    }
    return;
  }
  public function setFillXOR__Z(b: Boolean): void {
    if (xorFill != b) {
      xorFill = b;
      this.repaint__();
    }
    return;
  }
  public function setOutline__Z(b: Boolean): void {
    if (outline != b) {
      outline = b;
      this.repaint__();
    }
    return;
  }
  public function setOutlineXOR__Z(b: Boolean): void {
    if (xorOutline != b) {
      xorOutline = b;
      this.repaint__();
    }
    return;
  }
  public function setXOR__Z(b: Boolean): void {
    xorOutline = xorFill = b;
    this.repaint__();
    return;
  }
  public function getAlpha__(): int {
    return alpha;
  }
  public function getAntialias__(): int {
    return antialias;
  }
  public function getLineAttributes__(): LineAttributes {
    return SWTGraphics.clone__Lorg_eclipse_swt_graphics_LineAttributes_2(lineAttributes);
  }
  public function getLineWidth__(): int {
    if (lineWidth != lastLineWidth) {
      lineAttributes.width = lineWidth;
      lastLineWidth = lineWidth;
    }
    return int(lineAttributes.width);
  }
  public function getLineWidthFloat__(): Number {
    if (lineWidth != lastLineWidth) {
      lineAttributes.width = lineWidth;
      lastLineWidth = lineWidth;
    }
    return lineAttributes.width;
  }
  public function getLineJoin__(): int {
    return lineAttributes.join;
  }
  public function getLineCap__(): int {
    return lineAttributes.cap;
  }
  public function getLineStyle__(): int {
    lineAttributes.style = lineStyle;
    return lineAttributes.style;
  }
  public function getLineDash__(): JavaArray {
    return JavaArray(Object(lineAttributes.dash).clone__());
  }
  public function getLineDashOffset__(): Number {
    return lineAttributes.dashOffset;
  }
  public function getLineMiterLimit__(): Number {
    return lineAttributes.miterLimit;
  }
  public function setAlpha__I(value: int): void {
    if (alpha != value) {
      alpha = value;
      this.repaint__();
    }
    return;
  }
  public function setAntialias__I(value: int): void {
    if (antialias != value) {
      antialias = value;
      this.repaint__();
    }
    return;
  }
  public function setLineAttributes__Lorg_eclipse_swt_graphics_LineAttributes_2(la: LineAttributes): void {
    if (!Object(lineAttributes).equals__Ljava_lang_Object_2(la)) {
      SWTGraphics.copyLineAttributes__Lorg_eclipse_swt_graphics_LineAttributes_2Lorg_eclipse_swt_graphics_LineAttributes_2(lineAttributes, la);
      this.repaint__();
    }
    return;
  }
  public function setLineWidth__I(w: int): void {
    var _w: Number = w;
    if (lineAttributes.width != _w) {
      lineAttributes.width = _w;
      lineWidth = w;
      lastLineWidth = w;
      this.repaint__();
    }
    return;
  }
  public function setLineWidthFloat__F(value: Number): void {
    if (lineAttributes.width != value) {
      lineAttributes.width = value;
      lineWidth = int(value);
      lastLineWidth = int(value);
      this.repaint__();
    }
    return;
  }
  public function setLineJoin__I(join: int): void {
    if (lineAttributes.join != join) {
      lineAttributes.join = join;
      this.repaint__();
    }
    return;
  }
  public function setLineCap__I(cap: int): void {
    if (lineAttributes.cap != cap) {
      lineAttributes.cap = cap;
      this.repaint__();
    }
    return;
  }
  public function setLineStyle__I(style: int): void {
    if (lineAttributes.style != style) {
      lineAttributes.style = style;
      lineStyle = style;
      this.repaint__();
    }
    return;
  }
  public function setLineDash___3F(dash: JavaArray): void {
    if (!Object(lineAttributes.dash).equals__Ljava_lang_Object_2(dash)) {
      lineAttributes.dash = JavaArray(Object(dash).clone__());
      this.repaint__();
    }
    return;
  }
  public function setLineDashOffset__F(dashOffset: Number): void {
    if (lineAttributes.dashOffset != dashOffset) {
      lineAttributes.dashOffset = dashOffset;
      this.repaint__();
    }
    return;
  }
  public function setLineMiterLimit__F(miterLimit: Number): void {
    if (lineAttributes.miterLimit != miterLimit) {
      lineAttributes.miterLimit = miterLimit;
      this.repaint__();
    }
    return;
  }
}
}
