package org.eclipse.draw2d {
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.graph.Path;
import org.eclipse.draw2d.graph.ShortestPathRouter;
import java.util.Map;
import java.util.HashMap;
import java.util.Set;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.lang.Arguments;
dynamic public class ShortestPathConnectionRouter extends AbstractRouter {
  private var constraintMap: Map = new HashMap(new Arguments(java.util.HashMap.HashMap__, []));
  private var figuresToBounds: Map;
  private var connectionToPaths: Map;
  private var isDirty: Boolean;
  private var algorithm: ShortestPathRouter = new ShortestPathRouter();
  private var container: IFigure;
  private var staleConnections: Set = new HashSet(new Arguments(java.util.HashSet.HashSet__, []));
  private var listener: LayoutListener = new ShortestPathConnectionRouter$LayoutTracker(ShortestPathConnectionRouter(this));
  private var figureListener: FigureListener;
  private var ignoreInvalidate: Boolean;
  public function ShortestPathConnectionRouter(container: IFigure) {
    figureListener = new org.eclipse.draw2d.ShortestPathConnectionRouter$1(ShortestPathConnectionRouter(this));
    isDirty = false;
    algorithm = new ShortestPathRouter();
    this.container = container;
    return;
  }
  public function addChild__Lorg_eclipse_draw2d_IFigure_2(child: IFigure): void {
    if (connectionToPaths === null)
      return;
    if (figuresToBounds.containsKey__Ljava_lang_Object_2(child))
      return;
    var bounds: Rectangle = child.getBounds__().getCopy__();
    algorithm.addObstacle__Lorg_eclipse_draw2d_geometry_Rectangle_2(bounds);
    figuresToBounds.put__Ljava_lang_Object_2Ljava_lang_Object_2(child, bounds);
    child.addFigureListener__Lorg_eclipse_draw2d_FigureListener_2(figureListener);
    isDirty = true;
  }
  private function hookAll__(): void {
    figuresToBounds = new HashMap(new Arguments(java.util.HashMap.HashMap__, []));
    for (var i: int = 0; i < container.getChildren__().size__(); i++)
      this.addChild__Lorg_eclipse_draw2d_IFigure_2(IFigure(container.getChildren__().get__I(i)));
    container.addLayoutListener__Lorg_eclipse_draw2d_LayoutListener_2(listener);
  }
  private function unhookAll__(): void {
    container.removeLayoutListener__Lorg_eclipse_draw2d_LayoutListener_2(listener);
    if (figuresToBounds !== null) {
      var figureItr: Iterator = Iterator(figuresToBounds.keySet__().iterator__());
      while (figureItr.hasNext__()) {
        var child: IFigure = IFigure(figureItr.next__());
        figureItr.remove__();
        this.removeChild__Lorg_eclipse_draw2d_IFigure_2(child);
      }
      figuresToBounds = null;
    }
    return;
  }
  public override function getConstraint__Lorg_eclipse_draw2d_Connection_2(connection: Connection): Object {
    return constraintMap.get__Ljava_lang_Object_2(connection);
  }
  public function getSpacing__(): int {
    return algorithm.getSpacing__();
  }
  public override function invalidate__Lorg_eclipse_draw2d_Connection_2(connection: Connection): void {
    if (ignoreInvalidate)
      return;
    staleConnections.add__Ljava_lang_Object_2(connection);
    isDirty = true;
  }
  private function processLayout__(): void {
    if (staleConnections.isEmpty__())
      return;
    (Connection(Iterator(staleConnections.iterator__()).next__())).revalidate__();
  }
  private function processStaleConnections__(): void {
    var iter: Iterator = Iterator(staleConnections.iterator__());
    if (iter.hasNext__() && connectionToPaths === null) {
      connectionToPaths = new HashMap(new Arguments(java.util.HashMap.HashMap__, []));
      this.hookAll__();
    }
    while (iter.hasNext__()) {
      var conn: Connection = Connection(iter.next__());
      var path: Path = Path(connectionToPaths.get__Ljava_lang_Object_2(conn));
      if (path === null) {
        path = new Path(new Arguments(org.eclipse.draw2d.graph.Path.Path__Ljava_lang_Object_2, [conn]));
        connectionToPaths.put__Ljava_lang_Object_2Ljava_lang_Object_2(conn, path);
        algorithm.addPath__Lorg_eclipse_draw2d_graph_Path_2(path);
      }
      var constraint: List = List(this.getConstraint__Lorg_eclipse_draw2d_Connection_2(conn));
      if (constraint === null)
        constraint = Collections.EMPTY_LIST;
      var start: Point = conn.getSourceAnchor__().getReferencePoint__().getCopy__();
      var end: Point = conn.getTargetAnchor__().getReferencePoint__().getCopy__();
      container.translateToRelative__Lorg_eclipse_draw2d_geometry_Translatable_2(start);
      container.translateToRelative__Lorg_eclipse_draw2d_geometry_Translatable_2(end);
      path.setStartPoint__Lorg_eclipse_draw2d_geometry_Point_2(start);
      path.setEndPoint__Lorg_eclipse_draw2d_geometry_Point_2(end);
      if (!constraint.isEmpty__()) {
        var bends: PointList = new PointList(new Arguments(org.eclipse.draw2d.geometry.PointList.PointList__I, [constraint.size__()]));
        for (var i: int = 0; i < constraint.size__(); i++) {
          var bp: Bendpoint = Bendpoint(constraint.get__I(i));
          bends.addPoint__Lorg_eclipse_draw2d_geometry_Point_2(bp.getLocation__());
        }
        path.setBendPoints__Lorg_eclipse_draw2d_geometry_PointList_2(bends);
      } else
        path.setBendPoints__Lorg_eclipse_draw2d_geometry_PointList_2(null);
      isDirty = (isDirty) ? (path.isDirty, true) : (path.isDirty);
    }
    staleConnections.clear__();
    return;
  }
  public function queueSomeRouting__(): void {
    if (connectionToPaths === null || connectionToPaths.isEmpty__())
      return;
    try {
      ignoreInvalidate = true;
      (Connection(Iterator(connectionToPaths.keySet__().iterator__()).next__())).revalidate__();
    } finally {
      ignoreInvalidate = false;
    }
    return;
  }
  public override function remove__Lorg_eclipse_draw2d_Connection_2(connection: Connection): void {
    staleConnections.remove__Ljava_lang_Object_2(connection);
    constraintMap.remove__Ljava_lang_Object_2(connection);
    if (connectionToPaths === null)
      return;
    var path: Path = Path(connectionToPaths.remove__Ljava_lang_Object_2(connection));
    algorithm.removePath__Lorg_eclipse_draw2d_graph_Path_2(path);
    isDirty = true;
    if (connectionToPaths.isEmpty__()) {
      this.unhookAll__();
      connectionToPaths = null;
    } else {
      this.queueSomeRouting__();
    }
    return;
  }
  public function removeChild__Lorg_eclipse_draw2d_IFigure_2(child: IFigure): void {
    if (connectionToPaths === null)
      return;
    var bounds: Rectangle = child.getBounds__().getCopy__();
    var change: Boolean = algorithm.removeObstacle__Lorg_eclipse_draw2d_geometry_Rectangle_2(bounds);
    figuresToBounds.remove__Ljava_lang_Object_2(child);
    child.removeFigureListener__Lorg_eclipse_draw2d_FigureListener_2(figureListener);
    if (change) {
      isDirty = true;
      this.queueSomeRouting__();
    }
    return;
  }
  public override function route__Lorg_eclipse_draw2d_Connection_2(conn: Connection): void {
    if (isDirty) {
      ignoreInvalidate = true;
      this.processStaleConnections__();
      isDirty = false;
      var updated: List = algorithm.solve__();
      var current: Connection;
      for (var i: int = 0; i < updated.size__(); i++) {
        var path: Path = Path(updated.get__I(i));
        current = Connection(path.data);
        current.revalidate__();
        var points: PointList = path.getPoints__().getCopy__();
        var ref1: Point;
        var ref2: Point;
        var start: Point;
        var end: Point;
        ref1 = new PrecisionPoint(new Arguments(org.eclipse.draw2d.geometry.PrecisionPoint.PrecisionPoint__Lorg_eclipse_draw2d_geometry_Point_2, [points.getPoint__I(1)]));
        ref2 = new PrecisionPoint(new Arguments(org.eclipse.draw2d.geometry.PrecisionPoint.PrecisionPoint__Lorg_eclipse_draw2d_geometry_Point_2, [points.getPoint__I(points.size__() - 2)]));
        current.translateToAbsolute__Lorg_eclipse_draw2d_geometry_Translatable_2(ref1);
        current.translateToAbsolute__Lorg_eclipse_draw2d_geometry_Translatable_2(ref2);
        start = current.getSourceAnchor__().getLocation__Lorg_eclipse_draw2d_geometry_Point_2(ref1).getCopy__();
        end = current.getTargetAnchor__().getLocation__Lorg_eclipse_draw2d_geometry_Point_2(ref2).getCopy__();
        current.translateToRelative__Lorg_eclipse_draw2d_geometry_Translatable_2(start);
        current.translateToRelative__Lorg_eclipse_draw2d_geometry_Translatable_2(end);
        points.setPoint__Lorg_eclipse_draw2d_geometry_Point_2I(start, 0);
        points.setPoint__Lorg_eclipse_draw2d_geometry_Point_2I(end, points.size__() - 1);
        current.setPoints__Lorg_eclipse_draw2d_geometry_PointList_2(points);
      }
      ignoreInvalidate = false;
    }
    return;
  }
  public function getPathsAfterRouting__(): List {
    if (isDirty) {
      this.processStaleConnections__();
      isDirty = false;
      var all: List = algorithm.solve__();
      return all;
    }
    return null;
  }
  public override function setConstraint__Lorg_eclipse_draw2d_Connection_2Ljava_lang_Object_2(connection: Connection, constraint: Object): void {
    staleConnections.add__Ljava_lang_Object_2(connection);
    constraintMap.put__Ljava_lang_Object_2Ljava_lang_Object_2(connection, constraint);
    isDirty = true;
  }
  public function setSpacing__I(spacing: int): void {
    algorithm.setSpacing__I(spacing);
  }
  public function hasMoreConnections__(): Boolean {
    return connectionToPaths !== null && !connectionToPaths.isEmpty__();
  }
  public function getContainer__(): IFigure {
    return container;
  }
  public function setIgnoreInvalidate__Z(b: Boolean): void {
    ignoreInvalidate = b;
  }
  public function shouldIgnoreInvalidate__(): Boolean {
    return ignoreInvalidate;
  }
  public function isDirty__(): Boolean {
    return isDirty;
  }
  public function containsConnection__Lorg_eclipse_draw2d_Connection_2(conn: Connection): Boolean {
    return connectionToPaths !== null && connectionToPaths.containsKey__Ljava_lang_Object_2(conn);
  }
  public static function access$0(arg0: ShortestPathConnectionRouter): ShortestPathRouter {
    return arg0.algorithm;
  }
  public static function access$1(arg0: ShortestPathConnectionRouter): Map {
    return arg0.figuresToBounds;
  }
  public static function access$2(arg0: ShortestPathConnectionRouter, arg1: Boolean): void {
    arg0.isDirty = arg1;
  }
  public static function access$3(arg0: ShortestPathConnectionRouter): void {
    arg0.processLayout__();
  }
}
}
