package org.eclipse.draw2d {
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import java.lang.Math__;
import java.util.List;
import java.lang.Arguments;
dynamic public class StackLayout extends AbstractHintLayout {
  public override function calculateMinimumSize__Lorg_eclipse_draw2d_IFigure_2II(figure: IFigure, wHint: int, hHint: int): Dimension {
    if (wHint > -1)
      wHint = Math__.max__II(0, wHint - figure.getInsets__().getWidth__());
    if (hHint > -1)
      hHint = Math__.max__II(0, hHint - figure.getInsets__().getHeight__());
    var d: Dimension = new Dimension(new Arguments(org.eclipse.draw2d.geometry.Dimension.Dimension__, []));
    var children: List = figure.getChildren__();
    var child: IFigure;
    for (var i: int = 0; i < children.size__(); i++) {
      child = IFigure(children.get__I(i));
      if (!this.isObservingVisibility__() || child.isVisible__())
        d.union__Lorg_eclipse_draw2d_geometry_Dimension_2(child.getMinimumSize__II(wHint, hHint));
    }
    d.expand__II(figure.getInsets__().getWidth__(), figure.getInsets__().getHeight__());
    d.union__Lorg_eclipse_draw2d_geometry_Dimension_2(this.getBorderPreferredSize__Lorg_eclipse_draw2d_IFigure_2(figure));
    return d;
  }
  public override function calculatePreferredSize__Lorg_eclipse_draw2d_IFigure_2II(figure: IFigure, wHint: int, hHint: int): Dimension {
    if (wHint > -1)
      wHint = Math__.max__II(0, wHint - figure.getInsets__().getWidth__());
    if (hHint > -1)
      hHint = Math__.max__II(0, hHint - figure.getInsets__().getHeight__());
    var d: Dimension = new Dimension(new Arguments(org.eclipse.draw2d.geometry.Dimension.Dimension__, []));
    var children: List = figure.getChildren__();
    var child: IFigure;
    for (var i: int = 0; i < children.size__(); i++) {
      child = IFigure(children.get__I(i));
      if (!this.isObservingVisibility__() || child.isVisible__())
        d.union__Lorg_eclipse_draw2d_geometry_Dimension_2(child.getPreferredSize__II(wHint, hHint));
    }
    d.expand__II(figure.getInsets__().getWidth__(), figure.getInsets__().getHeight__());
    d.union__Lorg_eclipse_draw2d_geometry_Dimension_2(this.getBorderPreferredSize__Lorg_eclipse_draw2d_IFigure_2(figure));
    return d;
  }
  public override function layout__Lorg_eclipse_draw2d_IFigure_2(figure: IFigure): void {
    var r: Rectangle = figure.getClientArea__();
    var children: List = figure.getChildren__();
    var child: IFigure;
    for (var i: int = 0; i < children.size__(); i++) {
      child = IFigure(children.get__I(i));
      child.setBounds__Lorg_eclipse_draw2d_geometry_Rectangle_2(r);
    }
    return;
  }
}
}
