package org.eclipse.draw2d {
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.draw2d.geometry.Dimension;
dynamic public class TextUtilities {
  public static var INSTANCE: TextUtilities = new TextUtilities();
  public function getStringExtents__Ljava_lang_String_2Lorg_eclipse_swt_graphics_Font_2(s: String, f: Font): Dimension {
    return FigureUtilities.getStringExtents__Ljava_lang_String_2Lorg_eclipse_swt_graphics_Font_2(s, f);
  }
  public function getTextExtents__Ljava_lang_String_2Lorg_eclipse_swt_graphics_Font_2(s: String, f: Font): Dimension {
    return FigureUtilities.getTextExtents__Ljava_lang_String_2Lorg_eclipse_swt_graphics_Font_2(s, f);
  }
  public function getAscent__Lorg_eclipse_swt_graphics_Font_2(font: Font): int {
    var fm: FontMetrics = FigureUtilities.getFontMetrics__Lorg_eclipse_swt_graphics_Font_2(font);
    return fm.getHeight__() - fm.getDescent__();
  }
  public function getDescent__Lorg_eclipse_swt_graphics_Font_2(font: Font): int {
    return FigureUtilities.getFontMetrics__Lorg_eclipse_swt_graphics_Font_2(font).getDescent__();
  }
  public function getLargestSubstringConfinedTo__Ljava_lang_String_2Lorg_eclipse_swt_graphics_Font_2I(s: String, f: Font, availableWidth: int): int {
    var metrics: FontMetrics = FigureUtilities.getFontMetrics__Lorg_eclipse_swt_graphics_Font_2(f);
    var min: int;
    var max: int;
    var avg: Number = metrics.getAverageCharWidth__();
    min = 0;
    max = Object(s).length__() + 1;
    var guess: int = 0;
    var guessSize: int = 0;
    while ((max - min) > 1) {
      guess = guess + int(((availableWidth - guessSize) / avg));
      if (guess >= max)
        guess = max - 1;
      if (guess <= min)
        guess = min + 1;
      guessSize = this.getTextExtents__Ljava_lang_String_2Lorg_eclipse_swt_graphics_Font_2(Object(s).substring__II(0, guess), f).width;
      if (guessSize < availableWidth)
        min = guess;
      else
        max = guess;
    }
    return min;
  }
}
}
