package org.eclipse.draw2d {
import org.eclipse.swt.graphics.Color;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import java.lang.Math__;
import java.lang.Arguments;
dynamic public class TitleBarBorder extends AbstractLabeledBorder {
  public static var defaultColor: Color = org.eclipse.draw2d.ColorConstants$$fields.menuBackgroundSelected;
  private var textAlignment: int = 1;
  private var padding: Insets = new Insets(new Arguments(org.eclipse.draw2d.geometry.Insets.Insets__IIII, [1, 3, 2, 2]));
  private var fillColor: Color = defaultColor;
  public function TitleBarBorder__(): Object {
    return this;
  }
  public function TitleBarBorder__Ljava_lang_String_2(s: String): Object {
    this.setLabel__Ljava_lang_String_2(s);
    return this;
  }
  public override function calculateInsets__Lorg_eclipse_draw2d_IFigure_2(figure: IFigure): Insets {
    return new Insets(new Arguments(org.eclipse.draw2d.geometry.Insets.Insets__IIII, [this.getTextExtents__Lorg_eclipse_draw2d_IFigure_2(figure).height + padding.getHeight__(), 0, 0, 0]));
  }
  public function getBackgroundColor__(): Color {
    return fillColor;
  }
  public function getPadding__(): Insets {
    return padding;
  }
  public function getTextAlignment__(): int {
    return textAlignment;
  }
  public override function isOpaque__(): Boolean {
    return true;
  }
  public override function paint__Lorg_eclipse_draw2d_IFigure_2Lorg_eclipse_draw2d_Graphics_2Lorg_eclipse_draw2d_geometry_Insets_2(figure: IFigure, g: Graphics, insets_1: Insets): void {
    AbstractBorder.tempRect.setBounds__Lorg_eclipse_draw2d_geometry_Rectangle_2(AbstractBorder.getPaintRectangle__Lorg_eclipse_draw2d_IFigure_2Lorg_eclipse_draw2d_geometry_Insets_2(figure, insets_1));
    var rec: Rectangle = AbstractBorder.tempRect;
    rec.height = Math__.min__II(rec.height, this.getTextExtents__Lorg_eclipse_draw2d_IFigure_2(figure).height + padding.getHeight__());
    g.clipRect__Lorg_eclipse_draw2d_geometry_Rectangle_2(rec);
    g.setBackgroundColor__Lorg_eclipse_swt_graphics_Color_2(fillColor);
    g.fillRectangle__Lorg_eclipse_draw2d_geometry_Rectangle_2(rec);
    var x: int = rec.x + padding.left;
    var y: int = rec.y + padding.top;
    var textWidth: int = this.getTextExtents__Lorg_eclipse_draw2d_IFigure_2(figure).width;
    var freeSpace: int = rec.width - padding.getWidth__() - textWidth;
    if (this.getTextAlignment__() == 2)
      freeSpace /= 2;
    if (this.getTextAlignment__() != 1)
      x += freeSpace;
    g.setFont__Lorg_eclipse_swt_graphics_Font_2(this.getFont__Lorg_eclipse_draw2d_IFigure_2(figure));
    g.setForegroundColor__Lorg_eclipse_swt_graphics_Color_2(this.getTextColor__());
    g.drawString__Ljava_lang_String_2II(this.getLabel__(), x, y);
  }
  public function setBackgroundColor__Lorg_eclipse_swt_graphics_Color_2(color: Color): void {
    fillColor = color;
  }
  public function setPadding__I(all: int): void {
    padding = new Insets(new Arguments(org.eclipse.draw2d.geometry.Insets.Insets__I, [all]));
    this.invalidate__();
  }
  public function setPadding__Lorg_eclipse_draw2d_geometry_Insets_2(pad: Insets): void {
    padding = pad;
    this.invalidate__();
  }
  public function setTextAlignment__I(align: int): void {
    textAlignment = align;
  }
  public function TitleBarBorder(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is String) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        var superArgs: Arguments;
        superArgs = new Arguments(org.eclipse.draw2d.AbstractLabeledBorder.AbstractLabeledBorder__, []);
        break;
      case 1:
        var args1: Array = [args[0]];
        superArgs = new Arguments(org.eclipse.draw2d.AbstractLabeledBorder.AbstractLabeledBorder__, []);
        break;
    }
    super(superArgs);
    switch (id) {
      case 0:
        TitleBarBorder__();
        break;
      case 1:
        TitleBarBorder__Ljava_lang_String_2(args1[0]);
        break;
    }
  }
  public static const TitleBarBorder__ : int = 0;
  public static const TitleBarBorder__Ljava_lang_String_2 : int = 1;
}
}
