package org.eclipse.draw2d {
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.graphics.Rectangle;
import java.lang.Runnable;
import org.eclipse.swt.events.MouseEvent;
import java.lang.Arguments;
dynamic public class ToolTipHelper extends PopUpHelper {
  private var timer: Timer;
  private var currentTipSource: IFigure;
  public function ToolTipHelper(c: Control) {
    super(new Arguments(org.eclipse.draw2d.PopUpHelper.PopUpHelper__Lorg_eclipse_swt_widgets_Control_2I, [c, 4 | 16384]));
    this.getShell__().setBackground__Lorg_eclipse_swt_graphics_Color_2(org.eclipse.draw2d.ColorConstants$$fields.tooltipBackground);
    this.getShell__().setForeground__Lorg_eclipse_swt_graphics_Color_2(org.eclipse.draw2d.ColorConstants$$fields.tooltipForeground);
    return;
  }
  private function computeWindowLocation__Lorg_eclipse_draw2d_IFigure_2II(tip: IFigure, eventX: int, eventY: int): Point {
    var clientArea: Rectangle = control.getDisplay__().getClientArea__();
    var preferredLocation: Point = new Point(eventX, eventY + 26);
    var tipSize: Dimension = this.getLightweightSystem__().getRootFigure__().getPreferredSize__().getExpanded__Lorg_eclipse_draw2d_geometry_Dimension_2(this.getShellTrimSize__());
    if (preferredLocation.y + tipSize.height > clientArea.height)
      preferredLocation.y = eventY - tipSize.height;
    if (preferredLocation.x + tipSize.width > clientArea.width)
      preferredLocation.x -= (preferredLocation.x + tipSize.width) - clientArea.width;
    return preferredLocation;
  }
  public function displayToolTipNear__Lorg_eclipse_draw2d_IFigure_2Lorg_eclipse_draw2d_IFigure_2II(hoverSource: IFigure, tip: IFigure, eventX: int, eventY: int): void {
    if (tip !== null && hoverSource !== currentTipSource) {
      this.getLightweightSystem__().setContents__Lorg_eclipse_draw2d_IFigure_2(tip);
      var displayPoint: Point = this.computeWindowLocation__Lorg_eclipse_draw2d_IFigure_2II(tip, eventX, eventY);
      var shellSize: Dimension = this.getLightweightSystem__().getRootFigure__().getPreferredSize__().getExpanded__Lorg_eclipse_draw2d_geometry_Dimension_2(this.getShellTrimSize__());
      this.setShellBounds__IIII(displayPoint.x, displayPoint.y, shellSize.width, shellSize.height);
      this.show__();
      currentTipSource = hoverSource;
      timer = new Timer(new Arguments(java.util.Timer.Timer__Z, [true]));
      timer.schedule__Ljava_util_TimerTask_2J(new ToolTipHelper$1(this), 5000);
    }
    return;
  }
  public override function dispose__(): void {
    if (this.isShowing__()) {
      timer.cancel__();
      this.hide__();
    }
    this.getShell__().dispose__();
    return;
  }
  public override function hookShellListeners__(): void {
    this.getShell__().addMouseTrackListener__Lorg_eclipse_swt_events_MouseTrackListener_2(new org.eclipse.draw2d.ToolTipHelper$2(this));
    return;
  }
  public function updateToolTip__Lorg_eclipse_draw2d_IFigure_2Lorg_eclipse_draw2d_IFigure_2II(figureUnderMouse: IFigure, tip: IFigure, eventX: int, eventY: int): void {
    if (figureUnderMouse === null) {
      if (this.isShowing__()) {
        this.hide__();
        timer.cancel__();
      }
    }
    if (this.isShowing__() && figureUnderMouse !== currentTipSource) {
      this.hide__();
      timer.cancel__();
      this.displayToolTipNear__Lorg_eclipse_draw2d_IFigure_2Lorg_eclipse_draw2d_IFigure_2II(figureUnderMouse, tip, eventX, eventY);
    } else if (!this.isShowing__() && figureUnderMouse !== currentTipSource)
      currentTipSource = null;
    return;
  }
  public static function access$0(arg0: ToolTipHelper): Timer {
    return arg0.timer;
  }
  public static function access$1(arg0: ToolTipHelper, arg1: IFigure): void {
    arg0.currentTipSource = arg1;
  }
}
}
