package org.eclipse.draw2d {
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Transposer;
import java.util.List;
import java.lang.Math__;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class ToolbarLayout extends AbstractHintLayout {
  public var spacing: int;
  public var matchWidth: Boolean;
  public var horizontal: Boolean = false;
  public var minorAlignment: int;
  public static const ALIGN_CENTER: int = 0;
  public static const ALIGN_TOPLEFT: int = 1;
  public static const ALIGN_BOTTOMRIGHT: int = 2;
  public static const HORIZONTAL: Boolean = true;
  public static const VERTICAL: Boolean = false;
  public var transposer: Transposer;
  public function ToolbarLayout__(): Object {
    {
      transposer = new Transposer();
      transposer.setEnabled__Z(horizontal);
    }
    spacing = 0;
    matchWidth = true;
    minorAlignment = 1;
    horizontal = false;
    return this;
  }
  public function ToolbarLayout__Z(isHorizontal: Boolean): Object {
    {
      transposer = new Transposer();
      transposer.setEnabled__Z(horizontal);
    }
    horizontal = isHorizontal;
    transposer.setEnabled__Z(horizontal);
    spacing = 0;
    matchWidth = false;
    minorAlignment = 1;
    return this;
  }
  private function calculateChildrenSize__Ljava_util_List_2IIZ(children: List, wHint: int, hHint: int, preferred: Boolean): Dimension {
    var childSize: Dimension;
    var child: IFigure;
    var height: int = 0;
    var width: int = 0;
    for (var i: int = 0; i < children.size__(); i++) {
      child = IFigure(children.get__I(i));
      childSize = transposer.t__Lorg_eclipse_draw2d_geometry_Dimension_2(preferred ? this.getChildPreferredSize__Lorg_eclipse_draw2d_IFigure_2II(child, wHint, hHint) : this.getChildMinimumSize__Lorg_eclipse_draw2d_IFigure_2II(child, wHint, hHint));
      height += childSize.height;
      width = Math__.max__II(width, childSize.width);
    }
    return new Dimension(new Arguments(org.eclipse.draw2d.geometry.Dimension.Dimension__II, [width, height]));
  }
  public override function calculateMinimumSize__Lorg_eclipse_draw2d_IFigure_2II(container: IFigure, wHint: int, hHint: int): Dimension {
    var insets: Insets = container.getInsets__();
    if (this.isHorizontal__()) {
      wHint = -1;
      if (hHint >= 0)
        hHint = Math__.max__II(0, hHint - insets.getHeight__());
    } else {
      hHint = -1;
      if (wHint >= 0)
        wHint = Math__.max__II(0, wHint - insets.getWidth__());
    }
    var children: List = container.getChildren__();
    var minSize: Dimension = this.calculateChildrenSize__Ljava_util_List_2IIZ(children, wHint, hHint, false);
    if (wHint >= 0 && minSize.width > wHint) {
      minSize = this.calculateChildrenSize__Ljava_util_List_2IIZ(children, minSize.width, hHint, false);
    } else if (hHint >= 0 && minSize.width > hHint) {
      minSize = this.calculateChildrenSize__Ljava_util_List_2IIZ(children, wHint, minSize.width, false);
    }
    minSize.height += Math__.max__II(0, children.size__() - 1) * spacing;
    return transposer.t__Lorg_eclipse_draw2d_geometry_Dimension_2(minSize).expand__II(insets.getWidth__(), insets.getHeight__()).union__Lorg_eclipse_draw2d_geometry_Dimension_2(this.getBorderPreferredSize__Lorg_eclipse_draw2d_IFigure_2(container));
  }
  public override function calculatePreferredSize__Lorg_eclipse_draw2d_IFigure_2II(container: IFigure, wHint: int, hHint: int): Dimension {
    var insets: Insets = container.getInsets__();
    if (this.isHorizontal__()) {
      wHint = -1;
      if (hHint >= 0)
        hHint = Math__.max__II(0, hHint - insets.getHeight__());
    } else {
      hHint = -1;
      if (wHint >= 0)
        wHint = Math__.max__II(0, wHint - insets.getWidth__());
    }
    var children: List = container.getChildren__();
    var prefSize: Dimension = this.calculateChildrenSize__Ljava_util_List_2IIZ(children, wHint, hHint, true);
    if (wHint >= 0 && prefSize.width > wHint) {
      prefSize = this.calculateChildrenSize__Ljava_util_List_2IIZ(children, prefSize.width, hHint, true);
    } else if (hHint >= 0 && prefSize.width > hHint) {
      prefSize = this.calculateChildrenSize__Ljava_util_List_2IIZ(children, wHint, prefSize.width, true);
    }
    prefSize.height += Math__.max__II(0, children.size__() - 1) * spacing;
    return transposer.t__Lorg_eclipse_draw2d_geometry_Dimension_2(prefSize).expand__II(insets.getWidth__(), insets.getHeight__()).union__Lorg_eclipse_draw2d_geometry_Dimension_2(this.getBorderPreferredSize__Lorg_eclipse_draw2d_IFigure_2(container));
  }
  public function getChildMinimumSize__Lorg_eclipse_draw2d_IFigure_2II(child: IFigure, wHint: int, hHint: int): Dimension {
    return child.getMinimumSize__II(wHint, hHint);
  }
  public function getChildPreferredSize__Lorg_eclipse_draw2d_IFigure_2II(child: IFigure, wHint: int, hHint: int): Dimension {
    return child.getPreferredSize__II(wHint, hHint);
  }
  public function getMinorAlignment__(): int {
    return minorAlignment;
  }
  public function getSpacing__(): int {
    return spacing;
  }
  public function getStretchMinorAxis__(): Boolean {
    return matchWidth;
  }
  public function isHorizontal__(): Boolean {
    return horizontal;
  }
  public override function isSensitiveHorizontally__Lorg_eclipse_draw2d_IFigure_2(parent: IFigure): Boolean {
    return !this.isHorizontal__();
  }
  public override function isSensitiveVertically__Lorg_eclipse_draw2d_IFigure_2(parent: IFigure): Boolean {
    return this.isHorizontal__();
  }
  public override function layout__Lorg_eclipse_draw2d_IFigure_2(parent: IFigure): void {
    var children: List = parent.getChildren__();
    var numChildren: int = children.size__();
    var clientArea: Rectangle = transposer.t__Lorg_eclipse_draw2d_geometry_Rectangle_2(parent.getClientArea__());
    var x: int = clientArea.x;
    var y: int = clientArea.y;
    var availableHeight: int = clientArea.height;
    var prefSizes: JavaArray = new JavaArray("[Lorg/eclipse/draw2d/geometry/Dimension;").lengths(numChildren);
    var minSizes: JavaArray = new JavaArray("[Lorg/eclipse/draw2d/geometry/Dimension;").lengths(numChildren);
    var wHint: int = -1;
    var hHint: int = -1;
    if (this.isHorizontal__()) {
      hHint = parent.getClientArea__Lorg_eclipse_draw2d_geometry_Rectangle_2(Rectangle.SINGLETON).height;
    } else {
      wHint = parent.getClientArea__Lorg_eclipse_draw2d_geometry_Rectangle_2(Rectangle.SINGLETON).width;
    }
    var child: IFigure;
    var totalHeight: int = 0;
    var totalMinHeight: int = 0;
    var prefMinSumHeight: int = 0;
    for (var i: int = 0; i < numChildren; i++) {
      child = IFigure(children.get__I(i));
      prefSizes[i] = transposer.t__Lorg_eclipse_draw2d_geometry_Dimension_2(this.getChildPreferredSize__Lorg_eclipse_draw2d_IFigure_2II(child, wHint, hHint));
      minSizes[i] = transposer.t__Lorg_eclipse_draw2d_geometry_Dimension_2(this.getChildMinimumSize__Lorg_eclipse_draw2d_IFigure_2II(child, wHint, hHint));
      totalHeight += prefSizes[i].height;
      totalMinHeight += minSizes[i].height;
    }
    totalHeight += (numChildren - 1) * spacing;
    totalMinHeight += (numChildren - 1) * spacing;
    prefMinSumHeight = totalHeight - totalMinHeight;
    var amntShrinkHeight: int = totalHeight - Math__.max__II(availableHeight, totalMinHeight);
    if (amntShrinkHeight < 0) {
      amntShrinkHeight = 0;
    }
    for (var i_1: int = 0; i_1 < numChildren; i_1++) {
      var amntShrinkCurrentHeight: int = 0;
      var prefHeight: int = prefSizes[i_1].height;
      var minHeight: int = minSizes[i_1].height;
      var prefWidth: int = prefSizes[i_1].width;
      var minWidth: int = minSizes[i_1].width;
      var newBounds: Rectangle = new Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__IIII, [x, y, prefWidth, prefHeight]));
      child = IFigure(children.get__I(i_1));
      if (prefMinSumHeight != 0)
        amntShrinkCurrentHeight = int((prefHeight - minHeight) * amntShrinkHeight / (prefMinSumHeight));
      var width: int = Math__.min__II(prefWidth, transposer.t__Lorg_eclipse_draw2d_geometry_Dimension_2(child.getMaximumSize__()).width);
      if (matchWidth)
        width = transposer.t__Lorg_eclipse_draw2d_geometry_Dimension_2(child.getMaximumSize__()).width;
      width = Math__.max__II(minWidth, Math__.min__II(clientArea.width, width));
      newBounds.width = width;
      var adjust: int = clientArea.width - width;
      switch (minorAlignment) {
        case 1 :
          adjust = 0;
          break;
        case 0 :
          adjust /= 2;
          break;
        case 2 :
          break;
      }
      newBounds.x += adjust;
      newBounds.height -= amntShrinkCurrentHeight;
      child.setBounds__Lorg_eclipse_draw2d_geometry_Rectangle_2(transposer.t__Lorg_eclipse_draw2d_geometry_Rectangle_2(newBounds));
      amntShrinkHeight -= amntShrinkCurrentHeight;
      prefMinSumHeight -= (prefHeight - minHeight);
      y += newBounds.height + spacing;
    }
    return;
  }
  public function setMinorAlignment__I(align: int): void {
    minorAlignment = align;
    return;
  }
  public function setSpacing__I(space: int): void {
    spacing = space;
    return;
  }
  public function setMatchWidth__Z(match: Boolean): void {
    matchWidth = match;
    return;
  }
  public function setStretchMinorAxis__Z(stretch: Boolean): void {
    matchWidth = stretch;
    return;
  }
  public function setVertical__Z(flag: Boolean): void {
    if (horizontal != flag)
      return;
    this.invalidate__();
    horizontal = !flag;
    transposer.setEnabled__Z(horizontal);
  }
  public function ToolbarLayout(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is Boolean) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        break;
      case 1:
        var args1: Array = [args[0]];
        break;
    }
    super();
    switch (id) {
      case 0:
        ToolbarLayout__();
        break;
      case 1:
        ToolbarLayout__Z(args1[0]);
        break;
    }
  }
  public static const ToolbarLayout__ : int = 0;
  public static const ToolbarLayout__Z : int = 1;
}
}
