package org.eclipse.draw2d {
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import java.lang.Math__;
import java.lang.Arguments;
dynamic public class Triangle extends Shape implements Orientable {
  public var direction: int = 1;
  public var orientation: int = 1;
  public var triangle: PointList = new PointList(new Arguments(org.eclipse.draw2d.geometry.PointList.PointList__I, [3]));
  public override function fillShape__Lorg_eclipse_draw2d_Graphics_2(g: Graphics): void {
    g.fillPolygon__Lorg_eclipse_draw2d_geometry_PointList_2(triangle);
    return;
  }
  public override function outlineShape__Lorg_eclipse_draw2d_Graphics_2(g: Graphics): void {
    g.drawPolygon__Lorg_eclipse_draw2d_geometry_PointList_2(triangle);
    return;
  }
  public override function primTranslate__II(dx: int, dy: int): void {
    super.primTranslate__II(dx, dy);
    triangle.translate__II(dx, dy);
    return;
  }
  public function setDirection__I(value: int): void {
    if ((value & (1 | 4)) != 0)
      orientation = 1;
    else
      orientation = 0;
    direction = value;
    this.revalidate__();
    this.repaint__();
    return;
  }
  public function setOrientation__I(value: int): void {
    if (orientation == 1 && value == 0) {
      if (direction == 1)
        this.setDirection__I(8);
      else
        this.setDirection__I(16);
    }
    if (orientation == 0 && value == 1) {
      if (direction == 8)
        this.setDirection__I(1);
      else
        this.setDirection__I(4);
    }
    return;
  }
  public override function validate__(): void {
    super.validate__();
    var r: Rectangle = new Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__, []));
    r.setBounds__Lorg_eclipse_draw2d_geometry_Rectangle_2(this.getBounds__());
    r.crop__Lorg_eclipse_draw2d_geometry_Insets_2(this.getInsets__());
    r.resize__II(-1, -1);
    var size: int;
    switch (direction & (1 | 4)) {
      case 0 :
        size = Math__.min__II(int(r.height / 2), r.width);
        r.x += int((r.width - size) / 2);
        break;
      default :
        size = Math__.min__II(r.height, int(r.width / 2));
        r.y += int((r.height - size) / 2);
        break;
    }
    size = Math__.max__II(size, 1);
    var head: Point;
    var p2: Point;
    var p3: Point;
    switch (direction) {
      case 1 :
        head = new Point(new Arguments(org.eclipse.draw2d.geometry.Point.Point__II, [r.x + int(r.width / 2), r.y]));
        p2 = new Point(new Arguments(org.eclipse.draw2d.geometry.Point.Point__II, [head.x - size, head.y + size]));
        p3 = new Point(new Arguments(org.eclipse.draw2d.geometry.Point.Point__II, [head.x + size, head.y + size]));
        break;
      case 4 :
        head = new Point(new Arguments(org.eclipse.draw2d.geometry.Point.Point__II, [r.x + int(r.width / 2), r.y + size]));
        p2 = new Point(new Arguments(org.eclipse.draw2d.geometry.Point.Point__II, [head.x - size, head.y - size]));
        p3 = new Point(new Arguments(org.eclipse.draw2d.geometry.Point.Point__II, [head.x + size, head.y - size]));
        break;
      case 8 :
        head = new Point(new Arguments(org.eclipse.draw2d.geometry.Point.Point__II, [r.x, r.y + int(r.height / 2)]));
        p2 = new Point(new Arguments(org.eclipse.draw2d.geometry.Point.Point__II, [head.x + size, head.y - size]));
        p3 = new Point(new Arguments(org.eclipse.draw2d.geometry.Point.Point__II, [head.x + size, head.y + size]));
        break;
      default :
        head = new Point(new Arguments(org.eclipse.draw2d.geometry.Point.Point__II, [r.x + size, r.y + int(r.height / 2)]));
        p2 = new Point(new Arguments(org.eclipse.draw2d.geometry.Point.Point__II, [head.x - size, head.y - size]));
        p3 = new Point(new Arguments(org.eclipse.draw2d.geometry.Point.Point__II, [head.x - size, head.y + size]));
    }
    triangle.removeAllPoints__();
    triangle.addPoint__Lorg_eclipse_draw2d_geometry_Point_2(head);
    triangle.addPoint__Lorg_eclipse_draw2d_geometry_Point_2(p2);
    triangle.addPoint__Lorg_eclipse_draw2d_geometry_Point_2(p3);
    return;
  }
}
}
