package org.eclipse.draw2d {
import java.util.Map;
import org.eclipse.swt.graphics.GC;
import org.eclipse.draw2d.geometry.Rectangle;
import java.lang.Runnable;
import java.lang.IllegalArgumentException;
import java.lang.System;
import java.util.Map;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class UpdateManager {
  private var listeners: JavaArray = new JavaArray("[Lorg/eclipse/draw2d/UpdateListener;").lengths(0);
  private var disposed: Boolean;
  public function addDirtyRegion__Lorg_eclipse_draw2d_IFigure_2IIII(figure: IFigure, x: int, y: int, w: int, h: int): void { } // abstract
  public function addDirtyRegion__Lorg_eclipse_draw2d_IFigure_2Lorg_eclipse_draw2d_geometry_Rectangle_2(figure: IFigure, rect: Rectangle): void {
    this.addDirtyRegion__Lorg_eclipse_draw2d_IFigure_2IIII(figure, rect.x, rect.y, rect.width, rect.height);
    return;
  }
  public function runWithUpdate__Ljava_lang_Runnable_2(run: Runnable): void {
  }
  public function addInvalidFigure__Lorg_eclipse_draw2d_IFigure_2(figure: IFigure): void { } // abstract
  public function addUpdateListener__Lorg_eclipse_draw2d_UpdateListener_2(listener: UpdateListener): void {
    if (listener === null)
      throw new IllegalArgumentException(new Arguments(java.lang.IllegalArgumentException.IllegalArgumentException__, []));
    if (listeners === null) {
      listeners = new JavaArray("[Lorg/eclipse/draw2d/UpdateListener;").lengths(1);
      listeners[0] = listener;
    } else {
      var oldSize: int = listeners.length;
      var newListeners: JavaArray = new JavaArray("[Lorg/eclipse/draw2d/UpdateListener;").lengths(oldSize + 1);
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(listeners, 0, newListeners, 0, oldSize);
      newListeners[oldSize] = listener;
      listeners = newListeners;
    }
    return;
  }
  public function dispose__(): void {
    disposed = true;
    return;
  }
  public function firePainting__Lorg_eclipse_draw2d_geometry_Rectangle_2Ljava_util_Map_2(damage: Rectangle, dirtyRegions: Map): void {
    var localListeners: JavaArray = listeners;
    for (var i: int = 0; i < localListeners.length; i++)
      localListeners[i].notifyPainting__Lorg_eclipse_draw2d_geometry_Rectangle_2Ljava_util_Map_2(damage, dirtyRegions);
    return;
  }
  public function fireValidating__(): void {
    var localListeners: JavaArray = listeners;
    for (var i: int = 0; i < localListeners.length; i++)
      localListeners[i].notifyValidating__();
    return;
  }
  public function isDisposed__(): Boolean {
    return disposed;
  }
  public function performUpdate__(): void { } // abstract
  public function paint__Lorg_eclipse_swt_graphics_GC_2(gc: GC): void {
    this.performUpdate__Lorg_eclipse_draw2d_geometry_Rectangle_2(new Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__Lorg_eclipse_swt_graphics_Rectangle_2, [gc.getClipping__()])));
  }
  public function performUpdate__Lorg_eclipse_draw2d_geometry_Rectangle_2(exposed: Rectangle): void { } // abstract
  public function removeUpdateListener__Lorg_eclipse_draw2d_UpdateListener_2(listener: UpdateListener): void {
    if (listener === null)
      throw new IllegalArgumentException(new Arguments(java.lang.IllegalArgumentException.IllegalArgumentException__, []));
    for (var index: int = 0; index < listeners.length; index++)
      if (listeners[index] === listener) {
        var newSize: int = listeners.length - 1;
        var newListeners: JavaArray = null;
        if (newSize != 0) {
          newListeners = new JavaArray("[Lorg/eclipse/draw2d/UpdateListener;").lengths(newSize);
          System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(listeners, 0, newListeners, 0, index);
          System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(listeners, index + 1, newListeners, index, newSize - index);
        } else {
          newListeners = new JavaArray("[Lorg/eclipse/draw2d/UpdateListener;").lengths(0);
        }
        listeners = newListeners;
        return;
      }
    return;
  }
  public function setGraphicsSource__Lorg_eclipse_draw2d_GraphicsSource_2(gs: GraphicsSource): void { } // abstract
  public function setRoot__Lorg_eclipse_draw2d_IFigure_2(figure: IFigure): void { } // abstract
  public function performValidation__(): void {
    this.performUpdate__();
    return;
  }
}
}
