package org.eclipse.draw2d {
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import java.lang.Arguments;
dynamic public class Viewport extends Figure implements PropertyChangeListener {
  public static const PROPERTY_VIEW_LOCATION: String = "viewLocation";
  private var view: IFigure;
  private var useTranslate: Boolean = false;
  private var trackWidth: Boolean = false;
  private var trackHeight: Boolean = false;
  private var ignoreScroll: Boolean = false;
  private var horiztonalRangeModel: RangeModel = null;
  private var verticalRangeModel: RangeModel = null;
  public function Viewport__(): Object {
    {
      this.setLayoutManager__Lorg_eclipse_draw2d_LayoutManager_2(new ViewportLayout());
      this.setHorizontalRangeModel__Lorg_eclipse_draw2d_RangeModel_2(new DefaultRangeModel());
      this.setVerticalRangeModel__Lorg_eclipse_draw2d_RangeModel_2(new DefaultRangeModel());
    }
    return this;
  }
  public function Viewport__Z(setting: Boolean): Object {
    {
      this.setLayoutManager__Lorg_eclipse_draw2d_LayoutManager_2(new ViewportLayout());
      this.setHorizontalRangeModel__Lorg_eclipse_draw2d_RangeModel_2(new DefaultRangeModel());
      this.setVerticalRangeModel__Lorg_eclipse_draw2d_RangeModel_2(new DefaultRangeModel());
    }
    useTranslate = setting;
    return this;
  }
  public override function getClientArea__Lorg_eclipse_draw2d_geometry_Rectangle_2(rect: Rectangle): Rectangle {
    super.getClientArea__Lorg_eclipse_draw2d_geometry_Rectangle_2(rect);
    if (this.useGraphicsTranslate__())
      rect.translate__Lorg_eclipse_draw2d_geometry_Point_2(this.getViewLocation__());
    return rect;
  }
  public function getContents__(): IFigure {
    return view;
  }
  public function getHorizontalRangeModel__(): RangeModel {
    return horiztonalRangeModel;
  }
  public function getContentsTracksHeight__(): Boolean {
    return trackHeight;
  }
  public function getContentsTracksWidth__(): Boolean {
    return trackWidth;
  }
  public function getVerticalRangeModel__(): RangeModel {
    return verticalRangeModel;
  }
  public function getViewLocation__(): Point {
    return new Point(new Arguments(org.eclipse.draw2d.geometry.Point.Point__II, [this.getHorizontalRangeModel__().getValue__(), this.getVerticalRangeModel__().getValue__()]));
  }
  private function localRevalidate__(): void {
    this.invalidate__();
    if (this.getLayoutManager__() !== null)
      this.getLayoutManager__().invalidate__();
    this.getUpdateManager__().addInvalidFigure__Lorg_eclipse_draw2d_IFigure_2(this);
  }
  public override function paintClientArea__Lorg_eclipse_draw2d_Graphics_2(g: Graphics): void {
    if (this.useGraphicsTranslate__()) {
      var p: Point = this.getViewLocation__();
      try {
        g.translate__II(-p.x, -p.y);
        g.pushState__();
        super.paintClientArea__Lorg_eclipse_draw2d_Graphics_2(g);
        g.popState__();
      } finally {
        g.translate__II(p.x, p.y);
      }
    } else
      super.paintClientArea__Lorg_eclipse_draw2d_Graphics_2(g);
    return;
  }
  public override function isCoordinateSystem__(): Boolean {
    return this.useGraphicsTranslate__() || super.isCoordinateSystem__();
  }
  public function propertyChange__Ljava_beans_PropertyChangeEvent_2(event: PropertyChangeEvent): void {
    if (event.getSource__() is RangeModel) {
      if (Object("value").equals__Ljava_lang_Object_2(event.getPropertyName__())) {
        if (!ignoreScroll) {
          this.localRevalidate__();
          if (this.useGraphicsTranslate__()) {
            this.repaint__();
            this.fireMoved__();
          }
        }
        this.firePropertyChange__Ljava_lang_String_2Ljava_lang_Object_2Ljava_lang_Object_2("viewLocation", event.getOldValue__(), event.getNewValue__());
      }
    }
    return;
  }
  public function readjustScrollBars__(): void {
    if (this.getContents__() === null)
      return;
    this.getVerticalRangeModel__().setAll__III(0, this.getClientArea__().height, this.getContents__().getBounds__().height);
    this.getHorizontalRangeModel__().setAll__III(0, this.getClientArea__().width, this.getContents__().getBounds__().width);
  }
  public function setContents__Lorg_eclipse_draw2d_IFigure_2(figure: IFigure): void {
    if (view === figure)
      return;
    if (view !== null)
      this.remove__Lorg_eclipse_draw2d_IFigure_2(view);
    view = figure;
    if (view !== null)
      this.add__Lorg_eclipse_draw2d_IFigure_2(figure);
  }
  public function setContentsTracksHeight__Z(track: Boolean): void {
    trackHeight = track;
  }
  public function setContentsTracksWidth__Z(track: Boolean): void {
    trackWidth = track;
  }
  public function setHorizontalLocation__I(value: int): void {
    this.setViewLocation__II(value, this.getVerticalRangeModel__().getValue__());
  }
  public function setHorizontalRangeModel__Lorg_eclipse_draw2d_RangeModel_2(rangeModel: RangeModel): void {
    if (horiztonalRangeModel !== null)
      horiztonalRangeModel.removePropertyChangeListener__Ljava_beans_PropertyChangeListener_2(this);
    horiztonalRangeModel = rangeModel;
    horiztonalRangeModel.addPropertyChangeListener__Ljava_beans_PropertyChangeListener_2(this);
  }
  public function setIgnoreScroll__Z(value: Boolean): void {
    ignoreScroll = value;
  }
  public function setVerticalLocation__I(value: int): void {
    this.setViewLocation__II(this.getHorizontalRangeModel__().getValue__(), value);
  }
  public function setVerticalRangeModel__Lorg_eclipse_draw2d_RangeModel_2(rangeModel: RangeModel): void {
    if (verticalRangeModel !== null)
      verticalRangeModel.removePropertyChangeListener__Ljava_beans_PropertyChangeListener_2(this);
    verticalRangeModel = rangeModel;
    verticalRangeModel.addPropertyChangeListener__Ljava_beans_PropertyChangeListener_2(this);
  }
  public function setViewLocation__II(x: int, y: int): void {
    if (this.getHorizontalRangeModel__().getValue__() != x)
      this.getHorizontalRangeModel__().setValue__I(x);
    if (this.getVerticalRangeModel__().getValue__() != y)
      this.getVerticalRangeModel__().setValue__I(y);
  }
  public function setViewLocation__Lorg_eclipse_draw2d_geometry_Point_2(p: Point): void {
    this.setViewLocation__II(p.x, p.y);
  }
  public override function translateFromParent__Lorg_eclipse_draw2d_geometry_Translatable_2(t: Translatable): void {
    if (useTranslate)
      t.performTranslate__II(this.getHorizontalRangeModel__().getValue__(), this.getVerticalRangeModel__().getValue__());
    super.translateFromParent__Lorg_eclipse_draw2d_geometry_Translatable_2(t);
  }
  public override function translateToParent__Lorg_eclipse_draw2d_geometry_Translatable_2(t: Translatable): void {
    if (useTranslate)
      t.performTranslate__II(-this.getHorizontalRangeModel__().getValue__(), -this.getVerticalRangeModel__().getValue__());
    super.translateToParent__Lorg_eclipse_draw2d_geometry_Translatable_2(t);
  }
  public function useGraphicsTranslate__(): Boolean {
    return useTranslate;
  }
  public override function validate__(): void {
    super.validate__();
    this.readjustScrollBars__();
  }
  public function Viewport(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is Boolean) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        break;
      case 1:
        var args1: Array = [args[0]];
        break;
    }
    super();
    switch (id) {
      case 0:
        Viewport__();
        break;
      case 1:
        Viewport__Z(args1[0]);
        break;
    }
  }
  public static const Viewport__ : int = 0;
  public static const Viewport__Z : int = 1;
}
}
