package org.eclipse.draw2d {
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import java.lang.Math__;
import java.lang.Arguments;
dynamic public class ViewportLayout extends AbstractHintLayout {
  public override function calculateMinimumSize__Lorg_eclipse_draw2d_IFigure_2II(figure: IFigure, wHint: int, hHint: int): Dimension {
    var viewport: Viewport = Viewport(figure);
    var min: Dimension = new Dimension(new Arguments(org.eclipse.draw2d.geometry.Dimension.Dimension__, []));
    var insets: Insets = viewport.getInsets__();
    return min.getExpanded__II(insets.getWidth__(), insets.getHeight__());
  }
  public override function calculatePreferredSize__Lorg_eclipse_draw2d_IFigure_2II(parent: IFigure, wHint: int, hHint: int): Dimension {
    var viewport: Viewport = Viewport(parent);
    var insets: Insets = viewport.getInsets__();
    var contents: IFigure = viewport.getContents__();
    if (viewport.getContentsTracksWidth__() && wHint > -1)
      wHint = Math__.max__II(0, wHint - insets.getWidth__());
    else
      wHint = -1;
    if (viewport.getContentsTracksHeight__() && hHint > -1)
      hHint = Math__.max__II(0, hHint - insets.getHeight__());
    else
      hHint = -1;
    if (contents === null) {
      return new Dimension(new Arguments(org.eclipse.draw2d.geometry.Dimension.Dimension__II, [insets.getWidth__(), insets.getHeight__()]));
    } else {
      var minSize: Dimension = contents.getMinimumSize__II(wHint, hHint);
      if (wHint > -1)
        wHint = Math__.max__II(wHint, minSize.width);
      if (hHint > -1)
        hHint = Math__.max__II(hHint, minSize.height);
      return contents.getPreferredSize__II(wHint, hHint).getExpanded__II(insets.getWidth__(), insets.getHeight__());
    }
    return null;
  }
  public override function isSensitiveHorizontally__Lorg_eclipse_draw2d_IFigure_2(parent: IFigure): Boolean {
    return (Viewport(parent)).getContentsTracksWidth__();
  }
  public override function isSensitiveVertically__Lorg_eclipse_draw2d_IFigure_2(parent: IFigure): Boolean {
    return (Viewport(parent)).getContentsTracksHeight__();
  }
  public override function layout__Lorg_eclipse_draw2d_IFigure_2(figure: IFigure): void {
    var viewport: Viewport = Viewport(figure);
    var contents: IFigure = viewport.getContents__();
    if (contents === null)
      return;
    var p: Point = viewport.getClientArea__().getLocation__();
    p.translate__Lorg_eclipse_draw2d_geometry_Point_2(viewport.getViewLocation__().getNegated__());
    var hints: Rectangle = viewport.getClientArea__();
    var wHint: int = viewport.getContentsTracksWidth__() ? hints.width : -1;
    var hHint: int = viewport.getContentsTracksHeight__() ? hints.height : -1;
    var newSize: Dimension = viewport.getClientArea__().getSize__();
    var min: Dimension = contents.getMinimumSize__II(wHint, hHint);
    var pref: Dimension = contents.getPreferredSize__II(wHint, hHint);
    if (viewport.getContentsTracksHeight__())
      newSize.height = Math__.max__II(newSize.height, min.height);
    else
      newSize.height = Math__.max__II(newSize.height, pref.height);
    if (viewport.getContentsTracksWidth__())
      newSize.width = Math__.max__II(newSize.width, min.width);
    else
      newSize.width = Math__.max__II(newSize.width, pref.width);
    contents.setBounds__Lorg_eclipse_draw2d_geometry_Rectangle_2(new Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__Lorg_eclipse_draw2d_geometry_Point_2Lorg_eclipse_draw2d_geometry_Dimension_2, [p, newSize])));
  }
}
}
