package org.eclipse.draw2d {
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import java.util.Map;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Iterator;
import java.lang.Arguments;
dynamic public class XYLayout extends AbstractLayout {
  public var constraints: Map = new HashMap(new Arguments(java.util.HashMap.HashMap__, []));
  public override function calculatePreferredSize__Lorg_eclipse_draw2d_IFigure_2II(f: IFigure, wHint: int, hHint: int): Dimension {
    var rect: Rectangle = new Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__, []));
    var children: ListIterator = f.getChildren__().listIterator__();
    while (children.hasNext__()) {
      var child: IFigure = IFigure(children.next__());
      var r: Rectangle = Rectangle(constraints.get__Ljava_lang_Object_2(child));
      if (r === null)
        continue;
      if (r.width == -1 || r.height == -1) {
        var preferredSize_1: Dimension = child.getPreferredSize__II(r.width, r.height);
        r = r.getCopy__();
        if (r.width == -1)
          r.width = preferredSize_1.width;
        if (r.height == -1)
          r.height = preferredSize_1.height;
      }
      rect.union__Lorg_eclipse_draw2d_geometry_Rectangle_2(r);
    }
    var d: Dimension = rect.getSize__();
    var insets: Insets = f.getInsets__();
    return new Dimension(new Arguments(org.eclipse.draw2d.geometry.Dimension.Dimension__II, [d.width + insets.getWidth__(), d.height + insets.getHeight__()])).union__Lorg_eclipse_draw2d_geometry_Dimension_2(this.getBorderPreferredSize__Lorg_eclipse_draw2d_IFigure_2(f));
  }
  public override function getConstraint__Lorg_eclipse_draw2d_IFigure_2(figure: IFigure): Object {
    return constraints.get__Ljava_lang_Object_2(figure);
  }
  public function getOrigin__Lorg_eclipse_draw2d_IFigure_2(parent: IFigure): Point {
    return parent.getClientArea__().getLocation__();
  }
  public override function layout__Lorg_eclipse_draw2d_IFigure_2(parent: IFigure): void {
    var children: Iterator = Iterator(parent.getChildren__().iterator__());
    var offset: Point = this.getOrigin__Lorg_eclipse_draw2d_IFigure_2(parent);
    var f: IFigure;
    while (children.hasNext__()) {
      f = IFigure(children.next__());
      var bounds: Rectangle = Rectangle(this.getConstraint__Lorg_eclipse_draw2d_IFigure_2(f));
      if (bounds === null)
        continue;
      if (bounds.width == -1 || bounds.height == -1) {
        var preferredSize_1: Dimension = f.getPreferredSize__II(bounds.width, bounds.height);
        bounds = bounds.getCopy__();
        if (bounds.width == -1)
          bounds.width = preferredSize_1.width;
        if (bounds.height == -1)
          bounds.height = preferredSize_1.height;
      }
      bounds = bounds.getTranslated__Lorg_eclipse_draw2d_geometry_Point_2(offset);
      f.setBounds__Lorg_eclipse_draw2d_geometry_Rectangle_2(bounds);
    }
    return;
  }
  public override function remove__Lorg_eclipse_draw2d_IFigure_2(figure: IFigure): void {
    super.remove__Lorg_eclipse_draw2d_IFigure_2(figure);
    constraints.remove__Ljava_lang_Object_2(figure);
    return;
  }
  public override function setConstraint__Lorg_eclipse_draw2d_IFigure_2Ljava_lang_Object_2(figure: IFigure, newConstraint: Object): void {
    super.setConstraint__Lorg_eclipse_draw2d_IFigure_2Ljava_lang_Object_2(figure, newConstraint);
    if (newConstraint !== null)
      constraints.put__Ljava_lang_Object_2Ljava_lang_Object_2(figure, newConstraint);
    return;
  }
}
}
