package org.eclipse.draw2d.geometry {
import java.lang.Cloneable;
import java.io.Serializable;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import java.lang.Math__;
import java.lang.Arguments;
dynamic public class Dimension implements Cloneable, Serializable, Translatable {
  public static var SINGLETON: Dimension = new Dimension(new Arguments(org.eclipse.draw2d.geometry.Dimension.Dimension__, []));
  public var width: int;
  public var height: int;
  public static const serialVersionUID: Number = 1;
  public function Dimension__(): Object {
    return this;
  }
  public function Dimension__Lorg_eclipse_draw2d_geometry_Dimension_2(d: Dimension): Object {
    width = d.width;
    height = d.height;
    return this;
  }
  public function Dimension__Lorg_eclipse_swt_graphics_Point_2(pt: org.eclipse.swt.graphics.Point): Object {
    width = pt.x;
    height = pt.y;
    return this;
  }
  public function Dimension__II(w: int, h: int): Object {
    width = w;
    height = h;
    return this;
  }
  public function Dimension__Lorg_eclipse_swt_graphics_Image_2(image: Image): Object {
    var r: org.eclipse.swt.graphics.Rectangle = image.getBounds__();
    width = r.width;
    height = r.height;
    return this;
  }
  public function contains__Lorg_eclipse_draw2d_geometry_Dimension_2(d: Dimension): Boolean {
    return width >= d.width && height >= d.height;
  }
  public function containsProper__Lorg_eclipse_draw2d_geometry_Dimension_2(d: Dimension): Boolean {
    return width > d.width && height > d.height;
  }
  public function setSize__Lorg_eclipse_draw2d_geometry_Dimension_2(d: Dimension): void {
    width = d.width;
    height = d.height;
  }
  public function getArea__(): int {
    return width * height;
  }
  public function getCopy__(): Dimension {
    return new Dimension(new Arguments(org.eclipse.draw2d.geometry.Dimension.Dimension__Lorg_eclipse_draw2d_geometry_Dimension_2, [this]));
  }
  public function getDifference__Lorg_eclipse_draw2d_geometry_Dimension_2(d: Dimension): Dimension {
    return new Dimension(new Arguments(org.eclipse.draw2d.geometry.Dimension.Dimension__II, [width - d.width, height - d.height]));
  }
  public function getExpanded__Lorg_eclipse_draw2d_geometry_Dimension_2(d: Dimension): Dimension {
    return new Dimension(new Arguments(org.eclipse.draw2d.geometry.Dimension.Dimension__II, [width + d.width, height + d.height]));
  }
  public function getExpanded__II(w: int, h: int): Dimension {
    return new Dimension(new Arguments(org.eclipse.draw2d.geometry.Dimension.Dimension__II, [width + w, height + h]));
  }
  public function getIntersected__Lorg_eclipse_draw2d_geometry_Dimension_2(d: Dimension): Dimension {
    return new Dimension(new Arguments(org.eclipse.draw2d.geometry.Dimension.Dimension__Lorg_eclipse_draw2d_geometry_Dimension_2, [this])).intersect__Lorg_eclipse_draw2d_geometry_Dimension_2(d);
  }
  public function getNegated__(): Dimension {
    return new Dimension(new Arguments(org.eclipse.draw2d.geometry.Dimension.Dimension__II, [0 - width, 0 - height]));
  }
  public function equals__Ljava_lang_Object_2(o: Object): Boolean {
    if (o is Dimension) {
      var d: Dimension = Dimension(o);
      return (d.width == width && d.height == height);
    }
    return false;
  }
  public function equals__II(w: int, h: int): Boolean {
    return width == w && height == h;
  }
  public function expand__Lorg_eclipse_draw2d_geometry_Dimension_2(d: Dimension): Dimension {
    width += d.width;
    height += d.height;
    return this;
  }
  public function expand__Lorg_eclipse_draw2d_geometry_Point_2(pt: org.eclipse.draw2d.geometry.Point): Dimension {
    width += pt.x;
    height += pt.y;
    return this;
  }
  public function expand__II(w: int, h: int): Dimension {
    width += w;
    height += h;
    return this;
  }
  public function getScaled__D(amount: Number): Dimension {
    return new Dimension(new Arguments(org.eclipse.draw2d.geometry.Dimension.Dimension__Lorg_eclipse_draw2d_geometry_Dimension_2, [this])).scale__D(amount);
  }
  public function getTransposed__(): Dimension {
    return new Dimension(new Arguments(org.eclipse.draw2d.geometry.Dimension.Dimension__Lorg_eclipse_draw2d_geometry_Dimension_2, [this])).transpose__();
  }
  public function getUnioned__Lorg_eclipse_draw2d_geometry_Dimension_2(d: Dimension): Dimension {
    return new Dimension(new Arguments(org.eclipse.draw2d.geometry.Dimension.Dimension__Lorg_eclipse_draw2d_geometry_Dimension_2, [this])).union__Lorg_eclipse_draw2d_geometry_Dimension_2(d);
  }
  public function hashCode__(): int {
    return (width * height) ^ (width + height);
  }
  public function intersect__Lorg_eclipse_draw2d_geometry_Dimension_2(d: Dimension): Dimension {
    width = Math__.min__II(d.width, width);
    height = Math__.min__II(d.height, height);
    return this;
  }
  public function isEmpty__(): Boolean {
    return (width <= 0) || (height <= 0);
  }
  public function negate__(): Dimension {
    width = 0 - width;
    height = 0 - height;
    return this;
  }
  public function performScale__D(factor: Number): void {
    this.scale__D(factor);
  }
  public function performTranslate__II(dx: int, dy: int): void {
  }
  public function scale__D(amount: Number): Dimension {
    return this.scale__DD(amount, amount);
  }
  public function scale__DD(w: Number, h: Number): Dimension {
    width = int((Math__.floor__D(width * w)));
    height = int((Math__.floor__D(height * h)));
    return this;
  }
  public function shrink__II(w: int, h: int): Dimension {
    return this.expand__II(-w, -h);
  }
  public function toString__(): String {
    return "Dimension(" + width + ", " + height + ")";
  }
  public function transpose__(): Dimension {
    var temp: int = width;
    width = height;
    height = temp;
    return this;
  }
  public function union__Lorg_eclipse_draw2d_geometry_Dimension_2(d: Dimension): Dimension {
    width = Math__.max__II(width, d.width);
    height = Math__.max__II(height, d.height);
    return this;
  }
  public function preciseWidth__(): Number {
    return width;
  }
  public function preciseHeight__(): Number {
    return height;
  }
  public function Dimension(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is Dimension) {
        args = vargs;
        id = 1;
      } else if (vargs.length == 1 && vargs[0] is org.eclipse.swt.graphics.Point) {
        args = vargs;
        id = 2;
      } else if (vargs.length == 2 && vargs[0] is int && vargs[1] is int) {
        args = vargs;
        id = 3;
      } else if (vargs.length == 1 && vargs[0] is Image) {
        args = vargs;
        id = 4;
      }
    }
    switch (id) {
      case 0:
        break;
      case 1:
        var args1: Array = [args[0]];
        break;
      case 2:
        var args2: Array = [args[0]];
        break;
      case 3:
        var args3: Array = [args[0], args[1]];
        break;
      case 4:
        var args4: Array = [args[0]];
        break;
    }
    super();
    switch (id) {
      case 0:
        Dimension__();
        break;
      case 1:
        Dimension__Lorg_eclipse_draw2d_geometry_Dimension_2(args1[0]);
        break;
      case 2:
        Dimension__Lorg_eclipse_swt_graphics_Point_2(args2[0]);
        break;
      case 3:
        Dimension__II(args3[0], args3[1]);
        break;
      case 4:
        Dimension__Lorg_eclipse_swt_graphics_Image_2(args4[0]);
        break;
    }
  }
  public static const Dimension__ : int = 0;
  public static const Dimension__Lorg_eclipse_draw2d_geometry_Dimension_2 : int = 1;
  public static const Dimension__Lorg_eclipse_swt_graphics_Point_2 : int = 2;
  public static const Dimension__II : int = 3;
  public static const Dimension__Lorg_eclipse_swt_graphics_Image_2 : int = 4;
}
}
