package org.eclipse.draw2d.geometry {
import java.lang.JavaArray;
dynamic public class Geometry {
  public static function linesIntersect__IIIIIIII(ux: int, uy: int, vx: int, vy: int, sx: int, sy: int, tx: int, ty: int): Boolean {
    var usX: Number = Number(ux) - sx;
    var usY: Number = Number(uy) - sy;
    var vsX: Number = Number(vx) - sx;
    var vsY: Number = Number(vy) - sy;
    var stX: Number = Number(sx) - tx;
    var stY: Number = Number(sy) - ty;
    if (productSign__JJ(cross__JJJJ(vsX, vsY, stX, stY), cross__JJJJ(stX, stY, usX, usY)) >= 0) {
      var vuX: Number = Number(vx) - ux;
      var vuY: Number = Number(vy) - uy;
      var utX: Number = Number(ux) - tx;
      var utY: Number = Number(uy) - ty;
      return productSign__JJ(cross__JJJJ(-usX, -usY, vuX, vuY), cross__JJJJ(vuX, vuY, utX, utY)) <= 0;
    }
    return false;
  }
  private static function productSign__JJ(x: Number, y: Number): int {
    if (x == 0 || y == 0) {
      return 0;
    } else if ((x < 0) != (y < 0)) {
      return -1;
    }
    return 1;
  }
  private static function cross__JJJJ(x1: Number, y1: Number, x2: Number, y2: Number): Number {
    return x1 * y2 - x2 * y1;
  }
  public static function polylineContainsPoint__Lorg_eclipse_draw2d_geometry_PointList_2III(points: PointList, x: int, y: int, tolerance: int): Boolean {
    var coordinates: JavaArray = points.toIntArray__();
    for (var index: int = 0; index < coordinates.length - 3; index += 2) {
      if (segmentContainsPoint__IIIIIII(coordinates[index], coordinates[index + 1], coordinates[index + 2], coordinates[index + 3], x, y, tolerance)) {
        return true;
      }
    }
    return false;
  }
  private static function segmentContainsPoint__IIIIIII(x1: int, y1: int, x2: int, y2: int, px: int, py: int, tolerance: int): Boolean {
    var lineBounds: Rectangle = Rectangle.SINGLETON;
    lineBounds.setSize__II(0, 0);
    lineBounds.setLocation__II(x1, y1);
    lineBounds.union__II(x2, y2);
    lineBounds.expand__II(tolerance, tolerance);
    if (!lineBounds.contains__II(px, py)) {
      return false;
    }
    if (x1 == x2 || y1 == y2) {
      return true;
    }
    var v1x: int = x2 - x1;
    var v1y: int = y2 - y1;
    var v2x: int = px - x1;
    var v2y: int = py - y1;
    var numerator: int = v2x * v1y - v1x * v2y;
    var denominator: int = v1x * v1x + v1y * v1y;
    var squareDistance: int = int((Number(numerator) * numerator / denominator));
    return squareDistance <= tolerance * tolerance;
  }
  public static function polygonContainsPoint__Lorg_eclipse_draw2d_geometry_PointList_2II(points: PointList, x: int, y: int): Boolean {
    var isOdd: Boolean = false;
    var coordinates: JavaArray = points.toIntArray__();
    var n: int = coordinates.length;
    if (n > 3) {
      var x1: int;
      var y1: int;
      var x0: int = coordinates[n - 2];
      var y0: int = coordinates[n - 1];
      for (var i: int = 0; i < n; x0 = x1, y0 = y1) {
        x1 = coordinates[i++];
        y1 = coordinates[i++];
        if (!segmentContaintPoint__III(y0, y1, y)) {
          continue;
        }
        var crossProduct: int = crossProduct__IIIIII(x1, y1, x0, y0, x, y);
        if (crossProduct == 0) {
          if (segmentContaintPoint__III(x0, x1, x)) {
            return true;
          }
        } else if ((y0 <= y && y < y1 && crossProduct > 0) || (y1 <= y && y < y0 && crossProduct < 0)) {
          isOdd = !isOdd;
        }
      }
      return isOdd;
    }
    return false;
  }
  private static function segmentContaintPoint__III(x0: int, x1: int, x: int): Boolean {
    return !((x < x0 && x < x1) || (x > x0 && x > x1));
  }
  private static function crossProduct__IIIIII(ax: int, ay: int, bx: int, by: int, cx: int, cy: int): int {
    return (ax - cx) * (by - cy) - (ay - cy) * (bx - cx);
  }
}
}
