package org.eclipse.draw2d.geometry {
import java.lang.Cloneable;
import java.io.Serializable;
import java.lang.Arguments;
dynamic public class Insets implements Cloneable, Serializable {
  public var left: int;
  public var top: int;
  public var bottom: int;
  public var right: int;
  public static const serialVersionUID: Number = 1;
  public function Insets__(): Object {
    return this;
  }
  public function Insets__Lorg_eclipse_draw2d_geometry_Insets_2(i: Insets): Object {
    return this;
  }
  public function Insets__I(i: int): Object {
    return this;
  }
  public function Insets__IIII(top: int, left: int, bottom: int, right: int): Object {
    this.top = top;
    this.left = left;
    this.bottom = bottom;
    this.right = right;
    return this;
  }
  public function add__Lorg_eclipse_draw2d_geometry_Insets_2(insets: Insets): Insets {
    top += insets.top;
    bottom += insets.bottom;
    left += insets.left;
    right += insets.right;
    return this;
  }
  public function equals__Ljava_lang_Object_2(o: Object): Boolean {
    if (o is Insets) {
      var i: Insets = Insets(o);
      return i.top == top && i.bottom == bottom && i.left == left && i.right == right;
    }
    return false;
  }
  public function getAdded__Lorg_eclipse_draw2d_geometry_Insets_2(insets: Insets): Insets {
    return new Insets(new Arguments(org.eclipse.draw2d.geometry.Insets.Insets__Lorg_eclipse_draw2d_geometry_Insets_2, [this])).add__Lorg_eclipse_draw2d_geometry_Insets_2(insets);
  }
  public function getHeight__(): int {
    return top + bottom;
  }
  public function getTransposed__(): Insets {
    return new Insets(new Arguments(org.eclipse.draw2d.geometry.Insets.Insets__Lorg_eclipse_draw2d_geometry_Insets_2, [this])).transpose__();
  }
  public function getWidth__(): int {
    return left + right;
  }
  public function hashCode__(): int {
    return top * 7 + left * 2 + bottom * 31 + right * 37;
  }
  public function isEmpty__(): Boolean {
    return (left == 0 && right == 0 && top == 0 && bottom == 0);
  }
  public function toString__(): String {
    return "Insets(t=" + top + ", l=" + left + ", b=" + bottom + ", r=" + right + ")";
  }
  public function transpose__(): Insets {
    var temp: int = top;
    top = left;
    left = temp;
    temp = right;
    right = bottom;
    bottom = temp;
    return this;
  }
  public function Insets(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is Insets) {
        args = vargs;
        id = 1;
      } else if (vargs.length == 1 && vargs[0] is int) {
        args = vargs;
        id = 2;
      } else if (vargs.length == 4 && vargs[0] is int && vargs[1] is int && vargs[2] is int && vargs[3] is int) {
        args = vargs;
        id = 3;
      }
    }
    switch (id) {
      case 0:
        break;
      case 1:
        var args1: Array = [args[0]];
        args3 = [args1[0].top, args1[0].left, args1[0].bottom, args1[0].right];
        break;
      case 2:
        var args2: Array = [args[0]];
        args3 = [args2[0], args2[0], args2[0], args2[0]];
        break;
      case 3:
        var args3: Array = [args[0], args[1], args[2], args[3]];
        break;
    }
    super();
    switch (id) {
      case 0:
        Insets__();
        break;
      case 1:
        Insets__IIII(args3[0], args3[1], args3[2], args3[3]);
        Insets__Lorg_eclipse_draw2d_geometry_Insets_2(args1[0]);
        break;
      case 2:
        Insets__IIII(args3[0], args3[1], args3[2], args3[3]);
        Insets__I(args2[0]);
        break;
      case 3:
        Insets__IIII(args3[0], args3[1], args3[2], args3[3]);
        break;
    }
  }
  public static const Insets__ : int = 0;
  public static const Insets__Lorg_eclipse_draw2d_geometry_Insets_2 : int = 1;
  public static const Insets__I : int = 2;
  public static const Insets__IIII : int = 3;
}
}
