package org.eclipse.draw2d.geometry {
import org.eclipse.draw2d.PositionConstants;
import java.lang.Cloneable;
import java.io.Serializable;
import org.eclipse.swt.graphics.Point;
import java.lang.Math__;
import java.lang.Integer;
import java.lang.Arguments;
dynamic public class Point implements Cloneable, Serializable, Translatable {
  public static const serialVersionUID: Number = 1;
  public static var SINGLETON: org.eclipse.draw2d.geometry.Point = new org.eclipse.draw2d.geometry.Point(new Arguments(org.eclipse.draw2d.geometry.Point.Point__, []));
  public var x: int;
  public var y: int;
  public function Point__(): Object {
    return this;
  }
  public function Point__Lorg_eclipse_draw2d_geometry_Point_2(copy: org.eclipse.draw2d.geometry.Point): Object {
    x = copy.x;
    y = copy.y;
    return this;
  }
  public function Point__Lorg_eclipse_swt_graphics_Point_2(copy: org.eclipse.swt.graphics.Point): Object {
    x = copy.x;
    y = copy.y;
    return this;
  }
  public function Point__II(x: int, y: int): Object {
    this.x = x;
    this.y = y;
    return this;
  }
  public function Point__DD(x: Number, y: Number): Object {
    this.x = int(x);
    this.y = int(y);
    return this;
  }
  public function equals__Ljava_lang_Object_2(o: Object): Boolean {
    if (o is org.eclipse.draw2d.geometry.Point) {
      var p: org.eclipse.draw2d.geometry.Point = org.eclipse.draw2d.geometry.Point(o);
      return p.x == x && p.y == y;
    }
    return false;
  }
  public function getCopy__(): org.eclipse.draw2d.geometry.Point {
    return new org.eclipse.draw2d.geometry.Point(new Arguments(org.eclipse.draw2d.geometry.Point.Point__II, [x, y]));
  }
  public function getDifference__Lorg_eclipse_draw2d_geometry_Point_2(pt: org.eclipse.draw2d.geometry.Point): Dimension {
    return new Dimension(new Arguments(org.eclipse.draw2d.geometry.Dimension.Dimension__II, [this.x - pt.x, this.y - pt.y]));
  }
  public function getDistance__Lorg_eclipse_draw2d_geometry_Point_2(pt: org.eclipse.draw2d.geometry.Point): Number {
    return Math__.sqrt__D(this.getPreciseDistance2__Lorg_eclipse_draw2d_geometry_Point_2(pt));
  }
  public function getDistance2__Lorg_eclipse_draw2d_geometry_Point_2(pt: org.eclipse.draw2d.geometry.Point): int {
    var i: Number = pt.x - x;
    var j: Number = pt.y - y;
    var result: Number = i * i + j * j;
    if (result > 2147483647)
      return 2147483647;
    return int(result);
  }
  private function getPreciseDistance2__Lorg_eclipse_draw2d_geometry_Point_2(pt: org.eclipse.draw2d.geometry.Point): Number {
    var i: Number = pt.preciseX__() - this.preciseX__();
    var j: Number = pt.preciseY__() - this.preciseY__();
    return i * i + j * j;
  }
  public function getDistanceOrthogonal__Lorg_eclipse_draw2d_geometry_Point_2(pt: org.eclipse.draw2d.geometry.Point): int {
    return Math__.abs__I(y - pt.y) + Math__.abs__I(x - pt.x);
  }
  public function getNegated__(): org.eclipse.draw2d.geometry.Point {
    return this.getCopy__().negate__();
  }
  public function getPosition__Lorg_eclipse_draw2d_geometry_Point_2(p: org.eclipse.draw2d.geometry.Point): int {
    var dx: int = p.x - x;
    var dy: int = p.y - y;
    if (Math__.abs__I(dx) > Math__.abs__I(dy)) {
      if (dx < 0)
        return 8;
      return 16;
    }
    if (dy < 0)
      return 1;
    return 4;
  }
  public function getScaled__D(amount: Number): org.eclipse.draw2d.geometry.Point {
    return this.getCopy__().scale__D(amount);
  }
  public function getSWTPoint__(): org.eclipse.swt.graphics.Point {
    return new org.eclipse.swt.graphics.Point(x, y);
  }
  public function getTranslated__Lorg_eclipse_draw2d_geometry_Dimension_2(delta: Dimension): org.eclipse.draw2d.geometry.Point {
    return this.getCopy__().translate__Lorg_eclipse_draw2d_geometry_Dimension_2(delta);
  }
  public function getTranslated__II(x_1: int, y_1: int): org.eclipse.draw2d.geometry.Point {
    return this.getCopy__().translate__II(x_1, y_1);
  }
  public function getTranslated__Lorg_eclipse_draw2d_geometry_Point_2(pt: org.eclipse.draw2d.geometry.Point): org.eclipse.draw2d.geometry.Point {
    return this.getCopy__().translate__Lorg_eclipse_draw2d_geometry_Point_2(pt);
  }
  public function getTransposed__(): org.eclipse.draw2d.geometry.Point {
    return this.getCopy__().transpose__();
  }
  public function hashCode__(): int {
    return (x * y) ^ (x + y);
  }
  public static function max__Lorg_eclipse_draw2d_geometry_Point_2Lorg_eclipse_draw2d_geometry_Point_2(p1: org.eclipse.draw2d.geometry.Point, p2: org.eclipse.draw2d.geometry.Point): org.eclipse.draw2d.geometry.Point {
    return new Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__Lorg_eclipse_draw2d_geometry_Point_2Lorg_eclipse_draw2d_geometry_Point_2, [p1, p2])).getBottomRight__().translate__II(-1, -1);
  }
  public static function min__Lorg_eclipse_draw2d_geometry_Point_2Lorg_eclipse_draw2d_geometry_Point_2(p1: org.eclipse.draw2d.geometry.Point, p2: org.eclipse.draw2d.geometry.Point): org.eclipse.draw2d.geometry.Point {
    return new Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__Lorg_eclipse_draw2d_geometry_Point_2Lorg_eclipse_draw2d_geometry_Point_2, [p1, p2])).getTopLeft__();
  }
  public function negate__(): org.eclipse.draw2d.geometry.Point {
    x = -x;
    y = -y;
    return this;
  }
  public function performScale__D(factor: Number): void {
    this.scale__D(factor);
  }
  public function performTranslate__II(dx: int, dy: int): void {
    this.translate__II(dx, dy);
  }
  public function scale__D(amount: Number): org.eclipse.draw2d.geometry.Point {
    x = int(Math__.floor__D(x * amount));
    y = int(Math__.floor__D(y * amount));
    return this;
  }
  public function scale__DD(xAmount: Number, yAmount: Number): org.eclipse.draw2d.geometry.Point {
    x = int(Math__.floor__D(x * xAmount));
    y = int(Math__.floor__D(y * yAmount));
    return this;
  }
  public function setLocation__II(x_1: int, y_1: int): org.eclipse.draw2d.geometry.Point {
    this.x = x_1;
    this.y = y_1;
    return this;
  }
  public function setLocation__Lorg_eclipse_draw2d_geometry_Point_2(pt: org.eclipse.draw2d.geometry.Point): org.eclipse.draw2d.geometry.Point {
    x = pt.x;
    y = pt.y;
    return this;
  }
  public function toString__(): String {
    return "Point(" + x + ", " + y + ")";
  }
  public function translate__Lorg_eclipse_draw2d_geometry_Point_2(p: org.eclipse.draw2d.geometry.Point): org.eclipse.draw2d.geometry.Point {
    return this.translate__II(p.x, p.y);
  }
  public function translate__Lorg_eclipse_draw2d_geometry_Dimension_2(d: Dimension): org.eclipse.draw2d.geometry.Point {
    return this.translate__II(d.width, d.height);
  }
  public function translate__II(dx: int, dy: int): org.eclipse.draw2d.geometry.Point {
    x += dx;
    y += dy;
    return this;
  }
  public function transpose__(): org.eclipse.draw2d.geometry.Point {
    var temp: int = x;
    x = y;
    y = temp;
    return this;
  }
  public function preciseX__(): Number {
    return x;
  }
  public function preciseY__(): Number {
    return y;
  }
  public function Point(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is org.eclipse.draw2d.geometry.Point) {
        args = vargs;
        id = 1;
      } else if (vargs.length == 1 && vargs[0] is org.eclipse.swt.graphics.Point) {
        args = vargs;
        id = 2;
      } else if (vargs.length == 2 && vargs[0] is int && vargs[1] is int) {
        args = vargs;
        id = 3;
      } else if (vargs.length == 2 && vargs[0] is Number && vargs[1] is Number) {
        args = vargs;
        id = 4;
      }
    }
    switch (id) {
      case 0:
        break;
      case 1:
        var args1: Array = [args[0]];
        break;
      case 2:
        var args2: Array = [args[0]];
        break;
      case 3:
        var args3: Array = [args[0], args[1]];
        break;
      case 4:
        var args4: Array = [args[0], args[1]];
        break;
    }
    super();
    switch (id) {
      case 0:
        Point__();
        break;
      case 1:
        Point__Lorg_eclipse_draw2d_geometry_Point_2(args1[0]);
        break;
      case 2:
        Point__Lorg_eclipse_swt_graphics_Point_2(args2[0]);
        break;
      case 3:
        Point__II(args3[0], args3[1]);
        break;
      case 4:
        Point__DD(args4[0], args4[1]);
        break;
    }
  }
  public static const Point__ : int = 0;
  public static const Point__Lorg_eclipse_draw2d_geometry_Point_2 : int = 1;
  public static const Point__Lorg_eclipse_swt_graphics_Point_2 : int = 2;
  public static const Point__II : int = 3;
  public static const Point__DD : int = 4;
}
}
