package org.eclipse.draw2d.geometry {
import java.io.Serializable;
import java.lang.System;
import java.lang.Math__;
import java.lang.IndexOutOfBoundsException;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class PointList implements Serializable, Translatable {
  private var points: JavaArray = new JavaArray("[I").lengths(0);
  private var bounds: Rectangle;
  private var size: int = 0;
  public static const serialVersionUID: Number = 1;
  public function PointList__(): Object {
    return this;
  }
  public function PointList___3I(points: JavaArray): Object {
    this.points = points;
    this.size = int(points.length / 2);
    return this;
  }
  public function PointList__I(size: int): Object {
    points = new JavaArray("[I").lengths(size * 2);
    return this;
  }
  public function addAll__Lorg_eclipse_draw2d_geometry_PointList_2(source: PointList): void {
    this.ensureCapacity__I(size + source.size);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(source.points, 0, points, size * 2, source.size * 2);
    size += source.size;
    return;
  }
  public function addPoint__Lorg_eclipse_draw2d_geometry_Point_2(p: Point): void {
    this.addPoint__II(p.x, p.y);
    return;
  }
  public function addPoint__II(x: int, y: int): void {
    bounds = null;
    var index: int = size * 2;
    this.ensureCapacity__I(size + 1);
    points[index] = x;
    points[index + 1] = y;
    size++;
    return;
  }
  private function ensureCapacity__I(newSize: int): void {
    newSize *= 2;
    if (points.length < newSize) {
      var old: JavaArray = points;
      points = new JavaArray("[I").lengths(Math__.max__II(newSize, size * 4));
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(old, 0, points, 0, size * 2);
    }
    return;
  }
  public function getBounds__(): Rectangle {
    if (bounds !== null)
      return bounds;
    bounds = new Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__, []));
    if (size > 0) {
      bounds.setLocation__Lorg_eclipse_draw2d_geometry_Point_2(this.getPoint__I(0));
      for (var i: int = 0; i < size; i++)
        bounds.union__Lorg_eclipse_draw2d_geometry_Point_2(this.getPoint__I(i));
    }
    return bounds;
  }
  public function getCopy__(): PointList {
    var result: PointList = new PointList(new Arguments(org.eclipse.draw2d.geometry.PointList.PointList__I, [size]));
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(points, 0, result.points, 0, size * 2);
    result.size = size;
    result.bounds = null;
    return result;
  }
  public function getFirstPoint__(): Point {
    return this.getPoint__I(0);
  }
  public function getLastPoint__(): Point {
    return this.getPoint__I(size - 1);
  }
  public function getMidpoint__(): Point {
    if (this.size__() % 2 == 0)
      return this.getPoint__I(int(this.size__() / 2) - 1).getTranslated__Lorg_eclipse_draw2d_geometry_Point_2(this.getPoint__I(int(this.size__() / 2))).scale__D(0.5);
    return this.getPoint__I(int(this.size__() / 2));
  }
  public function getPoint__I(index: int): Point {
    if (index < 0 || index >= size)
      throw new IndexOutOfBoundsException(new Arguments(java.lang.IndexOutOfBoundsException.IndexOutOfBoundsException__Ljava_lang_String_2, ["Index: " + index + ", Size: " + size]));
    index *= 2;
    return new Point(new Arguments(org.eclipse.draw2d.geometry.Point.Point__II, [points[index], points[index + 1]]));
  }
  public function getPoint__Lorg_eclipse_draw2d_geometry_Point_2I(p: Point, index: int): Point {
    if (index < 0 || index >= size)
      throw new IndexOutOfBoundsException(new Arguments(java.lang.IndexOutOfBoundsException.IndexOutOfBoundsException__Ljava_lang_String_2, ["Index: " + index + ", Size: " + size]));
    index *= 2;
    p.x = points[index];
    p.y = points[index + 1];
    return p;
  }
  public function insertPoint__Lorg_eclipse_draw2d_geometry_Point_2I(p: Point, index: int): void {
    if (bounds !== null && !bounds.contains__Lorg_eclipse_draw2d_geometry_Point_2(p))
      bounds = null;
    if (index > size || index < 0)
      throw new IndexOutOfBoundsException(new Arguments(java.lang.IndexOutOfBoundsException.IndexOutOfBoundsException__Ljava_lang_String_2, ["Index: " + index + ", Size: " + size]));
    index *= 2;
    var length: int = points.length;
    var old: JavaArray = points;
    points = new JavaArray("[I").lengths(length + 2);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(old, 0, points, 0, index);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(old, index, points, index + 2, length - index);
    points[index] = p.x;
    points[index + 1] = p.y;
    size++;
  }
  public function intersects__Lorg_eclipse_draw2d_geometry_Rectangle_2(r: Rectangle): Boolean {
    if (r.isEmpty__())
      return false;
    for (var i: int = 0; i < size * 2; i += 2) {
      if (r.contains__II(points[i], points[i + 1]))
        return true;
    }
    var diagonal1x1: int = r.x;
    var diagonal1y1: int = r.y;
    var diagonal1x2: int = r.x + r.width - 1;
    var diagonal1y2: int = r.y + r.height - 1;
    var diagonal2x1: int = r.x + r.width - 1;
    var diagonal2y1: int = r.y;
    var diagonal2x2: int = r.x;
    var diagonal2y2: int = r.y + r.height - 1;
    for (var i_1: int = 0; i_1 < (size - 1) * 2; i_1 += 2) {
      if (Geometry.linesIntersect__IIIIIIII(diagonal1x1, diagonal1y1, diagonal1x2, diagonal1y2, points[i_1], points[i_1 + 1], points[i_1 + 2], points[i_1 + 3]) || Geometry.linesIntersect__IIIIIIII(diagonal2x1, diagonal2y1, diagonal2x2, diagonal2y2, points[i_1], points[i_1 + 1], points[i_1 + 2], points[i_1 + 3]))
        return true;
    }
    return false;
  }
  public function performScale__D(factor: Number): void {
    for (var i: int = 0; i < points.length; i++)
      points[i] = int(Math__.floor__D(points[i] * factor));
    bounds = null;
  }
  public function performTranslate__II(dx: int, dy: int): void {
    for (var i: int = 0; i < size * 2; i += 2) {
      points[i] += dx;
      points[i + 1] += dy;
    }
    if (bounds !== null)
      bounds.translate__II(dx, dy);
    return;
  }
  public function removeAllPoints__(): void {
    bounds = null;
    size = 0;
    return;
  }
  public function removePoint__I(index: int): Point {
    bounds = null;
    if (index < 0 || index >= size)
      throw new IndexOutOfBoundsException(new Arguments(java.lang.IndexOutOfBoundsException.IndexOutOfBoundsException__Ljava_lang_String_2, ["Index: " + index + ", Size: " + size]));
    index *= 2;
    var pt: Point = new Point(new Arguments(org.eclipse.draw2d.geometry.Point.Point__II, [points[index], points[index + 1]]));
    if (index != size * 2 - 2)
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(points, index + 2, points, index, size * 2 - index - 2);
    size--;
    return pt;
  }
  public function reverse__(): void {
    var temp: int;
    for (var i: int = 0, j: int = size * 2 - 2; i < size; i += 2, j -= 2) {
      temp = points[i];
      points[i] = points[j];
      points[j] = temp;
      temp = points[i + 1];
      points[i + 1] = points[j + 1];
      points[j + 1] = temp;
    }
    return;
  }
  public function setPoint__Lorg_eclipse_draw2d_geometry_Point_2I(pt: Point, index: int): void {
    if (index < 0 || index >= size)
      throw new IndexOutOfBoundsException(new Arguments(java.lang.IndexOutOfBoundsException.IndexOutOfBoundsException__Ljava_lang_String_2, ["Index: " + index + ", Size: " + size]));
    if (bounds !== null && !bounds.contains__Lorg_eclipse_draw2d_geometry_Point_2(pt))
      bounds = null;
    points[index * 2] = pt.x;
    points[index * 2 + 1] = pt.y;
    return;
  }
  public function setSize__I(newSize: int): void {
    if (points.length > newSize * 2) {
      size = newSize;
      return;
    }
    var newArray: JavaArray = new JavaArray("[I").lengths(newSize * 2);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(points, 0, newArray, 0, points.length);
    points = newArray;
    size = newSize;
    return;
  }
  public function size__(): int {
    return size;
  }
  public function toIntArray__(): JavaArray {
    if (points.length != size * 2) {
      var old: JavaArray = points;
      points = new JavaArray("[I").lengths(size * 2);
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(old, 0, points, 0, size * 2);
    }
    return points;
  }
  public function translate__Lorg_eclipse_draw2d_geometry_Point_2(pt: Point): void {
    this.translate__II(pt.x, pt.y);
  }
  public function translate__II(x: int, y: int): void {
    if (x == 0 && y == 0)
      return;
    if (bounds !== null)
      bounds.translate__II(x, y);
    for (var i: int = 0; i < size * 2; i += 2) {
      points[i] += x;
      points[i + 1] += y;
    }
    return;
  }
  public function transpose__(): void {
    var temp: int;
    if (bounds !== null)
      bounds.transpose__();
    for (var i: int = 0; i < size * 2; i += 2) {
      temp = points[i];
      points[i] = points[i + 1];
      points[i + 1] = temp;
    }
    return;
  }
  public function polygonContainsPoint__II(x: int, y: int): Boolean {
    return Geometry.polygonContainsPoint__Lorg_eclipse_draw2d_geometry_PointList_2II(this, x, y);
  }
  public function polylineContainsPoint__III(x: int, y: int, tolerance: int): Boolean {
    return Geometry.polylineContainsPoint__Lorg_eclipse_draw2d_geometry_PointList_2III(this, x, y, tolerance);
  }
  public function PointList(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is JavaArray) {
        args = vargs;
        id = 1;
      } else if (vargs.length == 1 && vargs[0] is int) {
        args = vargs;
        id = 2;
      }
    }
    switch (id) {
      case 0:
        break;
      case 1:
        var args1: Array = [args[0]];
        break;
      case 2:
        var args2: Array = [args[0]];
        break;
    }
    super();
    switch (id) {
      case 0:
        PointList__();
        break;
      case 1:
        PointList___3I(args1[0]);
        break;
      case 2:
        PointList__I(args2[0]);
        break;
    }
  }
  public static const PointList__ : int = 0;
  public static const PointList___3I : int = 1;
  public static const PointList__I : int = 2;
}
}
