package org.eclipse.draw2d.geometry {
import java.lang.Math__;
import java.lang.Arguments;
dynamic public class PrecisionDimension extends Dimension {
  public var preciseWidth: Number = 0;
  public var preciseHeight: Number = 0;
  public function PrecisionDimension__(): Object {
    return this;
  }
  public function PrecisionDimension__DD(width: Number, height: Number): Object {
    preciseWidth = width;
    preciseHeight = height;
    this.updateInts__();
    return this;
  }
  public function PrecisionDimension__Lorg_eclipse_draw2d_geometry_Dimension_2(d: Dimension): Object {
    preciseHeight = d.preciseHeight__();
    preciseWidth = d.preciseWidth__();
    this.updateInts__();
    return this;
  }
  public override function performScale__D(factor: Number): void {
    preciseHeight *= factor;
    preciseWidth *= factor;
    this.updateInts__();
    return;
  }
  public function updateInts__(): void {
    width = int(Math__.floor__D(preciseWidth + 1.0E-9));
    height = int(Math__.floor__D(preciseHeight + 1.0E-9));
    return;
  }
  public override function preciseWidth__(): Number {
    return preciseWidth;
  }
  public override function preciseHeight__(): Number {
    return preciseHeight;
  }
  public override function equals__Ljava_lang_Object_2(o: Object): Boolean {
    if (o is PrecisionDimension) {
      var d: PrecisionDimension = PrecisionDimension(o);
      return d.preciseWidth == preciseWidth && d.preciseHeight == preciseHeight;
    }
    return super.equals__Ljava_lang_Object_2(o);
  }
  public function PrecisionDimension(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 2 && vargs[0] is Number && vargs[1] is Number) {
        args = vargs;
        id = 1;
      } else if (vargs.length == 1 && vargs[0] is Dimension) {
        args = vargs;
        id = 2;
      }
    }
    switch (id) {
      case 0:
        var superArgs: Arguments;
        superArgs = new Arguments(org.eclipse.draw2d.geometry.Dimension.Dimension__, []);
        break;
      case 1:
        var args1: Array = [args[0], args[1]];
        superArgs = new Arguments(org.eclipse.draw2d.geometry.Dimension.Dimension__, []);
        break;
      case 2:
        var args2: Array = [args[0]];
        superArgs = new Arguments(org.eclipse.draw2d.geometry.Dimension.Dimension__, []);
        break;
    }
    super(superArgs);
    switch (id) {
      case 0:
        PrecisionDimension__();
        break;
      case 1:
        PrecisionDimension__DD(args1[0], args1[1]);
        break;
      case 2:
        PrecisionDimension__Lorg_eclipse_draw2d_geometry_Dimension_2(args2[0]);
        break;
    }
  }
  public static const PrecisionDimension__ : int = 0;
  public static const PrecisionDimension__DD : int = 1;
  public static const PrecisionDimension__Lorg_eclipse_draw2d_geometry_Dimension_2 : int = 2;
}
}
