package org.eclipse.draw2d.geometry {
import java.lang.Math__;
import java.lang.Arguments;
dynamic public class PrecisionPoint extends Point {
  public var preciseX: Number = 0;
  public var preciseY: Number = 0;
  public function PrecisionPoint__(): Object {
    return this;
  }
  public function PrecisionPoint__Lorg_eclipse_draw2d_geometry_Point_2(copy: Point): Object {
    preciseX = copy.preciseX__();
    preciseY = copy.preciseY__();
    this.updateInts__();
    return this;
  }
  public function PrecisionPoint__II(x: int, y: int): Object {
    preciseX = x;
    preciseY = y;
    return this;
  }
  public function PrecisionPoint__DD(x: Number, y: Number): Object {
    preciseX = x;
    preciseY = y;
    this.updateInts__();
    return this;
  }
  public override function getCopy__(): Point {
    return new PrecisionPoint(new Arguments(org.eclipse.draw2d.geometry.PrecisionPoint.PrecisionPoint__DD, [preciseX, preciseY]));
  }
  public override function performScale__D(factor: Number): void {
    preciseX = preciseX * factor;
    preciseY = preciseY * factor;
    this.updateInts__();
  }
  public override function performTranslate__II(dx: int, dy: int): void {
    preciseX += dx;
    preciseY += dy;
    this.updateInts__();
  }
  public override function setLocation__Lorg_eclipse_draw2d_geometry_Point_2(pt: Point): Point {
    preciseX = pt.preciseX__();
    preciseY = pt.preciseY__();
    this.updateInts__();
    return this;
  }
  public function updateInts__(): void {
    x = int(Math__.floor__D(preciseX + 1.0E-9));
    y = int(Math__.floor__D(preciseY + 1.0E-9));
  }
  public override function preciseX__(): Number {
    return preciseX;
  }
  public override function preciseY__(): Number {
    return preciseY;
  }
  public override function equals__Ljava_lang_Object_2(o: Object): Boolean {
    if (o is PrecisionPoint) {
      var p: PrecisionPoint = PrecisionPoint(o);
      return p.preciseX == preciseX && p.preciseY == preciseY;
    }
    return super.equals__Ljava_lang_Object_2(o);
  }
  public function PrecisionPoint(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is Point) {
        args = vargs;
        id = 1;
      } else if (vargs.length == 2 && vargs[0] is int && vargs[1] is int) {
        args = vargs;
        id = 2;
      } else if (vargs.length == 2 && vargs[0] is Number && vargs[1] is Number) {
        args = vargs;
        id = 3;
      }
    }
    switch (id) {
      case 0:
        var superArgs: Arguments;
        superArgs = new Arguments(org.eclipse.draw2d.geometry.Point.Point__, []);
        break;
      case 1:
        var args1: Array = [args[0]];
        superArgs = new Arguments(org.eclipse.draw2d.geometry.Point.Point__, []);
        break;
      case 2:
        var args2: Array = [args[0], args[1]];
        superArgs = new Arguments(org.eclipse.draw2d.geometry.Point.Point__II, [args2[0], args2[1]]);
        break;
      case 3:
        var args3: Array = [args[0], args[1]];
        superArgs = new Arguments(org.eclipse.draw2d.geometry.Point.Point__, []);
        break;
    }
    super(superArgs);
    switch (id) {
      case 0:
        PrecisionPoint__();
        break;
      case 1:
        PrecisionPoint__Lorg_eclipse_draw2d_geometry_Point_2(args1[0]);
        break;
      case 2:
        PrecisionPoint__II(args2[0], args2[1]);
        break;
      case 3:
        PrecisionPoint__DD(args3[0], args3[1]);
        break;
    }
  }
  public static const PrecisionPoint__ : int = 0;
  public static const PrecisionPoint__Lorg_eclipse_draw2d_geometry_Point_2 : int = 1;
  public static const PrecisionPoint__II : int = 2;
  public static const PrecisionPoint__DD : int = 3;
}
}
