package org.eclipse.draw2d.geometry {
import java.lang.Math__;
import java.lang.Arguments;
dynamic public class PrecisionRectangle extends Rectangle {
  public var preciseHeight: Number = 0;
  public var preciseWidth: Number = 0;
  public var preciseX: Number = 0;
  public var preciseY: Number = 0;
  public function PrecisionRectangle__(): Object {
    return this;
  }
  public function PrecisionRectangle__Lorg_eclipse_draw2d_geometry_Rectangle_2(rect: Rectangle): Object {
    preciseX = rect.preciseX__();
    preciseY = rect.preciseY__();
    preciseWidth = rect.preciseWidth__();
    preciseHeight = rect.preciseHeight__();
    this.updateInts__();
    return this;
  }
  public override function getCopy__(): Rectangle {
    return this.getPreciseCopy__();
  }
  public function getPreciseCopy__(): PrecisionRectangle {
    var result: PrecisionRectangle = new PrecisionRectangle(new Arguments(org.eclipse.draw2d.geometry.PrecisionRectangle.PrecisionRectangle__, []));
    result.preciseX = preciseX;
    result.preciseY = preciseY;
    result.preciseWidth = preciseWidth;
    result.preciseHeight = preciseHeight;
    result.updateInts__();
    return result;
  }
  public override function crop__Lorg_eclipse_draw2d_geometry_Insets_2(insets: Insets): Rectangle {
    if (insets === null)
      return this;
    this.setX__D(preciseX + insets.left);
    this.setY__D(preciseY + insets.top);
    this.setWidth__D(preciseWidth - (insets.getWidth__()));
    this.setHeight__D(preciseHeight - (insets.getHeight__()));
    return this;
  }
  public override function equals__Ljava_lang_Object_2(o: Object): Boolean {
    if (o is PrecisionRectangle) {
      var pr: PrecisionRectangle = PrecisionRectangle(o);
      return super.equals__Ljava_lang_Object_2(o) && Math__.abs__D(pr.preciseX - preciseX) < 1.0E-9 && Math__.abs__D(pr.preciseY - preciseY) < 1.0E-9 && Math__.abs__D(pr.preciseWidth - preciseWidth) < 1.0E-9 && Math__.abs__D(pr.preciseHeight - preciseHeight) < 1.0E-8;
    }
    return super.equals__Ljava_lang_Object_2(o);
  }
  public override function performScale__D(factor: Number): void {
    preciseX *= factor;
    preciseY *= factor;
    preciseWidth *= factor;
    preciseHeight *= factor;
    this.updateInts__();
  }
  public override function performTranslate__II(dx: int, dy: int): void {
    preciseX += dx;
    preciseY += dy;
    x += dx;
    y += dy;
  }
  public function preciseBottom__(): Number {
    return preciseHeight + preciseY;
  }
  public function preciseRight__(): Number {
    return preciseWidth + preciseX;
  }
  public override function resize__Lorg_eclipse_draw2d_geometry_Dimension_2(sizeDelta: Dimension): Rectangle {
    preciseWidth += sizeDelta.preciseWidth__();
    preciseHeight += sizeDelta.preciseHeight__();
    this.updateInts__();
    return this;
  }
  public function setHeight__D(value: Number): void {
    preciseHeight = value;
    height = int(Math__.floor__D(preciseHeight + 1.0E-9));
  }
  public function setWidth__D(value: Number): void {
    preciseWidth = value;
    width = int(Math__.floor__D(preciseWidth + 1.0E-9));
  }
  public function setX__D(value: Number): void {
    preciseX = value;
    x = int(Math__.floor__D(preciseX + 1.0E-9));
  }
  public function setY__D(value: Number): void {
    preciseY = value;
    y = int(Math__.floor__D(preciseY + 1.0E-9));
  }
  public override function translate__Lorg_eclipse_draw2d_geometry_Point_2(p: Point): Rectangle {
    preciseX += p.preciseX__();
    preciseY += p.preciseY__();
    this.updateInts__();
    return this;
  }
  public function union__Lorg_eclipse_draw2d_geometry_PrecisionRectangle_2(other: PrecisionRectangle): PrecisionRectangle {
    var newright: Number = Math__.max__DD(this.preciseRight__(), other.preciseRight__());
    var newbottom: Number = Math__.max__DD(this.preciseBottom__(), other.preciseBottom__());
    preciseX = Math__.min__DD(preciseX, other.preciseX);
    preciseY = Math__.min__DD(preciseY, other.preciseY);
    preciseWidth = newright - preciseX;
    preciseHeight = newbottom - preciseY;
    this.updateInts__();
    return this;
  }
  public override function union__Lorg_eclipse_draw2d_geometry_Rectangle_2(other: Rectangle): Rectangle {
    var newright: Number = Math__.max__DD(this.preciseRight__(), other.preciseX__() + other.preciseWidth__());
    var newbottom: Number = Math__.max__DD(this.preciseBottom__(), other.preciseY__() + other.preciseHeight__());
    preciseX = Math__.min__DD(preciseX, other.preciseX__());
    preciseY = Math__.min__DD(preciseY, other.preciseY__());
    preciseWidth = newright - preciseX;
    preciseHeight = newbottom - preciseY;
    this.updateInts__();
    return this;
  }
  public function updateInts__(): void {
    x = int(Math__.floor__D(preciseX + 1.0E-9));
    y = int(Math__.floor__D(preciseY + 1.0E-9));
    width = int(Math__.floor__D(preciseWidth + preciseX + 1.0E-9)) - x;
    height = int(Math__.floor__D(preciseHeight + preciseY + 1.0E-9)) - y;
  }
  public override function union__Lorg_eclipse_draw2d_geometry_Point_2(p: Point): void {
    if (p.preciseX__() < preciseX) {
      preciseWidth += (preciseX - p.preciseX__());
      preciseX = p.preciseX__();
    } else {
      var right: Number = preciseX + preciseWidth;
      if (p.preciseX__() > right) {
        preciseWidth = p.preciseX__() - preciseX;
      }
    }
    if (p.preciseY__() < preciseY) {
      preciseHeight += (preciseY - p.preciseY__());
      preciseY = p.preciseY__();
    } else {
      var bottom: Number = preciseY + preciseHeight;
      if (p.preciseY__() > bottom) {
        preciseHeight = p.preciseY__() - preciseY;
      }
    }
    this.updateInts__();
    return;
  }
  public override function transpose__(): Rectangle {
    var temp: Number = preciseX;
    preciseX = preciseY;
    preciseY = temp;
    temp = preciseWidth;
    preciseWidth = preciseHeight;
    preciseHeight = temp;
    super.transpose__();
    return this;
  }
  public override function setLocation__Lorg_eclipse_draw2d_geometry_Point_2(loc: Point): Rectangle {
    preciseX = loc.preciseX__();
    preciseY = loc.preciseY__();
    this.updateInts__();
    return this;
  }
  public override function getCenter__(): Point {
    return new PrecisionPoint(new Arguments(org.eclipse.draw2d.geometry.PrecisionPoint.PrecisionPoint__DD, [preciseX + preciseWidth / 2.0, preciseY + preciseHeight / 2.0]));
  }
  public function shrink__DD(h: Number, v: Number): Rectangle {
    preciseX += h;
    preciseWidth -= (h + h);
    preciseY += v;
    preciseHeight -= (v + v);
    this.updateInts__();
    return this;
  }
  public function expand__DD(h: Number, v: Number): Rectangle {
    return this.shrink__DD(-h, -v);
  }
  public override function shrink__II(h: int, v: int): Rectangle {
    return this.shrink__DD(Number(h), Number(v));
  }
  public override function contains__Lorg_eclipse_draw2d_geometry_Point_2(p: Point): Boolean {
    return preciseX <= p.preciseX__() && p.preciseX__() <= preciseX + preciseWidth && preciseY <= p.preciseY__() && p.preciseY__() <= preciseY + preciseHeight;
  }
  public override function preciseX__(): Number {
    return preciseX;
  }
  public override function preciseY__(): Number {
    return preciseY;
  }
  public override function preciseWidth__(): Number {
    return preciseWidth;
  }
  public override function preciseHeight__(): Number {
    return preciseHeight;
  }
  public override function setSize__Lorg_eclipse_draw2d_geometry_Dimension_2(d: Dimension): Rectangle {
    preciseWidth = d.preciseWidth__();
    preciseHeight = d.preciseHeight__();
    return super.setSize__Lorg_eclipse_draw2d_geometry_Dimension_2(d);
  }
  public function PrecisionRectangle(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is Rectangle) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        var superArgs: Arguments;
        superArgs = new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__, []);
        break;
      case 1:
        var args1: Array = [args[0]];
        superArgs = new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__, []);
        break;
    }
    super(superArgs);
    switch (id) {
      case 0:
        PrecisionRectangle__();
        break;
      case 1:
        PrecisionRectangle__Lorg_eclipse_draw2d_geometry_Rectangle_2(args1[0]);
        break;
    }
  }
  public static const PrecisionRectangle__ : int = 0;
  public static const PrecisionRectangle__Lorg_eclipse_draw2d_geometry_Rectangle_2 : int = 1;
}
}
