package org.eclipse.draw2d.geometry {
import java.lang.Math__;
import java.lang.Arguments;
dynamic public class Ray {
  public var x: int;
  public var y: int;
  public function Ray__(): Object {
    return this;
  }
  public function Ray__II(x: int, y: int): Object {
    this.x = x;
    this.y = y;
    return this;
  }
  public function Ray__Lorg_eclipse_draw2d_geometry_Point_2(p: Point): Object {
    x = p.x;
    y = p.y;
    return this;
  }
  public function Ray__Lorg_eclipse_draw2d_geometry_Point_2Lorg_eclipse_draw2d_geometry_Point_2(start: Point, end: Point): Object {
    x = end.x - start.x;
    y = end.y - start.y;
    return this;
  }
  public function Ray__Lorg_eclipse_draw2d_geometry_Ray_2Lorg_eclipse_draw2d_geometry_Ray_2(start: Ray, end: Ray): Object {
    x = end.x - start.x;
    y = end.y - start.y;
    return this;
  }
  public function assimilarity__Lorg_eclipse_draw2d_geometry_Ray_2(r: Ray): int {
    return Math__.abs__I(x * r.y - y * r.x);
  }
  public function dotProduct__Lorg_eclipse_draw2d_geometry_Ray_2(r: Ray): int {
    return x * r.x + y * r.y;
  }
  public function dotProductL__Lorg_eclipse_draw2d_geometry_Ray_2(r: Ray): Number {
    return Number(x) * r.x + Number(y) * r.y;
  }
  public function equals__Ljava_lang_Object_2(obj: Object): Boolean {
    if (obj === this)
      return true;
    if (obj is Ray) {
      var r: Ray = Ray(obj);
      return x == r.x && y == r.y;
    }
    return false;
  }
  public function getAdded__Lorg_eclipse_draw2d_geometry_Ray_2(r: Ray): Ray {
    return new Ray(new Arguments(org.eclipse.draw2d.geometry.Ray.Ray__II, [r.x + x, r.y + y]));
  }
  public function getAveraged__Lorg_eclipse_draw2d_geometry_Ray_2(r: Ray): Ray {
    return new Ray(new Arguments(org.eclipse.draw2d.geometry.Ray.Ray__II, [int((x + r.x) / 2), int((y + r.y) / 2)]));
  }
  public function getScaled__I(s: int): Ray {
    return new Ray(new Arguments(org.eclipse.draw2d.geometry.Ray.Ray__II, [x * s, y * s]));
  }
  public function hashCode__(): int {
    return (x * y) ^ (x + y);
  }
  public function isHorizontal__(): Boolean {
    return x != 0;
  }
  public function length__(): Number {
    return Math__.sqrt__D(this.dotProductL__Lorg_eclipse_draw2d_geometry_Ray_2(this));
  }
  public function similarity__Lorg_eclipse_draw2d_geometry_Ray_2(r: Ray): int {
    return Math__.abs__I(this.dotProduct__Lorg_eclipse_draw2d_geometry_Ray_2(r));
  }
  public function toString__(): String {
    return "(" + x + "," + y + ")";
  }
  public function Ray(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 2 && vargs[0] is int && vargs[1] is int) {
        args = vargs;
        id = 1;
      } else if (vargs.length == 1 && vargs[0] is Point) {
        args = vargs;
        id = 2;
      } else if (vargs.length == 2 && vargs[0] is Point && vargs[1] is Point) {
        args = vargs;
        id = 3;
      } else if (vargs.length == 2 && vargs[0] is Ray && vargs[1] is Ray) {
        args = vargs;
        id = 4;
      }
    }
    switch (id) {
      case 0:
        break;
      case 1:
        var args1: Array = [args[0], args[1]];
        break;
      case 2:
        var args2: Array = [args[0]];
        break;
      case 3:
        var args3: Array = [args[0], args[1]];
        break;
      case 4:
        var args4: Array = [args[0], args[1]];
        break;
    }
    super();
    switch (id) {
      case 0:
        Ray__();
        break;
      case 1:
        Ray__II(args1[0], args1[1]);
        break;
      case 2:
        Ray__Lorg_eclipse_draw2d_geometry_Point_2(args2[0]);
        break;
      case 3:
        Ray__Lorg_eclipse_draw2d_geometry_Point_2Lorg_eclipse_draw2d_geometry_Point_2(args3[0], args3[1]);
        break;
      case 4:
        Ray__Lorg_eclipse_draw2d_geometry_Ray_2Lorg_eclipse_draw2d_geometry_Ray_2(args4[0], args4[1]);
        break;
    }
  }
  public static const Ray__ : int = 0;
  public static const Ray__II : int = 1;
  public static const Ray__Lorg_eclipse_draw2d_geometry_Point_2 : int = 2;
  public static const Ray__Lorg_eclipse_draw2d_geometry_Point_2Lorg_eclipse_draw2d_geometry_Point_2 : int = 3;
  public static const Ray__Lorg_eclipse_draw2d_geometry_Ray_2Lorg_eclipse_draw2d_geometry_Ray_2 : int = 4;
}
}
