package org.eclipse.draw2d.geometry {
import org.eclipse.draw2d.PositionConstants;
import java.lang.Cloneable;
import java.io.Serializable;
import org.eclipse.swt.graphics.Rectangle;
import java.lang.Math__;
import java.lang.CloneNotSupportedException;
import java.lang.Arguments;
import java.lang.Class__;
dynamic public class Rectangle implements Cloneable, Serializable, Translatable {
  public var x: int;
  public var y: int;
  public var width: int;
  public var height: int;
  public static var SINGLETON: org.eclipse.draw2d.geometry.Rectangle = new org.eclipse.draw2d.geometry.Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__, []));
  public static const serialVersionUID: Number = 1;
  public function Rectangle__(): Object {
    return this;
  }
  public function Rectangle__Lorg_eclipse_draw2d_geometry_Point_2Lorg_eclipse_draw2d_geometry_Dimension_2(p: Point, size: Dimension): Object {
    return this;
  }
  public function Rectangle__Lorg_eclipse_draw2d_geometry_Rectangle_2(rect: org.eclipse.draw2d.geometry.Rectangle): Object {
    return this;
  }
  public function Rectangle__Lorg_eclipse_swt_graphics_Rectangle_2(rect: org.eclipse.swt.graphics.Rectangle): Object {
    return this;
  }
  public function Rectangle__IIII(x: int, y: int, width: int, height: int): Object {
    this.x = x;
    this.y = y;
    this.width = width;
    this.height = height;
    return this;
  }
  public function Rectangle__Lorg_eclipse_draw2d_geometry_Point_2Lorg_eclipse_draw2d_geometry_Point_2(p1: Point, p2: Point): Object {
    this.x = Math__.min__II(p1.x, p2.x);
    this.y = Math__.min__II(p1.y, p2.y);
    this.width = Math__.abs__I(p2.x - p1.x) + 1;
    this.height = Math__.abs__I(p2.y - p1.y) + 1;
    return this;
  }
  public function bottom__(): int {
    return y + height;
  }
  public function contains__Lorg_eclipse_draw2d_geometry_Point_2(pt: Point): Boolean {
    return this.contains__II(pt.x, pt.y);
  }
  public function contains__Lorg_eclipse_draw2d_geometry_Rectangle_2(rect: org.eclipse.draw2d.geometry.Rectangle): Boolean {
    return x <= rect.x && y <= rect.y && this.right__() >= rect.right__() && this.bottom__() >= rect.bottom__();
  }
  public function contains__II(x_1: int, y_1: int): Boolean {
    return y_1 >= this.y && y_1 < this.y + this.height && x_1 >= this.x && x_1 < this.x + this.width;
  }
  public function crop__Lorg_eclipse_draw2d_geometry_Insets_2(insets: Insets): org.eclipse.draw2d.geometry.Rectangle {
    if (insets === null)
      return this;
    x += insets.left;
    y += insets.top;
    width -= (insets.getWidth__());
    height -= (insets.getHeight__());
    return this;
  }
  public function equals__Ljava_lang_Object_2(o: Object): Boolean {
    if (this === o)
      return true;
    if (o is org.eclipse.draw2d.geometry.Rectangle) {
      var r: org.eclipse.draw2d.geometry.Rectangle = org.eclipse.draw2d.geometry.Rectangle(o);
      return (x == r.x) && (y == r.y) && (width == r.width) && (height == r.height);
    }
    return false;
  }
  public function expand__II(h: int, v: int): org.eclipse.draw2d.geometry.Rectangle {
    return this.shrink__II(-h, -v);
  }
  public function expand__Lorg_eclipse_draw2d_geometry_Insets_2(insets: Insets): org.eclipse.draw2d.geometry.Rectangle {
    x -= insets.left;
    y -= insets.top;
    height += insets.getHeight__();
    width += insets.getWidth__();
    return this;
  }
  public function getBottom__(): Point {
    return new Point(new Arguments(org.eclipse.draw2d.geometry.Point.Point__II, [x + int(width / 2), this.bottom__()]));
  }
  public function getBottomLeft__(): Point {
    return new Point(new Arguments(org.eclipse.draw2d.geometry.Point.Point__II, [x, y + height]));
  }
  public function getBottomRight__(): Point {
    return new Point(new Arguments(org.eclipse.draw2d.geometry.Point.Point__II, [x + width, y + height]));
  }
  public function getCenter__(): Point {
    return new Point(new Arguments(org.eclipse.draw2d.geometry.Point.Point__II, [x + int(width / 2), y + int(height / 2)]));
  }
  public function getCopy__(): org.eclipse.draw2d.geometry.Rectangle {
    if (Object(this).getClass__() === Class__.forName__Ljava_lang_String_2("org.eclipse.draw2d.geometry.Rectangle")) {
      return new org.eclipse.draw2d.geometry.Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__Lorg_eclipse_draw2d_geometry_Rectangle_2, [this]));
    } else {
      try {
        return org.eclipse.draw2d.geometry.Rectangle(Object(this).clone__());
      } catch (exc : CloneNotSupportedException) {
        return new org.eclipse.draw2d.geometry.Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__Lorg_eclipse_draw2d_geometry_Rectangle_2, [this]));
      }
    }
    return null;
  }
  public function getCropped__Lorg_eclipse_draw2d_geometry_Insets_2(insets: Insets): org.eclipse.draw2d.geometry.Rectangle {
    var r: org.eclipse.draw2d.geometry.Rectangle = new org.eclipse.draw2d.geometry.Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__Lorg_eclipse_draw2d_geometry_Rectangle_2, [this]));
    r.crop__Lorg_eclipse_draw2d_geometry_Insets_2(insets);
    return r;
  }
  public function getExpanded__II(h: int, v: int): org.eclipse.draw2d.geometry.Rectangle {
    return new org.eclipse.draw2d.geometry.Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__Lorg_eclipse_draw2d_geometry_Rectangle_2, [this])).expand__II(h, v);
  }
  public function getExpanded__Lorg_eclipse_draw2d_geometry_Insets_2(insets: Insets): org.eclipse.draw2d.geometry.Rectangle {
    return new org.eclipse.draw2d.geometry.Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__Lorg_eclipse_draw2d_geometry_Rectangle_2, [this])).expand__Lorg_eclipse_draw2d_geometry_Insets_2(insets);
  }
  public function getIntersection__Lorg_eclipse_draw2d_geometry_Rectangle_2(rect: org.eclipse.draw2d.geometry.Rectangle): org.eclipse.draw2d.geometry.Rectangle {
    var x1: int = Math__.max__II(x, rect.x);
    var x2: int = Math__.min__II(x + width, rect.x + rect.width);
    var y1: int = Math__.max__II(y, rect.y);
    var y2: int = Math__.min__II(y + height, rect.y + rect.height);
    if (((x2 - x1) < 0) || ((y2 - y1) < 0))
      return new org.eclipse.draw2d.geometry.Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__IIII, [0, 0, 0, 0]));
    else
      return new org.eclipse.draw2d.geometry.Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__IIII, [x1, y1, x2 - x1, y2 - y1]));
  }
  public function getLeft__(): Point {
    return new Point(new Arguments(org.eclipse.draw2d.geometry.Point.Point__II, [x, y + int(height / 2)]));
  }
  public function getLocation__(): Point {
    return new Point(new Arguments(org.eclipse.draw2d.geometry.Point.Point__II, [x, y]));
  }
  public function getPosition__Lorg_eclipse_draw2d_geometry_Point_2(pt: Point): int {
    var result: int = 0;
    if (this.contains__Lorg_eclipse_draw2d_geometry_Point_2(pt))
      return result;
    if (pt.x < x)
      result = 8;
    else if (pt.x >= (x + width))
      result = 16;
    if (pt.y < y)
      result = result | 1;
    else if (pt.y >= (y + height))
      result = result | 4;
    return result;
  }
  public function getResized__II(w: int, h: int): org.eclipse.draw2d.geometry.Rectangle {
    return new org.eclipse.draw2d.geometry.Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__Lorg_eclipse_draw2d_geometry_Rectangle_2, [this])).resize__II(w, h);
  }
  public function getResized__Lorg_eclipse_draw2d_geometry_Dimension_2(d: Dimension): org.eclipse.draw2d.geometry.Rectangle {
    return new org.eclipse.draw2d.geometry.Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__Lorg_eclipse_draw2d_geometry_Rectangle_2, [this])).resize__Lorg_eclipse_draw2d_geometry_Dimension_2(d);
  }
  public function getRight__(): Point {
    return new Point(new Arguments(org.eclipse.draw2d.geometry.Point.Point__II, [this.right__(), y + int(height / 2)]));
  }
  public function getSize__(): Dimension {
    return new Dimension(new Arguments(org.eclipse.draw2d.geometry.Dimension.Dimension__II, [width, height]));
  }
  public function getTop__(): Point {
    return new Point(new Arguments(org.eclipse.draw2d.geometry.Point.Point__II, [x + int(width / 2), y]));
  }
  public function getTopLeft__(): Point {
    return new Point(new Arguments(org.eclipse.draw2d.geometry.Point.Point__II, [x, y]));
  }
  public function getTopRight__(): Point {
    return new Point(new Arguments(org.eclipse.draw2d.geometry.Point.Point__II, [x + width, y]));
  }
  public function getTranslated__II(dx: int, dy: int): org.eclipse.draw2d.geometry.Rectangle {
    return new org.eclipse.draw2d.geometry.Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__Lorg_eclipse_draw2d_geometry_Rectangle_2, [this])).translate__II(dx, dy);
  }
  public function getTranslated__Lorg_eclipse_draw2d_geometry_Point_2(pt: Point): org.eclipse.draw2d.geometry.Rectangle {
    return new org.eclipse.draw2d.geometry.Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__Lorg_eclipse_draw2d_geometry_Rectangle_2, [this])).translate__Lorg_eclipse_draw2d_geometry_Point_2(pt);
  }
  public function getTransposed__(): org.eclipse.draw2d.geometry.Rectangle {
    var r: org.eclipse.draw2d.geometry.Rectangle = new org.eclipse.draw2d.geometry.Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__Lorg_eclipse_draw2d_geometry_Rectangle_2, [this]));
    r.transpose__();
    return r;
  }
  public function getUnion__Lorg_eclipse_draw2d_geometry_Rectangle_2(rect: org.eclipse.draw2d.geometry.Rectangle): org.eclipse.draw2d.geometry.Rectangle {
    if (rect === null || rect.isEmpty__())
      return new org.eclipse.draw2d.geometry.Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__Lorg_eclipse_draw2d_geometry_Rectangle_2, [this]));
    var union: org.eclipse.draw2d.geometry.Rectangle = new org.eclipse.draw2d.geometry.Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__IIII, [Math__.min__II(x, rect.x), Math__.min__II(y, rect.y), 0, 0]));
    union.width = Math__.max__II(x + width, rect.x + rect.width) - union.x;
    union.height = Math__.max__II(y + height, rect.y + rect.height) - union.y;
    return union;
  }
  public function hashCode__(): int {
    return (x + height + 1) * (y + width + 1) ^ x ^ y;
  }
  public function intersect__Lorg_eclipse_draw2d_geometry_Rectangle_2(rect: org.eclipse.draw2d.geometry.Rectangle): org.eclipse.draw2d.geometry.Rectangle {
    var x1: int = Math__.max__II(x, rect.x);
    var x2: int = Math__.min__II(x + width, rect.x + rect.width);
    var y1: int = Math__.max__II(y, rect.y);
    var y2: int = Math__.min__II(y + height, rect.y + rect.height);
    if (((x2 - x1) < 0) || ((y2 - y1) < 0))
      x = y = width = height = 0;
    else {
      x = x1;
      y = y1;
      width = x2 - x1;
      height = y2 - y1;
    }
    return this;
  }
  public function intersects__Lorg_eclipse_draw2d_geometry_Rectangle_2(rect: org.eclipse.draw2d.geometry.Rectangle): Boolean {
    return rect.x < x + width && rect.y < y + height && rect.x + rect.width > x && rect.y + rect.height > y;
  }
  public function isEmpty__(): Boolean {
    return width <= 0 || height <= 0;
  }
  public function performScale__D(factor: Number): void {
    this.scale__D(factor);
  }
  public function performTranslate__II(dx: int, dy: int): void {
    this.translate__II(dx, dy);
  }
  public function resize__Lorg_eclipse_draw2d_geometry_Dimension_2(sizeDelta: Dimension): org.eclipse.draw2d.geometry.Rectangle {
    width += sizeDelta.width;
    height += sizeDelta.height;
    return this;
  }
  public function resize__II(dw: int, dh: int): org.eclipse.draw2d.geometry.Rectangle {
    width += dw;
    height += dh;
    return this;
  }
  public function right__(): int {
    return x + width;
  }
  public function scale__D(scaleFactor: Number): org.eclipse.draw2d.geometry.Rectangle {
    return this.scale__DD(scaleFactor, scaleFactor);
  }
  public function scale__DD(scaleX: Number, scaleY: Number): org.eclipse.draw2d.geometry.Rectangle {
    var oldX: int = x;
    var oldY: int = y;
    x = int((Math__.floor__D(x * scaleX)));
    y = int((Math__.floor__D(y * scaleY)));
    width = int((Math__.ceil__D((oldX + width) * scaleX))) - x;
    height = int((Math__.ceil__D((oldY + height) * scaleY))) - y;
    return this;
  }
  public function setBounds__Lorg_eclipse_draw2d_geometry_Rectangle_2(rect: org.eclipse.draw2d.geometry.Rectangle): org.eclipse.draw2d.geometry.Rectangle {
    x = rect.x;
    y = rect.y;
    width = rect.width;
    height = rect.height;
    return this;
  }
  public function setLocation__Lorg_eclipse_draw2d_geometry_Point_2(p: Point): org.eclipse.draw2d.geometry.Rectangle {
    x = p.x;
    y = p.y;
    return this;
  }
  public function setLocation__II(x1: int, y1: int): org.eclipse.draw2d.geometry.Rectangle {
    x = x1;
    y = y1;
    return this;
  }
  public function setSize__Lorg_eclipse_draw2d_geometry_Dimension_2(d: Dimension): org.eclipse.draw2d.geometry.Rectangle {
    width = d.width;
    height = d.height;
    return this;
  }
  public function setSize__II(w: int, h: int): org.eclipse.draw2d.geometry.Rectangle {
    width = w;
    height = h;
    return this;
  }
  public function shrink__II(h: int, v: int): org.eclipse.draw2d.geometry.Rectangle {
    x += h;
    width -= (h + h);
    y += v;
    height -= (v + v);
    return this;
  }
  public function toString__(): String {
    return "Rectangle(" + x + ", " + y + ", " + width + ", " + height + ")";
  }
  public function touches__Lorg_eclipse_draw2d_geometry_Rectangle_2(rect: org.eclipse.draw2d.geometry.Rectangle): Boolean {
    return rect.x <= x + width && rect.y <= y + height && rect.x + rect.width >= x && rect.y + rect.height >= y;
  }
  public function translate__Lorg_eclipse_draw2d_geometry_Point_2(p: Point): org.eclipse.draw2d.geometry.Rectangle {
    x += p.x;
    y += p.y;
    return this;
  }
  public function translate__II(dx: int, dy: int): org.eclipse.draw2d.geometry.Rectangle {
    x += dx;
    y += dy;
    return this;
  }
  public function transpose__(): org.eclipse.draw2d.geometry.Rectangle {
    var temp: int = x;
    x = y;
    y = temp;
    temp = width;
    width = height;
    height = temp;
    return this;
  }
  public function union__Lorg_eclipse_draw2d_geometry_Dimension_2(d: Dimension): org.eclipse.draw2d.geometry.Rectangle {
    width = Math__.max__II(width, d.width);
    height = Math__.max__II(height, d.height);
    return this;
  }
  public function union__II(x1: int, y1: int): org.eclipse.draw2d.geometry.Rectangle {
    if (x1 < x) {
      width += (x - x1);
      x = x1;
    } else {
      var right: int = x + width;
      if (x1 >= right) {
        right = x1 + 1;
        width = right - x;
      }
    }
    if (y1 < y) {
      height += (y - y1);
      y = y1;
    } else {
      var bottom: int = y + height;
      if (y1 >= bottom) {
        bottom = y1 + 1;
        height = bottom - y;
      }
    }
    return this;
  }
  public function union__Lorg_eclipse_draw2d_geometry_Point_2(p: Point): void {
    this.union__II(p.x, p.y);
  }
  public function union__Lorg_eclipse_draw2d_geometry_Rectangle_2(rect: org.eclipse.draw2d.geometry.Rectangle): org.eclipse.draw2d.geometry.Rectangle {
    if (rect === null)
      return this;
    return this.union__IIII(rect.x, rect.y, rect.width, rect.height);
  }
  public function union__IIII(x_1: int, y_1: int, w: int, h: int): org.eclipse.draw2d.geometry.Rectangle {
    var right: int = Math__.max__II(this.x + width, x_1 + w);
    var bottom: int = Math__.max__II(this.y + height, y_1 + h);
    this.x = Math__.min__II(this.x, x_1);
    this.y = Math__.min__II(this.y, y_1);
    this.width = right - this.x;
    this.height = bottom - this.y;
    return this;
  }
  public function preciseX__(): Number {
    return x;
  }
  public function preciseY__(): Number {
    return y;
  }
  public function preciseWidth__(): Number {
    return width;
  }
  public function preciseHeight__(): Number {
    return height;
  }
  public function Rectangle(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 2 && vargs[0] is Point && vargs[1] is Dimension) {
        args = vargs;
        id = 1;
      } else if (vargs.length == 1 && vargs[0] is org.eclipse.draw2d.geometry.Rectangle) {
        args = vargs;
        id = 2;
      } else if (vargs.length == 1 && vargs[0] is org.eclipse.swt.graphics.Rectangle) {
        args = vargs;
        id = 3;
      } else if (vargs.length == 4 && vargs[0] is int && vargs[1] is int && vargs[2] is int && vargs[3] is int) {
        args = vargs;
        id = 4;
      } else if (vargs.length == 2 && vargs[0] is Point && vargs[1] is Point) {
        args = vargs;
        id = 5;
      }
    }
    switch (id) {
      case 0:
        break;
      case 1:
        var args1: Array = [args[0], args[1]];
        args4 = [args1[0].x, args1[0].y, args1[1].width, args1[1].height];
        break;
      case 2:
        var args2: Array = [args[0]];
        args4 = [args2[0].x, args2[0].y, args2[0].width, args2[0].height];
        break;
      case 3:
        var args3: Array = [args[0]];
        args4 = [args3[0].x, args3[0].y, args3[0].width, args3[0].height];
        break;
      case 4:
        var args4: Array = [args[0], args[1], args[2], args[3]];
        break;
      case 5:
        var args5: Array = [args[0], args[1]];
        break;
    }
    super();
    switch (id) {
      case 0:
        Rectangle__();
        break;
      case 1:
        Rectangle__IIII(args4[0], args4[1], args4[2], args4[3]);
        Rectangle__Lorg_eclipse_draw2d_geometry_Point_2Lorg_eclipse_draw2d_geometry_Dimension_2(args1[0], args1[1]);
        break;
      case 2:
        Rectangle__IIII(args4[0], args4[1], args4[2], args4[3]);
        Rectangle__Lorg_eclipse_draw2d_geometry_Rectangle_2(args2[0]);
        break;
      case 3:
        Rectangle__IIII(args4[0], args4[1], args4[2], args4[3]);
        Rectangle__Lorg_eclipse_swt_graphics_Rectangle_2(args3[0]);
        break;
      case 4:
        Rectangle__IIII(args4[0], args4[1], args4[2], args4[3]);
        break;
      case 5:
        Rectangle__Lorg_eclipse_draw2d_geometry_Point_2Lorg_eclipse_draw2d_geometry_Point_2(args5[0], args5[1]);
        break;
    }
  }
  public static const Rectangle__ : int = 0;
  public static const Rectangle__Lorg_eclipse_draw2d_geometry_Point_2Lorg_eclipse_draw2d_geometry_Dimension_2 : int = 1;
  public static const Rectangle__Lorg_eclipse_draw2d_geometry_Rectangle_2 : int = 2;
  public static const Rectangle__Lorg_eclipse_swt_graphics_Rectangle_2 : int = 3;
  public static const Rectangle__IIII : int = 4;
  public static const Rectangle__Lorg_eclipse_draw2d_geometry_Point_2Lorg_eclipse_draw2d_geometry_Point_2 : int = 5;
}
}
