package org.eclipse.draw2d.graph {
import java.util.ArrayList;
import java.util.List;
import java.util.List;
import java.util.ArrayList;
import java.lang.Integer;
import java.lang.Arguments;
dynamic public class BreakCycles extends GraphVisitor {
  internal var graphNodes: NodeList = new NodeList(new Arguments(org.eclipse.draw2d.graph.NodeList.NodeList__, []));
  private function allNodesFlagged__(): Boolean {
    for (var i: int = 0; i < graphNodes.size__(); i++) {
      if (graphNodes.getNode__I(i).flag == false)
        return false;
    }
    return true;
  }
  private function breakCycles__Lorg_eclipse_draw2d_graph_DirectedGraph_2(g: DirectedGraph): void {
    this.initializeDegrees__Lorg_eclipse_draw2d_graph_DirectedGraph_2(g);
    this.greedyCycleRemove__Lorg_eclipse_draw2d_graph_DirectedGraph_2(g);
    this.invertEdges__Lorg_eclipse_draw2d_graph_DirectedGraph_2(g);
  }
  private function containsCycles__Lorg_eclipse_draw2d_graph_DirectedGraph_2(g: DirectedGraph): Boolean {
    var noLefts: List = new ArrayList(new Arguments(java.util.ArrayList.ArrayList__, []));
    for (var i: int = 0; i < graphNodes.size__(); i++) {
      var node: Node = graphNodes.getNode__I(i);
      if (this.getIncomingCount__Lorg_eclipse_draw2d_graph_Node_2(node) == 0)
        this.sortedInsert__Ljava_util_List_2Lorg_eclipse_draw2d_graph_Node_2(noLefts, node);
    }
    while (noLefts.size__() > 0) {
      var node_1: Node = Node(noLefts.remove__I(noLefts.size__() - 1));
      node_1.flag = true;
      for (var i_1: int = 0; i_1 < node_1.outgoing.size__(); i_1++) {
        var right: Node = node_1.outgoing.getEdge__I(i_1).target;
        this.setIncomingCount__Lorg_eclipse_draw2d_graph_Node_2I(right, this.getIncomingCount__Lorg_eclipse_draw2d_graph_Node_2(right) - 1);
        if (this.getIncomingCount__Lorg_eclipse_draw2d_graph_Node_2(right) == 0)
          this.sortedInsert__Ljava_util_List_2Lorg_eclipse_draw2d_graph_Node_2(noLefts, right);
      }
    }
    if (this.allNodesFlagged__())
      return false;
    return true;
  }
  private function findNodeWithMaxDegree__(): Node {
    var max: int = -2147483648;
    var maxNode: Node = null;
    for (var i: int = 0; i < graphNodes.size__(); i++) {
      var node: Node = graphNodes.getNode__I(i);
      if (this.getDegree__Lorg_eclipse_draw2d_graph_Node_2(node) >= max && node.flag == false) {
        max = this.getDegree__Lorg_eclipse_draw2d_graph_Node_2(node);
        maxNode = node;
      }
    }
    return maxNode;
  }
  private function getDegree__Lorg_eclipse_draw2d_graph_Node_2(n: Node): int {
    return n.workingInts[3];
  }
  private function getIncomingCount__Lorg_eclipse_draw2d_graph_Node_2(n: Node): int {
    return n.workingInts[0];
  }
  private function getInDegree__Lorg_eclipse_draw2d_graph_Node_2(n: Node): int {
    return n.workingInts[1];
  }
  private function getOrderIndex__Lorg_eclipse_draw2d_graph_Node_2(n: Node): int {
    return n.workingInts[0];
  }
  private function getOutDegree__Lorg_eclipse_draw2d_graph_Node_2(n: Node): int {
    return n.workingInts[2];
  }
  private function greedyCycleRemove__Lorg_eclipse_draw2d_graph_DirectedGraph_2(g: DirectedGraph): void {
    var sL: NodeList = new NodeList(new Arguments(org.eclipse.draw2d.graph.NodeList.NodeList__, []));
    var sR: NodeList = new NodeList(new Arguments(org.eclipse.draw2d.graph.NodeList.NodeList__, []));
    do {
      var hasSink: Boolean;
      do {
        hasSink = false;
        for (var i: int = 0; i < graphNodes.size__(); i++) {
          var node: Node = graphNodes.getNode__I(i);
          if (this.getOutDegree__Lorg_eclipse_draw2d_graph_Node_2(node) == 0 && node.flag == false) {
            hasSink = true;
            node.flag = true;
            this.updateIncoming__Lorg_eclipse_draw2d_graph_Node_2(node);
            sR.add__Ljava_lang_Object_2(node);
            break;
          }
        }
      } while (hasSink);
      var hasSource: Boolean;
      do {
        hasSource = false;
        for (var i_1: int = 0; i_1 < graphNodes.size__(); i_1++) {
          var node_1: Node = graphNodes.getNode__I(i_1);
          if (this.getInDegree__Lorg_eclipse_draw2d_graph_Node_2(node_1) == 0 && node_1.flag == false) {
            hasSource = true;
            node_1.flag = true;
            this.updateOutgoing__Lorg_eclipse_draw2d_graph_Node_2(node_1);
            sL.add__Ljava_lang_Object_2(node_1);
            break;
          }
        }
      } while (hasSource);
      var max: Node = this.findNodeWithMaxDegree__();
      if (max !== null) {
        sL.add__Ljava_lang_Object_2(max);
        max.flag = true;
        this.updateIncoming__Lorg_eclipse_draw2d_graph_Node_2(max);
        this.updateOutgoing__Lorg_eclipse_draw2d_graph_Node_2(max);
      }
    } while (!this.allNodesFlagged__());
    var orderIndex: int = 0;
    for (var i_2: int = 0; i_2 < sL.size__(); i_2++) {
      this.setOrderIndex__Lorg_eclipse_draw2d_graph_Node_2I(sL.getNode__I(i_2), orderIndex++);
    }
    for (var i_3: int = sR.size__() - 1; i_3 >= 0; i_3--) {
      this.setOrderIndex__Lorg_eclipse_draw2d_graph_Node_2I(sR.getNode__I(i_3), orderIndex++);
    }
    return;
  }
  private function initializeDegrees__Lorg_eclipse_draw2d_graph_DirectedGraph_2(g: DirectedGraph): void {
    graphNodes.resetFlags__();
    for (var i: int = 0; i < g.nodes.size__(); i++) {
      var n: Node = graphNodes.getNode__I(i);
      this.setInDegree__Lorg_eclipse_draw2d_graph_Node_2I(n, n.incoming.size__());
      this.setOutDegree__Lorg_eclipse_draw2d_graph_Node_2I(n, n.outgoing.size__());
      this.setDegree__Lorg_eclipse_draw2d_graph_Node_2I(n, n.outgoing.size__() - n.incoming.size__());
    }
    return;
  }
  private function invertEdges__Lorg_eclipse_draw2d_graph_DirectedGraph_2(g: DirectedGraph): void {
    for (var i: int = 0; i < g.edges.size__(); i++) {
      var e: Edge = g.edges.getEdge__I(i);
      if (this.getOrderIndex__Lorg_eclipse_draw2d_graph_Node_2(e.source) > this.getOrderIndex__Lorg_eclipse_draw2d_graph_Node_2(e.target)) {
        e.invert__();
        e.isFeedback = true;
      }
    }
    return;
  }
  private function setDegree__Lorg_eclipse_draw2d_graph_Node_2I(n: Node, deg: int): void {
    n.workingInts[3] = deg;
    return;
  }
  private function setIncomingCount__Lorg_eclipse_draw2d_graph_Node_2I(n: Node, count: int): void {
    n.workingInts[0] = count;
    return;
  }
  private function setInDegree__Lorg_eclipse_draw2d_graph_Node_2I(n: Node, deg: int): void {
    n.workingInts[1] = deg;
    return;
  }
  private function setOutDegree__Lorg_eclipse_draw2d_graph_Node_2I(n: Node, deg: int): void {
    n.workingInts[2] = deg;
    return;
  }
  private function setOrderIndex__Lorg_eclipse_draw2d_graph_Node_2I(n: Node, index: int): void {
    n.workingInts[0] = index;
    return;
  }
  private function sortedInsert__Ljava_util_List_2Lorg_eclipse_draw2d_graph_Node_2(list: List, node: Node): void {
    var insert: int = 0;
    while (insert < list.size__() && (Node(list.get__I(insert))).sortValue > node.sortValue)
      insert++;
    list.add__ILjava_lang_Object_2(insert, node);
    return;
  }
  private function updateIncoming__Lorg_eclipse_draw2d_graph_Node_2(n: Node): void {
    for (var i: int = 0; i < n.incoming.size__(); i++) {
      var in_1: Node = n.incoming.getEdge__I(i).source;
      if (in_1.flag == false) {
        this.setOutDegree__Lorg_eclipse_draw2d_graph_Node_2I(in_1, this.getOutDegree__Lorg_eclipse_draw2d_graph_Node_2(in_1) - 1);
        this.setDegree__Lorg_eclipse_draw2d_graph_Node_2I(in_1, this.getOutDegree__Lorg_eclipse_draw2d_graph_Node_2(in_1) - this.getInDegree__Lorg_eclipse_draw2d_graph_Node_2(in_1));
      }
    }
    return;
  }
  private function updateOutgoing__Lorg_eclipse_draw2d_graph_Node_2(n: Node): void {
    for (var i: int = 0; i < n.outgoing.size__(); i++) {
      var out: Node = n.outgoing.getEdge__I(i).target;
      if (out.flag == false) {
        this.setInDegree__Lorg_eclipse_draw2d_graph_Node_2I(out, this.getInDegree__Lorg_eclipse_draw2d_graph_Node_2(out) - 1);
        this.setDegree__Lorg_eclipse_draw2d_graph_Node_2I(out, this.getOutDegree__Lorg_eclipse_draw2d_graph_Node_2(out) - this.getInDegree__Lorg_eclipse_draw2d_graph_Node_2(out));
      }
    }
    return;
  }
  public override function revisit__Lorg_eclipse_draw2d_graph_DirectedGraph_2(g: DirectedGraph): void {
    for (var i: int = 0; i < g.edges.size__(); i++) {
      var e: Edge = g.edges.getEdge__I(i);
      if (e.isFeedback__())
        e.invert__();
    }
    return;
  }
  public override function visit__Lorg_eclipse_draw2d_graph_DirectedGraph_2(g: DirectedGraph): void {
    graphNodes.resetFlags__();
    for (var i: int = 0; i < g.nodes.size__(); i++) {
      var n: Node = g.nodes.getNode__I(i);
      this.setIncomingCount__Lorg_eclipse_draw2d_graph_Node_2I(n, n.incoming.size__());
      graphNodes.add__Ljava_lang_Object_2(n);
    }
    if (this.containsCycles__Lorg_eclipse_draw2d_graph_DirectedGraph_2(g)) {
      this.breakCycles__Lorg_eclipse_draw2d_graph_DirectedGraph_2(g);
    }
    return;
  }
}
}
