package org.eclipse.draw2d.graph {
dynamic public class CollapsedEdges {
  internal var collapsedWeight: int;
  internal var collapsedCount: int;
  internal var overage: int;
  internal var unOverage: int;
  internal var tightestEdge: Edge;
  function CollapsedEdges(edge: Edge) {
    tightestEdge = edge;
    collapsedWeight = edge.weight;
    collapsedCount++;
    return;
  }
  public function getWeightedPull__(): int {
    return tightestEdge.getSlack__() * collapsedWeight + overage;
  }
  public function isTight__(): Boolean {
    return tightestEdge.getSlack__() == 0;
  }
  public function processEdge__Lorg_eclipse_draw2d_graph_Edge_2(candidate: Edge): Edge {
    collapsedCount++;
    if (candidate.getSlack__() < tightestEdge.getSlack__()) {
      overage += collapsedWeight * (tightestEdge.getSlack__() - candidate.getSlack__());
      var temp: Edge = tightestEdge;
      tightestEdge = candidate;
      collapsedWeight += candidate.weight;
      return temp;
    } else {
      var over: int = candidate.getSlack__() - tightestEdge.getSlack__();
      unOverage += over;
      overage += candidate.weight * over;
      collapsedWeight += candidate.weight;
      return candidate;
    }
    return null;
  }
}
}
