package org.eclipse.draw2d.graph {
import java.lang.Integer;
import java.lang.Arguments;
dynamic public class CompoundBreakCycles extends GraphVisitor {
  private var graphNodes: NodeList;
  private var sL: NodeList = new NodeList(new Arguments(org.eclipse.draw2d.graph.NodeList.NodeList__, []));
  private function allFlagged__Lorg_eclipse_draw2d_graph_NodeList_2(nodes: NodeList): Boolean {
    for (var i: int = 0; i < nodes.size__(); i++) {
      if (nodes.getNode__I(i).flag == false)
        return false;
    }
    return true;
  }
  private function buildNestingTreeIndices__Lorg_eclipse_draw2d_graph_NodeList_2I(nodes: NodeList, base: int): int {
    for (var i: int = 0; i < nodes.size__(); i++) {
      var node: Node = Node(nodes.get__I(i));
      if (node is Subgraph) {
        var s: Subgraph = Subgraph(node);
        s.nestingTreeMin = base;
        base = this.buildNestingTreeIndices__Lorg_eclipse_draw2d_graph_NodeList_2I(s.members, base);
      }
      node.nestingIndex = base++;
    }
    return base++;
  }
  private function canBeRemoved__Lorg_eclipse_draw2d_graph_Node_2(n: Node): Boolean {
    return !n.flag && this.getChildCount__Lorg_eclipse_draw2d_graph_Node_2(n) == 0;
  }
  private function changeInDegree__Lorg_eclipse_draw2d_graph_Node_2I(n: Node, delta: int): Boolean {
    return (n.workingInts[1] += delta) == 0;
  }
  private function changeOutDegree__Lorg_eclipse_draw2d_graph_Node_2I(n: Node, delta: int): Boolean {
    return (n.workingInts[2] += delta) == 0;
  }
  private function cycleRemove__Lorg_eclipse_draw2d_graph_NodeList_2(children: NodeList): void {
    var sR: NodeList = new NodeList(new Arguments(org.eclipse.draw2d.graph.NodeList.NodeList__, []));
    do {
      this.findSinks__Lorg_eclipse_draw2d_graph_NodeList_2Lorg_eclipse_draw2d_graph_NodeList_2(children, sR);
      this.findSources__Lorg_eclipse_draw2d_graph_NodeList_2(children);
      var max: Node = this.findNodeWithMaxDegree__Lorg_eclipse_draw2d_graph_NodeList_2(children);
      if (max !== null) {
        for (var i: int = 0; i < children.size__(); i++) {
          var child: Node = Node(children.get__I(i));
          if (child.flag)
            continue;
          if (child === max)
            this.restoreSinks__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_NodeList_2(max, sR);
          else
            this.restoreSources__Lorg_eclipse_draw2d_graph_Node_2(child);
        }
        this.remove__Lorg_eclipse_draw2d_graph_Node_2(max);
      }
    } while (!this.allFlagged__Lorg_eclipse_draw2d_graph_NodeList_2(children));
    while (!sR.isEmpty__())
      sL.add__Ljava_lang_Object_2(sR.remove__I(sR.size__() - 1));
    return;
  }
  private function findInitialSinks__Lorg_eclipse_draw2d_graph_NodeList_2Lorg_eclipse_draw2d_graph_NodeList_2(children: NodeList, sinks: NodeList): void {
    for (var i: int = 0; i < children.size__(); i++) {
      var node: Node = children.getNode__I(i);
      if (node.flag)
        continue;
      if (this.isSink__Lorg_eclipse_draw2d_graph_Node_2(node) && this.canBeRemoved__Lorg_eclipse_draw2d_graph_Node_2(node)) {
        sinks.add__Ljava_lang_Object_2(node);
        node.flag = true;
      }
      if (node is Subgraph)
        this.findInitialSinks__Lorg_eclipse_draw2d_graph_NodeList_2Lorg_eclipse_draw2d_graph_NodeList_2((Subgraph(node)).members, sinks);
    }
    return;
  }
  private function findInitialSources__Lorg_eclipse_draw2d_graph_NodeList_2Lorg_eclipse_draw2d_graph_NodeList_2(children: NodeList, sources: NodeList): void {
    for (var i: int = 0; i < children.size__(); i++) {
      var node: Node = children.getNode__I(i);
      if (this.isSource__Lorg_eclipse_draw2d_graph_Node_2(node) && this.canBeRemoved__Lorg_eclipse_draw2d_graph_Node_2(node)) {
        sources.add__Ljava_lang_Object_2(node);
        node.flag = true;
      }
      if (node is Subgraph)
        this.findInitialSources__Lorg_eclipse_draw2d_graph_NodeList_2Lorg_eclipse_draw2d_graph_NodeList_2((Subgraph(node)).members, sources);
    }
    return;
  }
  private function findNodeWithMaxDegree__Lorg_eclipse_draw2d_graph_NodeList_2(nodes: NodeList): Node {
    var max: int = -2147483648;
    var maxNode: Node = null;
    for (var i: int = 0; i < nodes.size__(); i++) {
      var node: Node = nodes.getNode__I(i);
      if (node.flag)
        continue;
      var degree: int = this.getNestedOutDegree__Lorg_eclipse_draw2d_graph_Node_2(node) - this.getNestedInDegree__Lorg_eclipse_draw2d_graph_Node_2(node);
      if (degree >= max && node.flag == false) {
        max = degree;
        maxNode = node;
      }
    }
    return maxNode;
  }
  private function findSinks__Lorg_eclipse_draw2d_graph_NodeList_2Lorg_eclipse_draw2d_graph_NodeList_2(children: NodeList, rightList: NodeList): void {
    var sinks: NodeList = new NodeList(new Arguments(org.eclipse.draw2d.graph.NodeList.NodeList__, []));
    this.findInitialSinks__Lorg_eclipse_draw2d_graph_NodeList_2Lorg_eclipse_draw2d_graph_NodeList_2(children, sinks);
    while (!sinks.isEmpty__()) {
      var sink: Node = sinks.getNode__I(sinks.size__() - 1);
      rightList.add__Ljava_lang_Object_2(sink);
      sinks.remove__Ljava_lang_Object_2(sink);
      this.removeSink__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_NodeList_2(sink, sinks);
      if (sink.getParent__() !== null) {
        var parent: Node = sink.getParent__();
        this.setChildCount__Lorg_eclipse_draw2d_graph_Node_2I(parent, this.getChildCount__Lorg_eclipse_draw2d_graph_Node_2(parent) - 1);
        if (this.isSink__Lorg_eclipse_draw2d_graph_Node_2(parent) && this.canBeRemoved__Lorg_eclipse_draw2d_graph_Node_2(parent)) {
          sinks.add__Ljava_lang_Object_2(parent);
          parent.flag = true;
        }
      }
    }
    return;
  }
  private function findSources__Lorg_eclipse_draw2d_graph_NodeList_2(children: NodeList): void {
    var sources: NodeList = new NodeList(new Arguments(org.eclipse.draw2d.graph.NodeList.NodeList__, []));
    this.findInitialSources__Lorg_eclipse_draw2d_graph_NodeList_2Lorg_eclipse_draw2d_graph_NodeList_2(children, sources);
    while (!sources.isEmpty__()) {
      var source: Node = sources.getNode__I(sources.size__() - 1);
      sL.add__Ljava_lang_Object_2(source);
      sources.remove__Ljava_lang_Object_2(source);
      this.removeSource__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_NodeList_2(source, sources);
      if (source.getParent__() !== null) {
        var parent: Node = source.getParent__();
        this.setChildCount__Lorg_eclipse_draw2d_graph_Node_2I(parent, this.getChildCount__Lorg_eclipse_draw2d_graph_Node_2(parent) - 1);
        if (this.isSource__Lorg_eclipse_draw2d_graph_Node_2(parent) && this.canBeRemoved__Lorg_eclipse_draw2d_graph_Node_2(parent)) {
          sources.add__Ljava_lang_Object_2(parent);
          parent.flag = true;
        }
      }
    }
    return;
  }
  private function getChildCount__Lorg_eclipse_draw2d_graph_Node_2(n: Node): int {
    return n.workingInts[3];
  }
  private function getInDegree__Lorg_eclipse_draw2d_graph_Node_2(n: Node): int {
    return n.workingInts[1];
  }
  private function getNestedInDegree__Lorg_eclipse_draw2d_graph_Node_2(n: Node): int {
    var result: int = this.getInDegree__Lorg_eclipse_draw2d_graph_Node_2(n);
    if (n is Subgraph) {
      var s: Subgraph = Subgraph(n);
      for (var i: int = 0; i < s.members.size__(); i++)
        if (!s.members.getNode__I(i).flag)
          result += this.getInDegree__Lorg_eclipse_draw2d_graph_Node_2(s.members.getNode__I(i));
    }
    return result;
  }
  private function getNestedOutDegree__Lorg_eclipse_draw2d_graph_Node_2(n: Node): int {
    var result: int = this.getOutDegree__Lorg_eclipse_draw2d_graph_Node_2(n);
    if (n is Subgraph) {
      var s: Subgraph = Subgraph(n);
      for (var i: int = 0; i < s.members.size__(); i++)
        if (!s.members.getNode__I(i).flag)
          result += this.getOutDegree__Lorg_eclipse_draw2d_graph_Node_2(s.members.getNode__I(i));
    }
    return result;
  }
  private function getOrderIndex__Lorg_eclipse_draw2d_graph_Node_2(n: Node): int {
    return n.workingInts[0];
  }
  private function getOutDegree__Lorg_eclipse_draw2d_graph_Node_2(n: Node): int {
    return n.workingInts[2];
  }
  private function initializeDegrees__Lorg_eclipse_draw2d_graph_DirectedGraph_2(g: DirectedGraph): void {
    g.nodes.resetFlags__();
    g.edges.resetFlags__Z(false);
    for (var i: int = 0; i < g.nodes.size__(); i++) {
      var n: Node = g.nodes.getNode__I(i);
      this.setInDegree__Lorg_eclipse_draw2d_graph_Node_2I(n, n.incoming.size__());
      this.setOutDegree__Lorg_eclipse_draw2d_graph_Node_2I(n, n.outgoing.size__());
      if (n is Subgraph)
        this.setChildCount__Lorg_eclipse_draw2d_graph_Node_2I(n, (Subgraph(n)).members.size__());
      else
        this.setChildCount__Lorg_eclipse_draw2d_graph_Node_2I(n, 0);
    }
    return;
  }
  private function invertEdges__Lorg_eclipse_draw2d_graph_DirectedGraph_2(g: DirectedGraph): void {
    var orderIndex: int = 0;
    for (var i: int = 0; i < sL.size__(); i++) {
      this.setOrderIndex__Lorg_eclipse_draw2d_graph_Node_2I(sL.getNode__I(i), orderIndex++);
    }
    for (var i_1: int = 0; i_1 < g.edges.size__(); i_1++) {
      var e: Edge = g.edges.getEdge__I(i_1);
      if (this.getOrderIndex__Lorg_eclipse_draw2d_graph_Node_2(e.source) > this.getOrderIndex__Lorg_eclipse_draw2d_graph_Node_2(e.target) && !e.source.isNested__Lorg_eclipse_draw2d_graph_Node_2(e.target) && !e.target.isNested__Lorg_eclipse_draw2d_graph_Node_2(e.source)) {
        e.invert__();
        e.isFeedback = true;
      }
    }
    return;
  }
  private function isolateSubgraph__Lorg_eclipse_draw2d_graph_Subgraph_2Lorg_eclipse_draw2d_graph_Node_2(subgraph: Subgraph, member: Node): void {
    var edge: Edge = null;
    for (var i: int = 0; i < member.incoming.size__(); i++) {
      edge = member.incoming.getEdge__I(i);
      if (!subgraph.isNested__Lorg_eclipse_draw2d_graph_Node_2(edge.source) && !edge.flag)
        this.removeEdge__Lorg_eclipse_draw2d_graph_Edge_2(edge);
    }
    for (var i_1: int = 0; i_1 < member.outgoing.size__(); i_1++) {
      edge = member.outgoing.getEdge__I(i_1);
      if (!subgraph.isNested__Lorg_eclipse_draw2d_graph_Node_2(edge.target) && !edge.flag)
        this.removeEdge__Lorg_eclipse_draw2d_graph_Edge_2(edge);
    }
    if (member is Subgraph) {
      var members: NodeList = (Subgraph(member)).members;
      for (var i_2: int = 0; i_2 < members.size__(); i_2++)
        this.isolateSubgraph__Lorg_eclipse_draw2d_graph_Subgraph_2Lorg_eclipse_draw2d_graph_Node_2(subgraph, members.getNode__I(i_2));
    }
    return;
  }
  private function isSink__Lorg_eclipse_draw2d_graph_Node_2(n: Node): Boolean {
    return this.getOutDegree__Lorg_eclipse_draw2d_graph_Node_2(n) == 0 && (n.getParent__() === null || this.isSink__Lorg_eclipse_draw2d_graph_Node_2(n.getParent__()));
  }
  private function isSource__Lorg_eclipse_draw2d_graph_Node_2(n: Node): Boolean {
    return this.getInDegree__Lorg_eclipse_draw2d_graph_Node_2(n) == 0 && (n.getParent__() === null || this.isSource__Lorg_eclipse_draw2d_graph_Node_2(n.getParent__()));
  }
  private function remove__Lorg_eclipse_draw2d_graph_Node_2(n: Node): void {
    n.flag = true;
    if (n.getParent__() !== null)
      this.setChildCount__Lorg_eclipse_draw2d_graph_Node_2I(n.getParent__(), this.getChildCount__Lorg_eclipse_draw2d_graph_Node_2(n.getParent__()) - 1);
    this.removeSink__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_NodeList_2(n, null);
    this.removeSource__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_NodeList_2(n, null);
    sL.add__Ljava_lang_Object_2(n);
    if (n is Subgraph) {
      var s: Subgraph = Subgraph(n);
      this.isolateSubgraph__Lorg_eclipse_draw2d_graph_Subgraph_2Lorg_eclipse_draw2d_graph_Node_2(s, s);
      this.cycleRemove__Lorg_eclipse_draw2d_graph_NodeList_2(s.members);
    }
    return;
  }
  private function removeEdge__Lorg_eclipse_draw2d_graph_Edge_2(e: Edge): Boolean {
    if (e.flag)
      return false;
    e.flag = true;
    this.changeOutDegree__Lorg_eclipse_draw2d_graph_Node_2I(e.source, -1);
    this.changeInDegree__Lorg_eclipse_draw2d_graph_Node_2I(e.target, -1);
    return true;
  }
  private function removeParentChildEdges__Lorg_eclipse_draw2d_graph_DirectedGraph_2(g: DirectedGraph): void {
    for (var i: int = 0; i < g.edges.size__(); i++) {
      var e: Edge = g.edges.getEdge__I(i);
      if (e.source.isNested__Lorg_eclipse_draw2d_graph_Node_2(e.target) || e.target.isNested__Lorg_eclipse_draw2d_graph_Node_2(e.source))
        this.removeEdge__Lorg_eclipse_draw2d_graph_Edge_2(e);
    }
    return;
  }
  private function removeSink__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_NodeList_2(sink: Node, allSinks: NodeList): void {
    for (var i: int = 0; i < sink.incoming.size__(); i++) {
      var e: Edge = sink.incoming.getEdge__I(i);
      if (!e.flag) {
        this.removeEdge__Lorg_eclipse_draw2d_graph_Edge_2(e);
        var source: Node = e.source;
        if (allSinks !== null && this.isSink__Lorg_eclipse_draw2d_graph_Node_2(source) && this.canBeRemoved__Lorg_eclipse_draw2d_graph_Node_2(source)) {
          allSinks.add__Ljava_lang_Object_2(source);
          source.flag = true;
        }
      }
    }
    return;
  }
  private function removeSource__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_NodeList_2(n: Node, allSources: NodeList): void {
    for (var i: int = 0; i < n.outgoing.size__(); i++) {
      var e: Edge = n.outgoing.getEdge__I(i);
      if (!e.flag) {
        e.flag = true;
        this.changeInDegree__Lorg_eclipse_draw2d_graph_Node_2I(e.target, -1);
        this.changeOutDegree__Lorg_eclipse_draw2d_graph_Node_2I(e.source, -1);
        var target: Node = e.target;
        if (allSources !== null && this.isSource__Lorg_eclipse_draw2d_graph_Node_2(target) && this.canBeRemoved__Lorg_eclipse_draw2d_graph_Node_2(target)) {
          allSources.add__Ljava_lang_Object_2(target);
          target.flag = true;
        }
      }
    }
    return;
  }
  private function restoreEdge__Lorg_eclipse_draw2d_graph_Edge_2(e: Edge): Boolean {
    if (!e.flag || e.source.flag || e.target.flag)
      return false;
    e.flag = false;
    this.changeOutDegree__Lorg_eclipse_draw2d_graph_Node_2I(e.source, 1);
    this.changeInDegree__Lorg_eclipse_draw2d_graph_Node_2I(e.target, 1);
    return true;
  }
  private function restoreSinks__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_NodeList_2(node: Node, sR: NodeList): void {
    if (node.flag && sR.contains__Ljava_lang_Object_2(node)) {
      node.flag = false;
      if (node.getParent__() !== null)
        this.setChildCount__Lorg_eclipse_draw2d_graph_Node_2I(node.getParent__(), this.getChildCount__Lorg_eclipse_draw2d_graph_Node_2(node.getParent__()) + 1);
      sR.remove__Ljava_lang_Object_2(node);
      for (var i: int = 0; i < node.incoming.size__(); i++) {
        var e: Edge = node.incoming.getEdge__I(i);
        this.restoreEdge__Lorg_eclipse_draw2d_graph_Edge_2(e);
      }
      for (var i_1: int = 0; i_1 < node.outgoing.size__(); i_1++) {
        var e_1: Edge = node.outgoing.getEdge__I(i_1);
        this.restoreEdge__Lorg_eclipse_draw2d_graph_Edge_2(e_1);
      }
    }
    if (node is Subgraph) {
      var s: Subgraph = Subgraph(node);
      for (var i_2: int = 0; i_2 < s.members.size__(); i_2++) {
        var member: Node = s.members.getNode__I(i_2);
        this.restoreSinks__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_NodeList_2(member, sR);
      }
    }
    return;
  }
  private function restoreSources__Lorg_eclipse_draw2d_graph_Node_2(node: Node): void {
    if (node.flag && sL.contains__Ljava_lang_Object_2(node)) {
      node.flag = false;
      if (node.getParent__() !== null)
        this.setChildCount__Lorg_eclipse_draw2d_graph_Node_2I(node.getParent__(), this.getChildCount__Lorg_eclipse_draw2d_graph_Node_2(node.getParent__()) + 1);
      sL.remove__Ljava_lang_Object_2(node);
      for (var i: int = 0; i < node.incoming.size__(); i++) {
        var e: Edge = node.incoming.getEdge__I(i);
        this.restoreEdge__Lorg_eclipse_draw2d_graph_Edge_2(e);
      }
      for (var i_1: int = 0; i_1 < node.outgoing.size__(); i_1++) {
        var e_1: Edge = node.outgoing.getEdge__I(i_1);
        this.restoreEdge__Lorg_eclipse_draw2d_graph_Edge_2(e_1);
      }
    }
    if (node is Subgraph) {
      var s: Subgraph = Subgraph(node);
      for (var i_2: int = 0; i_2 < s.members.size__(); i_2++) {
        var member: Node = s.members.getNode__I(i_2);
        this.restoreSources__Lorg_eclipse_draw2d_graph_Node_2(member);
      }
    }
    return;
  }
  public override function revisit__Lorg_eclipse_draw2d_graph_DirectedGraph_2(g: DirectedGraph): void {
    for (var i: int = 0; i < g.edges.size__(); i++) {
      var e: Edge = g.edges.getEdge__I(i);
      if (e.isFeedback__())
        e.invert__();
    }
    return;
  }
  private function setChildCount__Lorg_eclipse_draw2d_graph_Node_2I(n: Node, count: int): void {
    n.workingInts[3] = count;
    return;
  }
  private function setInDegree__Lorg_eclipse_draw2d_graph_Node_2I(n: Node, deg: int): void {
    n.workingInts[1] = deg;
    return;
  }
  private function setOrderIndex__Lorg_eclipse_draw2d_graph_Node_2I(n: Node, index: int): void {
    n.workingInts[0] = index;
    return;
  }
  private function setOutDegree__Lorg_eclipse_draw2d_graph_Node_2I(n: Node, deg: int): void {
    n.workingInts[2] = deg;
    return;
  }
  public override function visit__Lorg_eclipse_draw2d_graph_DirectedGraph_2(g: DirectedGraph): void {
    this.initializeDegrees__Lorg_eclipse_draw2d_graph_DirectedGraph_2(g);
    graphNodes = g.nodes;
    var roots: NodeList = new NodeList(new Arguments(org.eclipse.draw2d.graph.NodeList.NodeList__, []));
    for (var i: int = 0; i < graphNodes.size__(); i++) {
      if (graphNodes.getNode__I(i).getParent__() === null)
        roots.add__Ljava_lang_Object_2(graphNodes.getNode__I(i));
    }
    this.buildNestingTreeIndices__Lorg_eclipse_draw2d_graph_NodeList_2I(roots, 0);
    this.removeParentChildEdges__Lorg_eclipse_draw2d_graph_DirectedGraph_2(g);
    this.cycleRemove__Lorg_eclipse_draw2d_graph_NodeList_2(roots);
    this.invertEdges__Lorg_eclipse_draw2d_graph_DirectedGraph_2(g);
    return;
  }
}
}
