package org.eclipse.draw2d.graph {
import java.util.HashSet;
import java.util.Set;
import java.util.Set;
import java.util.HashSet;
import java.lang.Arguments;
dynamic public class CompoundHorizontalPlacement extends HorizontalPlacement {
  internal var entries: Set = new HashSet(new Arguments(java.util.HashSet.HashSet__, []));
  public override function applyGPrime__(): void {
    super.applyGPrime__();
    var subgraphs: NodeList = (CompoundDirectedGraph(graph)).subgraphs;
    for (var i: int = 0; i < subgraphs.size__(); i++) {
      var s: Subgraph = Subgraph(subgraphs.get__I(i));
      s.x = s.left.x;
      s.width = s.right.x + s.right.width - s.x;
    }
    return;
  }
  public override function buildRankSeparators__Lorg_eclipse_draw2d_graph_RankList_2(ranks: RankList): void {
    var g: CompoundDirectedGraph = CompoundDirectedGraph(graph);
    var rank: Rank;
    for (var row: int = 0; row < g.ranks.size__(); row++) {
      rank = g.ranks.getRank__I(row);
      var n: Node = null;
      var prev: Node = null;
      for (var j: int = 0; j < rank.size__(); j++) {
        n = rank.getNode__I(j);
        if (prev === null) {
          var left: Node = this.addSeparatorsLeft__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Subgraph_2(n, null);
          if (left !== null) {
            var e: Edge = new Edge(new Arguments(org.eclipse.draw2d.graph.Edge.Edge__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Node_2II, [graphLeft, this.getPrime__Lorg_eclipse_draw2d_graph_Node_2(left), 0, 0]));
            prime.edges.add__Ljava_lang_Object_2(e);
            e.delta = graph.getPadding__Lorg_eclipse_draw2d_graph_Node_2(n).left + graph.getMargin__().left;
          }
        } else {
          var s: Subgraph = GraphUtilities.getCommonAncestor__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Node_2(prev, n);
          var left_1: Node = this.addSeparatorsRight__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Subgraph_2(prev, s);
          var right: Node = this.addSeparatorsLeft__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Subgraph_2(n, s);
          this.createEdge__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Node_2(left_1, right);
        }
        prev = n;
      }
      if (n !== null)
        this.addSeparatorsRight__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Subgraph_2(n, null);
    }
    return;
  }
  public function createEdge__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Node_2(left: Node, right: Node): void {
    var entry: CompoundHorizontalPlacement$LeftRight = new CompoundHorizontalPlacement$LeftRight(this, left, right);
    if (entries.contains__Ljava_lang_Object_2(entry))
      return;
    entries.add__Ljava_lang_Object_2(entry);
    var separation: int = left.width + graph.getPadding__Lorg_eclipse_draw2d_graph_Node_2(left).right + graph.getPadding__Lorg_eclipse_draw2d_graph_Node_2(right).left;
    prime.edges.add__Ljava_lang_Object_2(new Edge(new Arguments(org.eclipse.draw2d.graph.Edge.Edge__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Node_2II, [this.getPrime__Lorg_eclipse_draw2d_graph_Node_2(left), this.getPrime__Lorg_eclipse_draw2d_graph_Node_2(right), separation, 0])));
  }
  public function addSeparatorsLeft__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Subgraph_2(n: Node, graph_1: Subgraph): Node {
    var parent: Subgraph = n.getParent__();
    while (parent !== graph_1 && parent !== null) {
      this.createEdge__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Node_2(this.getLeft__Lorg_eclipse_draw2d_graph_Subgraph_2(parent), n);
      n = parent.left;
      parent = parent.getParent__();
    }
    return n;
  }
  public function addSeparatorsRight__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Subgraph_2(n: Node, graph_1: Subgraph): Node {
    var parent: Subgraph = n.getParent__();
    while (parent !== graph_1 && parent !== null) {
      this.createEdge__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Node_2(n, this.getRight__Lorg_eclipse_draw2d_graph_Subgraph_2(parent));
      n = parent.right;
      parent = parent.getParent__();
    }
    return n;
  }
  public function getLeft__Lorg_eclipse_draw2d_graph_Subgraph_2(s: Subgraph): Node {
    if (s.left === null) {
      s.left = new SubgraphBoundary(s, graph.getPadding__Lorg_eclipse_draw2d_graph_Node_2(s), 1);
      s.left.rank = int((s.head.rank + s.tail.rank) / 2);
      var head: Node = this.getPrime__Lorg_eclipse_draw2d_graph_Node_2(s.head);
      var tail: Node = this.getPrime__Lorg_eclipse_draw2d_graph_Node_2(s.tail);
      var left: Node = this.getPrime__Lorg_eclipse_draw2d_graph_Node_2(s.left);
      var right: Node = this.getPrime__Lorg_eclipse_draw2d_graph_Node_2(this.getRight__Lorg_eclipse_draw2d_graph_Subgraph_2(s));
      prime.edges.add__Ljava_lang_Object_2(new Edge(new Arguments(org.eclipse.draw2d.graph.Edge.Edge__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Node_2II, [left, right, s.width, 0])));
      prime.edges.add__Ljava_lang_Object_2(new Edge(new Arguments(org.eclipse.draw2d.graph.Edge.Edge__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Node_2II, [left, head, 0, 1])));
      prime.edges.add__Ljava_lang_Object_2(new Edge(new Arguments(org.eclipse.draw2d.graph.Edge.Edge__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Node_2II, [head, right, 0, 1])));
      prime.edges.add__Ljava_lang_Object_2(new Edge(new Arguments(org.eclipse.draw2d.graph.Edge.Edge__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Node_2II, [left, tail, 0, 1])));
      prime.edges.add__Ljava_lang_Object_2(new Edge(new Arguments(org.eclipse.draw2d.graph.Edge.Edge__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Node_2II, [tail, right, 0, 1])));
    }
    return s.left;
  }
  public function getRight__Lorg_eclipse_draw2d_graph_Subgraph_2(s: Subgraph): Node {
    if (s.right === null) {
      s.right = new SubgraphBoundary(s, graph.getPadding__Lorg_eclipse_draw2d_graph_Node_2(s), 3);
      s.right.rank = int((s.head.rank + s.tail.rank) / 2);
    }
    return s.right;
  }
  public function getPrime__Lorg_eclipse_draw2d_graph_Node_2(n: Node): Node {
    var nPrime: Node = this.get__Lorg_eclipse_draw2d_graph_Node_2(n);
    if (nPrime === null) {
      nPrime = new Node(new Arguments(org.eclipse.draw2d.graph.Node.Node__Ljava_lang_Object_2, [n]));
      prime.nodes.add__Ljava_lang_Object_2(nPrime);
      this.map__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Node_2(n, nPrime);
    }
    return nPrime;
  }
  public override function visit__Lorg_eclipse_draw2d_graph_DirectedGraph_2(g: DirectedGraph): void {
    super.visit__Lorg_eclipse_draw2d_graph_DirectedGraph_2(g);
  }
}
}
