package org.eclipse.draw2d.graph {
import java.util.Iterator;
import java.util.Iterator;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class CompoundPopulateRanks extends PopulateRanks {
  public override function visit__Lorg_eclipse_draw2d_graph_DirectedGraph_2(g: DirectedGraph): void {
    var graph: CompoundDirectedGraph = CompoundDirectedGraph(g);
    var containment: Iterator = Iterator(graph.containment.iterator__());
    while (containment.hasNext__()) {
      var e: Edge = Edge(containment.next__());
      if (e.getSlack__() > 0) {
        graph.removeEdge__Lorg_eclipse_draw2d_graph_Edge_2(e);
        containment.remove__();
      }
    }
    super.visit__Lorg_eclipse_draw2d_graph_DirectedGraph_2(g);
    var subgraphs: NodeList = graph.subgraphs;
    for (var i: int = 0; i < subgraphs.size__(); i++) {
      var subgraph: Subgraph = Subgraph(subgraphs.get__I(i));
      this.bridgeSubgraph__Lorg_eclipse_draw2d_graph_Subgraph_2Lorg_eclipse_draw2d_graph_CompoundDirectedGraph_2(subgraph, graph);
    }
    return;
  }
  private function bridgeSubgraph__Lorg_eclipse_draw2d_graph_Subgraph_2Lorg_eclipse_draw2d_graph_CompoundDirectedGraph_2(subgraph: Subgraph, g: CompoundDirectedGraph): void {
    var offset: int = subgraph.head.rank;
    var occupied: JavaArray = new JavaArray("[Z").lengths(subgraph.tail.rank - subgraph.head.rank + 1);
    var bridge: JavaArray = new JavaArray("[Lorg/eclipse/draw2d/graph/Node;").lengths(occupied.length);
    for (var i: int = 0; i < subgraph.members.size__(); i++) {
      var n: Node = Node(subgraph.members.get__I(i));
      if (n is Subgraph) {
        var s: Subgraph = Subgraph(n);
        for (var r: int = s.head.rank; r <= s.tail.rank; r++)
          occupied[r - offset] = true;
      } else
        occupied[n.rank - offset] = true;
    }
    for (var i_1: int = 0; i_1 < bridge.length; i_1++) {
      if (!occupied[i_1]) {
        var br: Node = bridge[i_1] = new Node(new Arguments(org.eclipse.draw2d.graph.Node.Node__Ljava_lang_Object_2Lorg_eclipse_draw2d_graph_Subgraph_2, ["bridge", subgraph]));
        br.rank = i_1 + offset;
        br.height = br.width = 0;
        br.nestingIndex = subgraph.nestingIndex;
        g.ranks.getRank__I(br.rank).add__Lorg_eclipse_draw2d_graph_Node_2(br);
        g.nodes.add__Ljava_lang_Object_2(br);
      }
    }
    return;
  }
}
}
