package org.eclipse.draw2d.graph {
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Map;
import java.util.HashMap;
import java.util.Iterator;
import java.lang.Arguments;
dynamic public class CompoundRankSorter extends RankSorter {
  internal var init: Boolean;
  internal var key: CompoundRankSorter$RowKey = new CompoundRankSorter$RowKey(new Arguments(org.eclipse.draw2d.graph.CompoundRankSorter$RowKey.CompoundRankSorter$RowKey__, []));
  internal var map: Map = new HashMap(new Arguments(java.util.HashMap.HashMap__, []));
  public function addRowEntry__Lorg_eclipse_draw2d_graph_Subgraph_2I(s: Subgraph, row: int): void {
    key.s = s;
    key.rank = row;
    if (!map.containsKey__Ljava_lang_Object_2(key))
      map.put__Ljava_lang_Object_2Ljava_lang_Object_2(new CompoundRankSorter$RowKey(new Arguments(org.eclipse.draw2d.graph.CompoundRankSorter$RowKey.CompoundRankSorter$RowKey__Lorg_eclipse_draw2d_graph_Subgraph_2I, [s, row])), new CompoundRankSorter$RowEntry());
  }
  public override function assignIncomingSortValues__(): void {
    super.assignIncomingSortValues__();
    this.pullTogetherSubgraphs__();
  }
  public override function assignOutgoingSortValues__(): void {
    super.assignOutgoingSortValues__();
    this.pullTogetherSubgraphs__();
  }
  public override function optimize__Lorg_eclipse_draw2d_graph_DirectedGraph_2(g_1: DirectedGraph): void {
    var graph: CompoundDirectedGraph = CompoundDirectedGraph(g_1);
    var containment: Iterator = Iterator(graph.containment.iterator__());
    while (containment.hasNext__())
      graph.removeEdge__Lorg_eclipse_draw2d_graph_Edge_2(Edge(containment.next__()));
    graph.containment.clear__();
    new LocalOptimizer().visit__Lorg_eclipse_draw2d_graph_DirectedGraph_2(graph);
  }
  private function pullTogetherSubgraphs__(): void {
    return;
  }
  public override function evaluateNodeOutgoing__(): Number {
    var result: Number = super.evaluateNodeOutgoing__();
    if (progress > 0.2) {
      var s: Subgraph = node.getParent__();
      var connectivity: Number = this.mergeConnectivity__Lorg_eclipse_draw2d_graph_Subgraph_2IDD(s, node.rank + 1, result, progress);
      result = connectivity;
    }
    return result;
  }
  public override function evaluateNodeIncoming__(): Number {
    var result: Number = super.evaluateNodeIncoming__();
    if (progress > 0.2) {
      var s: Subgraph = node.getParent__();
      var connectivity: Number = this.mergeConnectivity__Lorg_eclipse_draw2d_graph_Subgraph_2IDD(s, node.rank - 1, result, progress);
      result = connectivity;
    }
    return result;
  }
  public function mergeConnectivity__Lorg_eclipse_draw2d_graph_Subgraph_2IDD(s: Subgraph, row: int, result: Number, scaleFactor: Number): Number {
    while (s !== null && this.getRowEntry__Lorg_eclipse_draw2d_graph_Subgraph_2I(s, row) === null)
      s = s.getParent__();
    if (s !== null) {
      var entry: CompoundRankSorter$RowEntry = this.getRowEntry__Lorg_eclipse_draw2d_graph_Subgraph_2I(s, row);
      var connectivity: Number = entry.contribution / entry.count;
      result = connectivity * 0.3 + (0.7) * result;
      s = s.getParent__();
    }
    return result;
  }
  public function getRowEntry__Lorg_eclipse_draw2d_graph_Subgraph_2I(s: Subgraph, row: int): CompoundRankSorter$RowEntry {
    key.s = s;
    key.rank = row;
    return CompoundRankSorter$RowEntry(map.get__Ljava_lang_Object_2(key));
  }
  public function copyConstraints__Lorg_eclipse_draw2d_graph_NestingTree_2(tree: NestingTree): void {
    if (tree.subgraph !== null)
      tree.sortValue = tree.subgraph.rowOrder;
    for (var i: int = 0; i < tree.contents.size__(); i++) {
      var child: Object = tree.contents.get__I(i);
      if (child is Node) {
        var n: Node = Node(child);
        n.sortValue = n.rowOrder;
      } else {
        this.copyConstraints__Lorg_eclipse_draw2d_graph_NestingTree_2(NestingTree(child));
      }
    }
    return;
  }
  public override function init__Lorg_eclipse_draw2d_graph_DirectedGraph_2(g_1: DirectedGraph): void {
    super.init__Lorg_eclipse_draw2d_graph_DirectedGraph_2(g_1);
    init = true;
    for (var row: int = 0; row < g_1.ranks.size__(); row++) {
      var rank_1: Rank = g_1.ranks.getRank__I(row);
      var tree: NestingTree = NestingTree.buildNestingTreeForRank__Lorg_eclipse_draw2d_graph_Rank_2(rank_1);
      this.copyConstraints__Lorg_eclipse_draw2d_graph_NestingTree_2(tree);
      tree.recursiveSort__Z(true);
      rank_1.clear__();
      tree.repopulateRank__Lorg_eclipse_draw2d_graph_Rank_2(rank_1);
      for (var j: int = 0; j < rank_1.count__(); j++) {
        var n: Node = rank_1.getNode__I(j);
        var s: Subgraph = n.getParent__();
        while (s !== null) {
          this.addRowEntry__Lorg_eclipse_draw2d_graph_Subgraph_2I(s, row);
          s = s.getParent__();
        }
      }
    }
    return;
  }
  public override function postSort__(): void {
    super.postSort__();
    if (init)
      this.updateRank__Lorg_eclipse_draw2d_graph_Rank_2(rank);
    return;
  }
  public function updateRank__Lorg_eclipse_draw2d_graph_Rank_2(rank_1: Rank): void {
    for (var j: int = 0; j < rank_1.count__(); j++) {
      var n: Node = rank_1.getNode__I(j);
      var s: Subgraph = n.getParent__();
      while (s !== null) {
        this.getRowEntry__Lorg_eclipse_draw2d_graph_Subgraph_2I(s, currentRow).reset__();
        s = s.getParent__();
      }
    }
    for (var j_1: int = 0; j_1 < rank_1.count__(); j_1++) {
      var n_1: Node = rank_1.getNode__I(j_1);
      var s_1: Subgraph = n_1.getParent__();
      while (s_1 !== null) {
        var entry: CompoundRankSorter$RowEntry = this.getRowEntry__Lorg_eclipse_draw2d_graph_Subgraph_2I(s_1, currentRow);
        entry.count++;
        entry.contribution += n_1.index;
        s_1 = s_1.getParent__();
      }
    }
    return;
  }
}
}
