package org.eclipse.draw2d.graph {
import org.eclipse.draw2d.geometry.Insets;
import java.lang.Arguments;
dynamic public class ConvertCompoundGraph extends GraphVisitor {
  private function addContainmentEdges__Lorg_eclipse_draw2d_graph_CompoundDirectedGraph_2(graph: CompoundDirectedGraph): void {
    for (var i: int = 0; i < graph.nodes.size__(); i++) {
      var node: Node = graph.nodes.getNode__I(i);
      var parent: Subgraph = node.getParent__();
      if (parent === null)
        continue;
      if (node is Subgraph) {
        var sub: Subgraph = Subgraph(node);
        this.connectHead__Lorg_eclipse_draw2d_graph_CompoundDirectedGraph_2Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Subgraph_2(graph, sub.head, parent);
        this.connectTail__Lorg_eclipse_draw2d_graph_CompoundDirectedGraph_2Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Subgraph_2(graph, sub.tail, parent);
      } else {
        this.connectHead__Lorg_eclipse_draw2d_graph_CompoundDirectedGraph_2Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Subgraph_2(graph, node, parent);
        this.connectTail__Lorg_eclipse_draw2d_graph_CompoundDirectedGraph_2Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Subgraph_2(graph, node, parent);
      }
    }
    return;
  }
  public function buildNestingTreeIndices__Lorg_eclipse_draw2d_graph_NodeList_2I(nodes: NodeList, base: int): int {
    for (var i: int = 0; i < nodes.size__(); i++) {
      var node: Node = Node(nodes.get__I(i));
      if (node is Subgraph) {
        var s: Subgraph = Subgraph(node);
        s.nestingTreeMin = base;
        base = this.buildNestingTreeIndices__Lorg_eclipse_draw2d_graph_NodeList_2I(s.members, base);
      }
      node.nestingIndex = base++;
    }
    return base++;
  }
  private function connectHead__Lorg_eclipse_draw2d_graph_CompoundDirectedGraph_2Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Subgraph_2(graph: CompoundDirectedGraph, node: Node, parent: Subgraph): void {
    var connectHead: Boolean = true;
    for (var j: int = 0; connectHead && j < node.incoming.size__(); j++) {
      var ancestor: Node = node.incoming.getEdge__I(j).source;
      if (parent.isNested__Lorg_eclipse_draw2d_graph_Node_2(ancestor))
        connectHead = false;
    }
    if (connectHead) {
      var e: Edge = new Edge(new Arguments(org.eclipse.draw2d.graph.Edge.Edge__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Node_2, [parent.head, node]));
      e.weight = 0;
      graph.edges.add__Ljava_lang_Object_2(e);
      graph.containment.add__Ljava_lang_Object_2(e);
    }
    return;
  }
  private function connectTail__Lorg_eclipse_draw2d_graph_CompoundDirectedGraph_2Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Subgraph_2(graph: CompoundDirectedGraph, node: Node, parent: Subgraph): void {
    var connectTail: Boolean = true;
    for (var j: int = 0; connectTail && j < node.outgoing.size__(); j++) {
      var ancestor: Node = node.outgoing.getEdge__I(j).target;
      if (parent.isNested__Lorg_eclipse_draw2d_graph_Node_2(ancestor))
        connectTail = false;
    }
    if (connectTail) {
      var e: Edge = new Edge(new Arguments(org.eclipse.draw2d.graph.Edge.Edge__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Node_2, [node, parent.tail]));
      e.weight = 0;
      graph.edges.add__Ljava_lang_Object_2(e);
      graph.containment.add__Ljava_lang_Object_2(e);
    }
    return;
  }
  private function convertSubgraphEndpoints__Lorg_eclipse_draw2d_graph_CompoundDirectedGraph_2(graph: CompoundDirectedGraph): void {
    for (var i: int = 0; i < graph.edges.size__(); i++) {
      var edge: Edge = Edge(graph.edges.get__I(i));
      if (edge.source is Subgraph) {
        var s: Subgraph = Subgraph(edge.source);
        var newSource: Node;
        if (s.isNested__Lorg_eclipse_draw2d_graph_Node_2(edge.target))
          newSource = s.head;
        else
          newSource = s.tail;
        edge.source = newSource;
        newSource.outgoing.add__Ljava_lang_Object_2(edge);
      }
      if (edge.target is Subgraph) {
        var s_1: Subgraph = Subgraph(edge.target);
        var newTarget: Node;
        if (s_1.isNested__Lorg_eclipse_draw2d_graph_Node_2(edge.source))
          newTarget = s_1.tail;
        else
          newTarget = s_1.head;
        edge.target = newTarget;
        newTarget.incoming.add__Ljava_lang_Object_2(edge);
      }
    }
    return;
  }
  private function replaceSubgraphsWithBoundaries__Lorg_eclipse_draw2d_graph_CompoundDirectedGraph_2(graph: CompoundDirectedGraph): void {
    for (var i: int = 0; i < graph.subgraphs.size__(); i++) {
      var s: Subgraph = Subgraph(graph.subgraphs.get__I(i));
      graph.nodes.add__Ljava_lang_Object_2(s.head);
      graph.nodes.add__Ljava_lang_Object_2(s.tail);
      graph.nodes.remove__Ljava_lang_Object_2(s);
    }
    return;
  }
  public override function revisit__Lorg_eclipse_draw2d_graph_DirectedGraph_2(g: DirectedGraph): void {
    for (var i: int = 0; i < g.edges.size__(); i++) {
      var e: Edge = g.edges.getEdge__I(i);
      if (e.source is SubgraphBoundary) {
        e.source.outgoing.remove__Ljava_lang_Object_2(e);
        e.source = e.source.getParent__();
      }
      if (e.target is SubgraphBoundary) {
        e.target.incoming.remove__Ljava_lang_Object_2(e);
        e.target = e.target.getParent__();
      }
    }
    return;
  }
  public override function visit__Lorg_eclipse_draw2d_graph_DirectedGraph_2(dg: DirectedGraph): void {
    var graph: CompoundDirectedGraph = CompoundDirectedGraph(dg);
    var roots: NodeList = new NodeList(new Arguments(org.eclipse.draw2d.graph.NodeList.NodeList__, []));
    for (var i: int = 0; i < graph.nodes.size__(); i++) {
      var node: Object = graph.nodes.get__I(i);
      if (node is Subgraph) {
        var s: Subgraph = Subgraph(node);
        var padding: Insets = dg.getPadding__Lorg_eclipse_draw2d_graph_Node_2(s);
        s.head = new SubgraphBoundary(s, padding, 0);
        s.tail = new SubgraphBoundary(s, padding, 2);
        var headToTail: Edge = new Edge(new Arguments(org.eclipse.draw2d.graph.Edge.Edge__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Node_2, [s.head, s.tail]));
        headToTail.weight = 10;
        graph.edges.add__Ljava_lang_Object_2(headToTail);
        graph.containment.add__Ljava_lang_Object_2(headToTail);
        graph.subgraphs.add__Ljava_lang_Object_2(s);
        if (s.getParent__() === null)
          roots.add__Ljava_lang_Object_2(s);
        if (s.members.size__() == 2)
          graph.edges.add__Ljava_lang_Object_2(new Edge(new Arguments(org.eclipse.draw2d.graph.Edge.Edge__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Node_2, [s.head, s.tail])));
      }
    }
    this.buildNestingTreeIndices__Lorg_eclipse_draw2d_graph_NodeList_2I(roots, 0);
    this.convertSubgraphEndpoints__Lorg_eclipse_draw2d_graph_CompoundDirectedGraph_2(graph);
    this.addContainmentEdges__Lorg_eclipse_draw2d_graph_CompoundDirectedGraph_2(graph);
    this.replaceSubgraphsWithBoundaries__Lorg_eclipse_draw2d_graph_CompoundDirectedGraph_2(graph);
    return;
  }
}
}
