package org.eclipse.draw2d.graph {
import org.eclipse.draw2d.PositionConstants;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class DirectedGraph {
  private var direction: int = 4;
  private var defaultPadding: Insets = new Insets(new Arguments(org.eclipse.draw2d.geometry.Insets.Insets__I, [16]));
  public var edges: EdgeList = new EdgeList();
  public var nodes: NodeList = new NodeList(new Arguments(org.eclipse.draw2d.graph.NodeList.NodeList__, []));
  public var ranks: RankList = new RankList();
  internal var forestRoot: Node;
  internal var margin: Insets = new Insets(new Arguments(org.eclipse.draw2d.geometry.Insets.Insets__, []));
  internal var rankLocations: JavaArray;
  internal var cellLocations: JavaArray;
  internal var tensorStrength: int;
  internal var tensorSize: int;
  internal var size: Dimension = new Dimension(new Arguments(org.eclipse.draw2d.geometry.Dimension.Dimension__, []));
  public function getDefaultPadding__(): Insets {
    return defaultPadding;
  }
  public function getDirection__(): int {
    return direction;
  }
  public function getMargin__(): Insets {
    return margin;
  }
  public function getPadding__Lorg_eclipse_draw2d_graph_Node_2(node: Node): Insets {
    var pad: Insets = node.getPadding__();
    if (pad === null)
      return defaultPadding;
    return pad;
  }
  public function getCellLocations__I(rank: int): JavaArray {
    return cellLocations[rank];
  }
  public function getRankLocations__(): JavaArray {
    return rankLocations;
  }
  public function getNode__II(rank: int, index: int): Node {
    if (ranks.size__() <= rank)
      return null;
    var r: Rank = ranks.getRank__I(rank);
    if (r.size__() <= index)
      return null;
    return r.getNode__I(index);
  }
  public function removeEdge__Lorg_eclipse_draw2d_graph_Edge_2(edge: Edge): void {
    edges.remove__Ljava_lang_Object_2(edge);
    edge.source.outgoing.remove__Ljava_lang_Object_2(edge);
    edge.target.incoming.remove__Ljava_lang_Object_2(edge);
    if (edge.vNodes !== null)
      for (var j: int = 0; j < edge.vNodes.size__(); j++)
        this.removeNode__Lorg_eclipse_draw2d_graph_Node_2(edge.vNodes.getNode__I(j));
  }
  public function removeNode__Lorg_eclipse_draw2d_graph_Node_2(node: Node): void {
    nodes.remove__Ljava_lang_Object_2(node);
    if (ranks !== null)
      ranks.getRank__I(node.rank).remove__Ljava_lang_Object_2(node);
  }
  public function setDefaultPadding__Lorg_eclipse_draw2d_geometry_Insets_2(insets: Insets): void {
    defaultPadding = insets;
  }
  public function setDirection__I(direction_1: int): void {
    this.direction = direction_1;
  }
  public function setMargin__Lorg_eclipse_draw2d_geometry_Insets_2(insets: Insets): void {
    this.margin = insets;
  }
  public function getLayoutSize__(): Dimension {
    return size;
  }
}
}
