package org.eclipse.draw2d.graph {
import java.util.ArrayList;
import java.util.List;
import java.util.List;
import java.util.ArrayList;
import java.lang.Arguments;
dynamic public class DirectedGraphLayout {
  internal var steps: List = new ArrayList(new Arguments(java.util.ArrayList.ArrayList__, []));
  public function DirectedGraphLayout() {
    this.init__();
    return;
  }
  public function init__(): void {
    steps.add__Ljava_lang_Object_2(new TransposeMetrics());
    steps.add__Ljava_lang_Object_2(new BreakCycles());
    steps.add__Ljava_lang_Object_2(new RouteEdges());
    steps.add__Ljava_lang_Object_2(new InitialRankSolver());
    steps.add__Ljava_lang_Object_2(new TightSpanningTreeSolver());
    steps.add__Ljava_lang_Object_2(new RankAssignmentSolver());
    steps.add__Ljava_lang_Object_2(new PopulateRanks());
    steps.add__Ljava_lang_Object_2(new VerticalPlacement());
    steps.add__Ljava_lang_Object_2(new MinCross(new Arguments(org.eclipse.draw2d.graph.MinCross.MinCross__, [])));
    steps.add__Ljava_lang_Object_2(new LocalOptimizer());
    steps.add__Ljava_lang_Object_2(new HorizontalPlacement());
    return;
  }
  public function visit__Lorg_eclipse_draw2d_graph_DirectedGraph_2(graph: DirectedGraph): void {
    if (graph.nodes.isEmpty__())
      return;
    for (var i: int = 0; i < steps.size__(); i++) {
      var visitor: GraphVisitor = GraphVisitor(steps.get__I(i));
      visitor.visit__Lorg_eclipse_draw2d_graph_DirectedGraph_2(graph);
    }
    for (var i_1: int = steps.size__() - 1; i_1 >= 0; i_1--) {
      var visitor_1: GraphVisitor = GraphVisitor(steps.get__I(i_1));
      visitor_1.revisit__Lorg_eclipse_draw2d_graph_DirectedGraph_2(graph);
    }
    return;
  }
}
}
