package org.eclipse.draw2d.graph {
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import java.lang.Arguments;
dynamic public class Edge {
  internal var cut: int;
  public var data: Object;
  public var delta: int = 1;
  public var end: Point;
  internal var flag: Boolean;
  public var isFeedback: Boolean = false;
  public var offsetSource: int = -1;
  public var offsetTarget: int = -1;
  public var padding: int = 10;
  private var points: PointList;
  public var source: Node;
  public var start: Point;
  public var target: Node;
  internal var tree: Boolean;
  public var vNodes: NodeList;
  public var weight: int = 1;
  public var width: int = 1;
  public function Edge__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Node_2(source: Node, target: Node): Object {
    return this;
  }
  public function Edge__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Node_2II(source: Node, target: Node, delta: int, weight: int): Object {
    this.delta = delta;
    this.weight = weight;
    return this;
  }
  public function Edge__Ljava_lang_Object_2Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Node_2(data: Object, source: Node, target: Node): Object {
    this.data = data;
    this.source = source;
    this.target = target;
    source.outgoing.add__Ljava_lang_Object_2(this);
    target.incoming.add__Ljava_lang_Object_2(this);
    return this;
  }
  public function getDelta__(): int {
    return delta;
  }
  public function getIndexForRank__I(rank: int): int {
    if (source.rank == rank)
      return source.index;
    if (target.rank == rank)
      return target.index;
    if (vNodes !== null)
      return vNodes.getNode__I(rank - source.rank - 1).index;
    return -1;
  }
  public function getLength__(): int {
    return (target.rank - source.rank);
  }
  public function getPadding__(): int {
    return padding;
  }
  public function getPoints__(): PointList {
    return points;
  }
  public function getSlack__(): int {
    return (target.rank - source.rank) - delta;
  }
  public function getSourceOffset__(): int {
    if (offsetSource != -1)
      return offsetSource;
    return source.getOffsetOutgoing__();
  }
  public function getTargetOffset__(): int {
    if (offsetTarget != -1)
      return offsetTarget;
    return target.getOffsetIncoming__();
  }
  public function getWidth__(): int {
    return width;
  }
  public function invert__(): void {
    source.outgoing.remove__Ljava_lang_Object_2(this);
    target.incoming.remove__Ljava_lang_Object_2(this);
    var oldTarget: Node = target;
    target = source;
    source = oldTarget;
    var temp: int = offsetSource;
    offsetSource = offsetTarget;
    offsetTarget = temp;
    target.incoming.add__Ljava_lang_Object_2(this);
    source.outgoing.add__Ljava_lang_Object_2(this);
    if (points !== null)
      points.reverse__();
    if (vNodes !== null) {
      var newVNodes: NodeList = new NodeList(new Arguments(org.eclipse.draw2d.graph.NodeList.NodeList__, []));
      for (var j: int = vNodes.size__() - 1; j >= 0; j--) {
        newVNodes.add__Ljava_lang_Object_2(vNodes.getNode__I(j));
      }
      vNodes = newVNodes;
    }
    if (start !== null) {
      var pt: Point = start;
      start = end;
      end = pt;
    }
    return;
  }
  public function isFeedback__(): Boolean {
    return isFeedback;
  }
  public function opposite__Lorg_eclipse_draw2d_graph_Node_2(end_1: Node): Node {
    if (source === end_1)
      return target;
    return source;
  }
  public function setDelta__I(delta_1: int): void {
    this.delta = delta_1;
  }
  public function setPadding__I(padding_1: int): void {
    this.padding = padding_1;
  }
  public function setPoints__Lorg_eclipse_draw2d_geometry_PointList_2(points_1: PointList): void {
    this.points = points_1;
    start = points_1.getFirstPoint__();
    end = points_1.getLastPoint__();
  }
  public function setSource__Lorg_eclipse_draw2d_graph_Node_2(node: Node): void {
    if (source === node)
      return;
    if (source !== null)
      source.outgoing.remove__Ljava_lang_Object_2(this);
    source = node;
    if (source !== null)
      source.outgoing.add__Ljava_lang_Object_2(this);
  }
  public function setSourceOffset__I(offset: int): void {
    this.offsetSource = offset;
  }
  public function setTarget__Lorg_eclipse_draw2d_graph_Node_2(node: Node): void {
    if (target === node)
      return;
    if (target !== null)
      target.incoming.remove__Ljava_lang_Object_2(this);
    target = node;
    if (target !== null)
      target.incoming.add__Ljava_lang_Object_2(this);
  }
  public function setTargetOffset__I(offset: int): void {
    this.offsetTarget = offset;
  }
  public function setWidth__I(width_1: int): void {
    this.width = width_1;
  }
  public function Edge(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 2 && vargs[0] is Node && vargs[1] is Node) {
        args = vargs;
        id = 0;
      } else if (vargs.length == 4 && vargs[0] is Node && vargs[1] is Node && vargs[2] is int && vargs[3] is int) {
        args = vargs;
        id = 1;
      } else if (vargs.length == 3 && vargs[0] is Object && vargs[1] is Node && vargs[2] is Node) {
        args = vargs;
        id = 2;
      }
    }
    switch (id) {
      case 0:
        var args0: Array = [args[0], args[1]];
        args2 = [null, args0[0], args0[1]];
        break;
      case 1:
        var args1: Array = [args[0], args[1], args[2], args[3]];
        args0 = [args1[0], args1[1]];
        args2 = [null, args0[0], args0[1]];
        break;
      case 2:
        var args2: Array = [args[0], args[1], args[2]];
        break;
    }
    super();
    switch (id) {
      case 0:
        Edge__Ljava_lang_Object_2Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Node_2(args2[0], args2[1], args2[2]);
        Edge__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Node_2(args0[0], args0[1]);
        break;
      case 1:
        Edge__Ljava_lang_Object_2Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Node_2(args2[0], args2[1], args2[2]);
        Edge__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Node_2(args0[0], args0[1]);
        Edge__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Node_2II(args1[0], args1[1], args1[2], args1[3]);
        break;
      case 2:
        Edge__Ljava_lang_Object_2Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Node_2(args2[0], args2[1], args2[2]);
        break;
    }
  }
  public static const Edge__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Node_2 : int = 0;
  public static const Edge__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Node_2II : int = 1;
  public static const Edge__Ljava_lang_Object_2Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Node_2 : int = 2;
}
}
