package org.eclipse.draw2d.graph {
import java.util.ArrayList;
import java.util.ArrayList;
import java.lang.Integer;
import java.lang.Math__;
import java.lang.Arguments;
dynamic public class EdgeList extends ArrayList {
  public function getEdge__I(index: int): Edge {
    return Edge(super.get__I(index));
  }
  public function getSourceIndex__I(i: int): int {
    return this.getEdge__I(i).source.index;
  }
  public function getTargetIndex__I(i: int): int {
    return this.getEdge__I(i).target.index;
  }
  public function getSlack__(): int {
    var slack: int = 2147483647;
    for (var i: int = 0; i < this.size__(); i++)
      slack = Math__.min__II(slack, this.getEdge__I(i).getSlack__());
    return slack;
  }
  public function getWeight__(): int {
    var w: int = 0;
    for (var i: int = 0; i < this.size__(); i++)
      w += this.getEdge__I(i).weight;
    return w;
  }
  public function isCompletelyFlagged__(): Boolean {
    for (var i: int = 0; i < this.size__(); i++) {
      if (!this.getEdge__I(i).flag)
        return false;
    }
    return true;
  }
  public function resetFlags__Z(resetTree: Boolean): void {
    for (var i: int = 0; i < this.size__(); i++) {
      this.getEdge__I(i).flag = false;
      if (resetTree)
        this.getEdge__I(i).tree = false;
    }
    return;
  }
  public function setFlags__Z(value: Boolean): void {
    for (var i: int = 0; i < this.size__(); i++)
      this.getEdge__I(i).flag = value;
    return;
  }
}
}
