package org.eclipse.draw2d.graph {
import java.lang.Arguments;
dynamic public class GraphUtilities {
  public static function getCommonAncestor__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Node_2(left: Node, right: Node): Subgraph {
    var parent: Subgraph;
    if (right is Subgraph)
      parent = Subgraph(right);
    else
      parent = right.getParent__();
    while (parent !== null) {
      if (parent.isNested__Lorg_eclipse_draw2d_graph_Node_2(left))
        return parent;
      parent = parent.getParent__();
    }
    return null;
  }
  public static function isCyclic__Lorg_eclipse_draw2d_graph_DirectedGraph_2(graph: DirectedGraph): Boolean {
    return isCyclic__Lorg_eclipse_draw2d_graph_NodeList_2(new NodeList(new Arguments(org.eclipse.draw2d.graph.NodeList.NodeList__Lorg_eclipse_draw2d_graph_NodeList_2, [graph.nodes])));
  }
  public static function isCyclic__Lorg_eclipse_draw2d_graph_NodeList_2(nodes: NodeList): Boolean {
    if (nodes.isEmpty__())
      return false;
    var size: int = nodes.size__();
    for (var i: int = 0; i < nodes.size__(); i++) {
      var node: Node = nodes.getNode__I(i);
      if (node.outgoing === null || node.outgoing.isEmpty__()) {
        nodes.remove__Ljava_lang_Object_2(node);
        for (var j: int = 0; j < node.incoming.size__(); j++) {
          var e: Edge = node.incoming.getEdge__I(j);
          e.source.outgoing.remove__Ljava_lang_Object_2(e);
        }
      }
    }
    if (nodes.size__() == size)
      return true;
    return isCyclic__Lorg_eclipse_draw2d_graph_NodeList_2(nodes);
  }
  public static function numberOfCrossingsInGraph__Lorg_eclipse_draw2d_graph_DirectedGraph_2(graph: DirectedGraph): int {
    var crossings: int = 0;
    for (var i: int = 0; i < graph.ranks.size__(); i++) {
      var rank: Rank = graph.ranks.getRank__I(i);
      crossings += numberOfCrossingsInRank__Lorg_eclipse_draw2d_graph_Rank_2(rank);
    }
    return crossings;
  }
  public static function numberOfCrossingsInRank__Lorg_eclipse_draw2d_graph_Rank_2(rank: Rank): int {
    var crossings: int = 0;
    for (var i: int = 0; i < rank.size__() - 1; i++) {
      var currentNode: Node = rank.getNode__I(i);
      var nextNode: Node;
      for (var j: int = i + 1; j < rank.size__(); j++) {
        nextNode = rank.getNode__I(j);
        var currentOutgoing: EdgeList = currentNode.outgoing;
        var nextOutgoing: EdgeList = nextNode.outgoing;
        for (var k: int = 0; k < currentOutgoing.size__(); k++) {
          var currentEdge: Edge = currentOutgoing.getEdge__I(k);
          for (var l: int = 0; l < nextOutgoing.size__(); l++) {
            if (nextOutgoing.getEdge__I(l).getIndexForRank__I(currentNode.rank + 1) < currentEdge.getIndexForRank__I(currentNode.rank + 1))
              crossings++;
          }
        }
      }
    }
    return crossings;
  }
  private static function search__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_NodeList_2(node: Node, list: NodeList): NodeList {
    if (node.flag)
      return list;
    node.flag = true;
    list.add__Ljava_lang_Object_2(node);
    for (var i: int = 0; i < node.outgoing.size__(); i++)
      search__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_NodeList_2(node.outgoing.getEdge__I(i).target, list);
    return list;
  }
  public static function willCauseCycle__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Node_2(source: Node, target: Node): Boolean {
    var nodes: NodeList = search__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_NodeList_2(target, new NodeList(new Arguments(org.eclipse.draw2d.graph.NodeList.NodeList__, [])));
    nodes.resetFlags__();
    return nodes.contains__Ljava_lang_Object_2(source);
  }
  public static function isConstrained__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Node_2(left: Node, right: Node): Boolean {
    var common: Subgraph = left.getParent__();
    while (common !== null && !common.isNested__Lorg_eclipse_draw2d_graph_Node_2(right)) {
      left = left.getParent__();
      common = left.getParent__();
    }
    while (right.getParent__() !== common)
      right = right.getParent__();
    return (left.rowOrder != -1 && right.rowOrder != -1) && left.rowOrder != right.rowOrder;
  }
}
}
