package org.eclipse.draw2d.graph {
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.lang.Integer;
import java.util.List;
import java.util.ArrayList;
import java.lang.Math__;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class HorizontalPlacement extends SpanningTreeVisitor {
  public static var step: int;
  private var allClusters: List;
  private var clusterMap: Map = new HashMap(new Arguments(java.util.HashMap.HashMap__, []));
  internal var clusterset: HorizontalPlacement$ClusterSet = new HorizontalPlacement$ClusterSet(HorizontalPlacement(this));
  internal var dirtyClusters: Collection = new HashSet(new Arguments(java.util.HashSet.HashSet__, []));
  internal var graph: DirectedGraph;
  internal var map: Map = new HashMap(new Arguments(java.util.HashMap.HashMap__, []));
  internal var prime: DirectedGraph;
  internal var graphRight: Node;
  internal var graphLeft: Node;
  public function addEdge__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Edge_2I(u: Node, v: Node, e: Edge, weight: int): void {
    var ne: Node = new Node(new Arguments(org.eclipse.draw2d.graph.Node.Node__Ljava_lang_Object_2, [new NodePair(new Arguments(org.eclipse.draw2d.graph.NodePair.NodePair__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Node_2, [u, v]))]));
    prime.nodes.add__Ljava_lang_Object_2(ne);
    ne.y = int((u.y + u.height + v.y) / 2);
    var uPrime: Node = this.get__Lorg_eclipse_draw2d_graph_Node_2(u);
    var vPrime: Node = this.get__Lorg_eclipse_draw2d_graph_Node_2(v);
    var uOffset: int = e.getSourceOffset__();
    var vOffset: int = e.getTargetOffset__();
    var eu: Edge = new Edge(new Arguments(org.eclipse.draw2d.graph.Edge.Edge__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Node_2II, [ne, uPrime, 0, e.weight * weight]));
    var ev: Edge = new Edge(new Arguments(org.eclipse.draw2d.graph.Edge.Edge__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Node_2II, [ne, vPrime, 0, e.weight * weight]));
    var dw: int = uOffset - vOffset;
    if (dw < 0)
      eu.delta = -dw;
    else
      ev.delta = dw;
    prime.edges.add__Ljava_lang_Object_2(eu);
    prime.edges.add__Ljava_lang_Object_2(ev);
  }
  public function addEdges__Lorg_eclipse_draw2d_graph_Node_2(n: Node): void {
    for (var i: int = 0; i < n.incoming.size__(); i++) {
      var e: Edge = n.incoming.getEdge__I(i);
      this.addEdge__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Edge_2I(e.source, n, e, 1);
    }
    return;
  }
  public function applyGPrime__(): void {
    var node: Node;
    for (var n: int = 0; n < prime.nodes.size__(); n++) {
      node = prime.nodes.getNode__I(n);
      if (node.data is Node)
        (Node(node.data)).x = node.rank;
    }
    return;
  }
  private function balanceClusters__(): void {
    this.findAllClusters__();
    step = 0;
    var somethingMoved: Boolean = false;
    for (var i: int = 0; i < allClusters.size__();) {
      var c: NodeCluster = NodeCluster(allClusters.get__I(i));
      var delta: int = c.getPull__();
      if (delta < 0) {
        if (c.leftFreedom > 0) {
          c.adjustRank__ILjava_util_Collection_2(Math__.max__II(delta, -c.leftFreedom), dirtyClusters);
          this.refreshDirtyClusters__();
          this.moveClusterForward__ILorg_eclipse_draw2d_graph_NodeCluster_2(i, c);
          somethingMoved = true;
          step++;
        } else if (clusterset.build__Lorg_eclipse_draw2d_graph_NodeCluster_2(c)) {
          step++;
          this.moveClusterForward__ILorg_eclipse_draw2d_graph_NodeCluster_2(i, c);
          somethingMoved = true;
        }
      } else if (delta > 0) {
        if (c.rightFreedom > 0) {
          c.adjustRank__ILjava_util_Collection_2(Math__.min__II(delta, c.rightFreedom), dirtyClusters);
          this.refreshDirtyClusters__();
          this.moveClusterForward__ILorg_eclipse_draw2d_graph_NodeCluster_2(i, c);
          somethingMoved = true;
          step++;
        } else if (clusterset.build__Lorg_eclipse_draw2d_graph_NodeCluster_2(c)) {
          step++;
          this.moveClusterForward__ILorg_eclipse_draw2d_graph_NodeCluster_2(i, c);
          somethingMoved = true;
        }
      }
      i++;
      if (i == allClusters.size__() && somethingMoved) {
        i = 0;
        somethingMoved = false;
      }
    }
    return;
  }
  public function buildGPrime__(): void {
    var ranks: RankList = graph.ranks;
    this.buildRankSeparators__Lorg_eclipse_draw2d_graph_RankList_2(ranks);
    var rank: Rank;
    var n: Node;
    for (var r: int = 1; r < ranks.size__(); r++) {
      rank = ranks.getRank__I(r);
      for (var i: int = 0; i < rank.count__(); i++) {
        n = rank.getNode__I(i);
        this.addEdges__Lorg_eclipse_draw2d_graph_Node_2(n);
      }
    }
    return;
  }
  public function buildRankSeparators__Lorg_eclipse_draw2d_graph_RankList_2(ranks: RankList): void {
    var rank: Rank;
    var n: Node;
    var nPrime: Node;
    var prevNPrime: Node;
    var e: Edge;
    for (var r: int = 0; r < ranks.size__(); r++) {
      rank = ranks.getRank__I(r);
      prevNPrime = null;
      for (var i: int = 0; i < rank.count__(); i++) {
        n = rank.getNode__I(i);
        nPrime = new Node(new Arguments(org.eclipse.draw2d.graph.Node.Node__Ljava_lang_Object_2, [n]));
        if (i == 0) {
          e = new Edge(new Arguments(org.eclipse.draw2d.graph.Edge.Edge__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Node_2II, [graphLeft, nPrime, 0, 0]));
          prime.edges.add__Ljava_lang_Object_2(e);
          e.delta = graph.getPadding__Lorg_eclipse_draw2d_graph_Node_2(n).left + graph.getMargin__().left;
        } else {
          e = new Edge(new Arguments(org.eclipse.draw2d.graph.Edge.Edge__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Node_2, [prevNPrime, nPrime]));
          e.weight = 0;
          prime.edges.add__Ljava_lang_Object_2(e);
          this.rowSeparation__Lorg_eclipse_draw2d_graph_Edge_2(e);
        }
        prevNPrime = nPrime;
        prime.nodes.add__Ljava_lang_Object_2(nPrime);
        this.map__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Node_2(n, nPrime);
        if (i == rank.count__() - 1) {
          e = new Edge(new Arguments(org.eclipse.draw2d.graph.Edge.Edge__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Node_2II, [nPrime, graphRight, 0, 0]));
          e.delta = n.width + graph.getPadding__Lorg_eclipse_draw2d_graph_Node_2(n).right + graph.getMargin__().right;
          prime.edges.add__Ljava_lang_Object_2(e);
        }
      }
    }
    return;
  }
  private function calculateCellLocations__(): void {
    graph.cellLocations = new JavaArray("[[I").lengths(graph.ranks.size__() + 1);
    for (var row: int = 0; row < graph.ranks.size__(); row++) {
      var rank: Rank = graph.ranks.getRank__I(row);
      var locations: JavaArray = graph.cellLocations[row] = new JavaArray("[I").lengths(rank.size__() + 1);
      var cell: int;
      var node: Node = null;
      for (cell = 0; cell < rank.size__(); cell++) {
        node = rank.getNode__I(cell);
        locations[cell] = node.x - graph.getPadding__Lorg_eclipse_draw2d_graph_Node_2(node).left;
      }
      locations[cell] = node.x + node.width + graph.getPadding__Lorg_eclipse_draw2d_graph_Node_2(node).right;
    }
    return;
  }
  private function findAllClusters__(): void {
    var root: Node = prime.nodes.getNode__I(0);
    var cluster: NodeCluster = new NodeCluster();
    allClusters = new ArrayList(new Arguments(java.util.ArrayList.ArrayList__, []));
    allClusters.add__Ljava_lang_Object_2(cluster);
    this.growCluster__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_NodeCluster_2(root, cluster);
    for (var i: int = 0; i < prime.edges.size__(); i++) {
      var e: Edge = prime.edges.getEdge__I(i);
      var sourceCluster: NodeCluster = NodeCluster(clusterMap.get__Ljava_lang_Object_2(e.source));
      var targetCluster: NodeCluster = NodeCluster(clusterMap.get__Ljava_lang_Object_2(e.target));
      if (targetCluster === sourceCluster)
        continue;
      var link: CollapsedEdges = sourceCluster.getRightNeighbor__Lorg_eclipse_draw2d_graph_NodeCluster_2(targetCluster);
      if (link === null) {
        link = new CollapsedEdges(e);
        sourceCluster.addRightNeighbor__Lorg_eclipse_draw2d_graph_NodeCluster_2Lorg_eclipse_draw2d_graph_CollapsedEdges_2(targetCluster, link);
        targetCluster.addLeftNeighbor__Lorg_eclipse_draw2d_graph_NodeCluster_2Lorg_eclipse_draw2d_graph_CollapsedEdges_2(sourceCluster, link);
      } else {
        prime.removeEdge__Lorg_eclipse_draw2d_graph_Edge_2(link.processEdge__Lorg_eclipse_draw2d_graph_Edge_2(e));
        i--;
      }
    }
    for (var i_1: int = 0; i_1 < allClusters.size__(); i_1++)
      (NodeCluster(allClusters.get__I(i_1))).initValues__();
    return;
  }
  public function get__Lorg_eclipse_draw2d_graph_Node_2(key: Node): Node {
    return Node(map.get__Ljava_lang_Object_2(key));
  }
  public function growCluster__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_NodeCluster_2(root: Node, cluster: NodeCluster): void {
    cluster.add__Ljava_lang_Object_2(root);
    clusterMap.put__Ljava_lang_Object_2Ljava_lang_Object_2(root, cluster);
    var treeChildren: EdgeList = this.getSpanningTreeChildren__Lorg_eclipse_draw2d_graph_Node_2(root);
    for (var i: int = 0; i < treeChildren.size__(); i++) {
      var e: Edge = treeChildren.getEdge__I(i);
      if (e.cut != 0)
        this.growCluster__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_NodeCluster_2(this.getTreeTail__Lorg_eclipse_draw2d_graph_Edge_2(e), cluster);
      else {
        var newCluster: NodeCluster = new NodeCluster();
        allClusters.add__Ljava_lang_Object_2(newCluster);
        this.growCluster__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_NodeCluster_2(this.getTreeTail__Lorg_eclipse_draw2d_graph_Edge_2(e), newCluster);
      }
    }
    return;
  }
  public function map__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Node_2(key: Node, value: Node): void {
    map.put__Ljava_lang_Object_2Ljava_lang_Object_2(key, value);
    return;
  }
  private function moveClusterForward__ILorg_eclipse_draw2d_graph_NodeCluster_2(i: int, c: NodeCluster): void {
    if (i == 0)
      return;
    var swapIndex: int = int(i / 2);
    var temp: Object = allClusters.get__I(swapIndex);
    allClusters.set__ILjava_lang_Object_2(swapIndex, c);
    allClusters.set__ILjava_lang_Object_2(i, temp);
  }
  public function refreshDirtyClusters__(): void {
    for (var iter: Iterator = Iterator(dirtyClusters.iterator__()); iter.hasNext__();)
      (NodeCluster(iter.next__())).refreshValues__();
    dirtyClusters.clear__();
  }
  public function rowSeparation__Lorg_eclipse_draw2d_graph_Edge_2(e: Edge): void {
    var source: Node = Node(e.source.data);
    var target: Node = Node(e.target.data);
    e.delta = source.width + graph.getPadding__Lorg_eclipse_draw2d_graph_Node_2(source).right + graph.getPadding__Lorg_eclipse_draw2d_graph_Node_2(target).left;
  }
  public override function visit__Lorg_eclipse_draw2d_graph_DirectedGraph_2(g: DirectedGraph): void {
    graph = g;
    prime = new DirectedGraph();
    prime.nodes.add__Ljava_lang_Object_2(graphLeft = new Node(new Arguments(org.eclipse.draw2d.graph.Node.Node__Lorg_eclipse_draw2d_graph_Subgraph_2, [null])));
    prime.nodes.add__Ljava_lang_Object_2(graphRight = new Node(new Arguments(org.eclipse.draw2d.graph.Node.Node__Lorg_eclipse_draw2d_graph_Subgraph_2, [null])));
    if (g.tensorStrength != 0)
      prime.edges.add__Ljava_lang_Object_2(new Edge(new Arguments(org.eclipse.draw2d.graph.Edge.Edge__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Node_2II, [graphLeft, graphRight, g.tensorSize, g.tensorStrength])));
    this.buildGPrime__();
    new InitialRankSolver().visit__Lorg_eclipse_draw2d_graph_DirectedGraph_2(prime);
    new TightSpanningTreeSolver().visit__Lorg_eclipse_draw2d_graph_DirectedGraph_2(prime);
    var solver: RankAssignmentSolver = new RankAssignmentSolver();
    solver.visit__Lorg_eclipse_draw2d_graph_DirectedGraph_2(prime);
    graph.size.width = graphRight.rank;
    this.balanceClusters__();
    prime.nodes.adjustRank__I(-graphLeft.rank);
    this.applyGPrime__();
    this.calculateCellLocations__();
  }
}
}
