package org.eclipse.draw2d.graph {
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.lang.RuntimeException;
import java.util.List;
import java.util.ArrayList;
import java.util.Stack;
import java.lang.Math__;
import java.lang.Arguments;
dynamic public class InitialRankSolver extends GraphVisitor {
  public var graph: DirectedGraph;
  public var candidates: EdgeList = new EdgeList();
  public var members: NodeList = new NodeList(new Arguments(org.eclipse.draw2d.graph.NodeList.NodeList__, []));
  public override function visit__Lorg_eclipse_draw2d_graph_DirectedGraph_2(graph_1: DirectedGraph): void {
    this.graph = graph_1;
    graph_1.edges.resetFlags__Z(false);
    graph_1.nodes.resetFlags__();
    this.solve__();
    return;
  }
  public function solve__(): void {
    if (graph.nodes.size__() == 0)
      return;
    var unranked: NodeList = new NodeList(new Arguments(org.eclipse.draw2d.graph.NodeList.NodeList__Lorg_eclipse_draw2d_graph_NodeList_2, [graph.nodes]));
    var rankMe: NodeList = new NodeList(new Arguments(org.eclipse.draw2d.graph.NodeList.NodeList__, []));
    var node: Node;
    var i: int;
    while (!unranked.isEmpty__()) {
      rankMe.clear__();
      for (i = 0; i < unranked.size__();) {
        node = unranked.getNode__I(i);
        if (node.incoming.isCompletelyFlagged__()) {
          rankMe.add__Ljava_lang_Object_2(node);
          unranked.remove__I(i);
        } else
          i++;
      }
      if (rankMe.size__() == 0)
        throw new RuntimeException(new Arguments(java.lang.RuntimeException.RuntimeException__Ljava_lang_String_2, ["Cycle detected in graph"]));
      for (i = 0; i < rankMe.size__(); i++) {
        node = rankMe.getNode__I(i);
        this.assignMinimumRank__Lorg_eclipse_draw2d_graph_Node_2(node);
        node.outgoing.setFlags__Z(true);
      }
    }
    this.connectForest__();
    return;
  }
  private function connectForest__(): void {
    var forest: List = new ArrayList(new Arguments(java.util.ArrayList.ArrayList__, []));
    var stack: Stack = new Stack();
    var tree: NodeList;
    graph.nodes.resetFlags__();
    for (var i: int = 0; i < graph.nodes.size__(); i++) {
      var neighbor: Node;
      var n: Node = graph.nodes.getNode__I(i);
      if (n.flag)
        continue;
      tree = new NodeList(new Arguments(org.eclipse.draw2d.graph.NodeList.NodeList__, []));
      stack.push__Ljava_lang_Object_2(n);
      while (!stack.isEmpty__()) {
        n = Node(stack.pop__());
        n.flag = true;
        tree.add__Ljava_lang_Object_2(n);
        for (var s: int = 0; s < n.incoming.size__(); s++) {
          neighbor = n.incoming.getEdge__I(s).source;
          if (!neighbor.flag)
            stack.push__Ljava_lang_Object_2(neighbor);
        }
        for (var s_1: int = 0; s_1 < n.outgoing.size__(); s_1++) {
          neighbor = n.outgoing.getEdge__I(s_1).target;
          if (!neighbor.flag)
            stack.push__Ljava_lang_Object_2(neighbor);
        }
      }
      forest.add__Ljava_lang_Object_2(tree);
    }
    if (forest.size__() > 1) {
      graph.forestRoot = new Node(new Arguments(org.eclipse.draw2d.graph.Node.Node__Ljava_lang_Object_2, ["the forest root"]));
      graph.nodes.add__Ljava_lang_Object_2(graph.forestRoot);
      for (var i_1: int = 0; i_1 < forest.size__(); i_1++) {
        tree = NodeList(forest.get__I(i_1));
        graph.edges.add__Ljava_lang_Object_2(new Edge(new Arguments(org.eclipse.draw2d.graph.Edge.Edge__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Node_2II, [graph.forestRoot, tree.getNode__I(0), 0, 0])));
      }
    }
    return;
  }
  private function assignMinimumRank__Lorg_eclipse_draw2d_graph_Node_2(node: Node): void {
    var rank: int = 0;
    var e: Edge;
    for (var i1: int = 0; i1 < node.incoming.size__(); i1++) {
      e = node.incoming.getEdge__I(i1);
      rank = Math__.max__II(rank, e.delta + e.source.rank);
    }
    node.rank = rank;
    return;
  }
}
}
