package org.eclipse.draw2d.graph {
import java.lang.Math__;
dynamic public class LocalOptimizer extends GraphVisitor {
  public function shouldSwap__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Node_2(current: Node, next: Node): Boolean {
    if (GraphUtilities.isConstrained__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Node_2(current, next))
      return false;
    var crossCount: int = 0;
    var invertedCrossCount: int = 0;
    var currentEdges: EdgeList = current.incoming;
    var nextEdges: EdgeList = next.incoming;
    var rank: int = current.rank - 1;
    var iCurrent: int;
    var iNext: int;
    for (var i: int = 0; i < currentEdges.size__(); i++) {
      var currentEdge: Edge = currentEdges.getEdge__I(i);
      iCurrent = currentEdge.getIndexForRank__I(rank);
      for (var j: int = 0; j < nextEdges.size__(); j++) {
        iNext = nextEdges.getEdge__I(j).getIndexForRank__I(rank);
        if (iNext < iCurrent)
          crossCount++;
        else if (iNext > iCurrent)
          invertedCrossCount++;
        else {
          var offsetDiff: int = nextEdges.getEdge__I(j).getSourceOffset__() - currentEdge.getSourceOffset__();
          if (offsetDiff < 0)
            crossCount++;
          else if (offsetDiff > 0)
            invertedCrossCount++;
        }
      }
    }
    currentEdges = current.outgoing;
    nextEdges = next.outgoing;
    rank = current.rank + 1;
    for (var i_1: int = 0; i_1 < currentEdges.size__(); i_1++) {
      var currentEdge_1: Edge = currentEdges.getEdge__I(i_1);
      iCurrent = currentEdge_1.getIndexForRank__I(rank);
      for (var j_1: int = 0; j_1 < nextEdges.size__(); j_1++) {
        iNext = nextEdges.getEdge__I(j_1).getIndexForRank__I(rank);
        if (iNext < iCurrent)
          crossCount++;
        else if (iNext > iCurrent)
          invertedCrossCount++;
        else {
          var offsetDiff_1: int = nextEdges.getEdge__I(j_1).getTargetOffset__() - currentEdge_1.getTargetOffset__();
          if (offsetDiff_1 < 0)
            crossCount++;
          else if (offsetDiff_1 > 0)
            invertedCrossCount++;
        }
      }
    }
    if (invertedCrossCount < crossCount)
      return true;
    return false;
  }
  private function swapNodes__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Rank_2(current: Node, next: Node, rank: Rank): void {
    var index: int = rank.indexOf__Ljava_lang_Object_2(current);
    rank.set__ILjava_lang_Object_2(index + 1, current);
    rank.set__ILjava_lang_Object_2(index, next);
    index = current.index;
    current.index = next.index;
    next.index = index;
  }
  public override function visit__Lorg_eclipse_draw2d_graph_DirectedGraph_2(g: DirectedGraph): void {
    var flag: Boolean;
    do {
      flag = false;
      for (var r: int = 0; r < g.ranks.size__(); r++) {
        var rank: Rank = g.ranks.getRank__I(r);
        for (var n: int = 0; n < rank.count__() - 1; n++) {
          var currentNode: Node = rank.getNode__I(n);
          var nextNode: Node = rank.getNode__I(n + 1);
          if (this.shouldSwap__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Node_2(currentNode, nextNode)) {
            this.swapNodes__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Rank_2(currentNode, nextNode, rank);
            flag = true;
            n = Math__.max__II(0, n - 2);
          }
        }
      }
    } while (flag);
    return;
  }
}
}
