package org.eclipse.draw2d.graph {
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.lang.Arguments;
import java.lang.System;
dynamic public class NestingTree {
  internal var contents: List = new ArrayList(new Arguments(java.util.ArrayList.ArrayList__, []));
  internal var isLeaf: Boolean = true;
  internal var size: int;
  internal var sortValue: Number = 0;
  internal var subgraph: Node;
  private static function addToNestingTree__Ljava_util_Map_2Lorg_eclipse_draw2d_graph_Node_2(map: Map, child: Node): void {
    var subgraph: Subgraph = child.getParent__();
    var parent: NestingTree = NestingTree(map.get__Ljava_lang_Object_2(subgraph));
    if (parent === null) {
      parent = new NestingTree();
      parent.subgraph = subgraph;
      map.put__Ljava_lang_Object_2Ljava_lang_Object_2(subgraph, parent);
      if (subgraph !== null)
        addToNestingTree__Ljava_util_Map_2Lorg_eclipse_draw2d_graph_NestingTree_2(map, parent);
    }
    parent.contents.add__Ljava_lang_Object_2(child);
    return;
  }
  private static function addToNestingTree__Ljava_util_Map_2Lorg_eclipse_draw2d_graph_NestingTree_2(map: Map, branch: NestingTree): void {
    var subgraph: Subgraph = branch.subgraph.getParent__();
    var parent: NestingTree = NestingTree(map.get__Ljava_lang_Object_2(subgraph));
    if (parent === null) {
      parent = new NestingTree();
      parent.subgraph = subgraph;
      map.put__Ljava_lang_Object_2Ljava_lang_Object_2(subgraph, parent);
      if (subgraph !== null)
        addToNestingTree__Ljava_util_Map_2Lorg_eclipse_draw2d_graph_NestingTree_2(map, parent);
    }
    parent.contents.add__Ljava_lang_Object_2(branch);
    return;
  }
  public static function buildNestingTreeForRank__Lorg_eclipse_draw2d_graph_Rank_2(rank: Rank): NestingTree {
    var nestingMap: Map = new HashMap(new Arguments(java.util.HashMap.HashMap__, []));
    for (var j: int = 0; j < rank.count__(); j++) {
      var node: Node = rank.getNode__I(j);
      addToNestingTree__Ljava_util_Map_2Lorg_eclipse_draw2d_graph_Node_2(nestingMap, node);
    }
    return NestingTree(nestingMap.get__Ljava_lang_Object_2(null));
  }
  public function calculateSortValues__(): void {
    var total: int = 0;
    for (var i: int = 0; i < contents.size__(); i++) {
      var o: Object = contents.get__I(i);
      if (o is NestingTree) {
        isLeaf = false;
        var e: NestingTree = NestingTree(o);
        e.calculateSortValues__();
        total += int((e.sortValue * e.size));
        size += e.size;
      } else {
        var n: Node = Node(o);
        n.sortValue = n.index;
        total += n.index;
        size++;
      }
    }
    sortValue = Number(total) / size;
    return;
  }
  public function getSortValueFromSubgraph__(): void {
    if (subgraph !== null)
      sortValue = subgraph.sortValue;
    for (var i: int = 0; i < contents.size__(); i++) {
      var o: Object = contents.get__I(i);
      if (o is NestingTree)
        (NestingTree(o)).getSortValueFromSubgraph__();
    }
    return;
  }
  public function recursiveSort__Z(sortLeaves: Boolean): void {
    if (isLeaf && !sortLeaves)
      return;
    var change: Boolean = false;
    do {
      change = false;
      for (var i: int = 0; i < contents.size__() - 1; i++)
        change = (change) ? (this.swap__I(i), true) : (this.swap__I(i));
      if (!change)
        break;
      change = false;
      for (var i_1: int = contents.size__() - 2; i_1 >= 0; i_1--)
        change = (change) ? (this.swap__I(i_1), true) : (this.swap__I(i_1));
    } while (change);
    for (var i_2: int = 0; i_2 < contents.size__(); i_2++) {
      var o: Object = contents.get__I(i_2);
      if (o is NestingTree)
        (NestingTree(o)).recursiveSort__Z(sortLeaves);
    }
    return;
  }
  public function repopulateRank__Lorg_eclipse_draw2d_graph_Rank_2(r: Rank): void {
    for (var i: int = 0; i < contents.size__(); i++) {
      var o: Object = contents.get__I(i);
      if (o is Node)
        r.add__Ljava_lang_Object_2(o);
      else
        (NestingTree(o)).repopulateRank__Lorg_eclipse_draw2d_graph_Rank_2(r);
    }
    return;
  }
  public function swap__I(index: int): Boolean {
    var left: Object = contents.get__I(index);
    var right: Object = contents.get__I(index + 1);
    var iL: Number = (left is Node) ? (Node(left)).sortValue : (NestingTree(left)).sortValue;
    var iR: Number = (right is Node) ? (Node(right)).sortValue : (NestingTree(right)).sortValue;
    if (iL <= iR)
      return false;
    contents.set__ILjava_lang_Object_2(index, right);
    contents.set__ILjava_lang_Object_2(index + 1, left);
    return true;
  }
  public function toString__(): String {
    return "Nesting:" + java.lang.System.stringValueOf(subgraph);
  }
}
}
