package org.eclipse.draw2d.graph {
import java.util.Iterator;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import java.util.Iterator;
import java.lang.RuntimeException;
import java.lang.Arguments;
import java.lang.JavaArray;
import java.lang.System;
dynamic public class Node {
  internal var left: Node;
  internal var right: Node;
  internal var workingData: JavaArray = new JavaArray("[Ljava/lang/Object;").lengths(3);
  internal var workingInts: JavaArray = new JavaArray("[I").lengths(4);
  public var data: Object;
  internal var flag: Boolean;
  public var height: int = 40;
  public var rowOrder: int = -1;
  public var incoming: EdgeList = new EdgeList();
  public var incomingOffset: int = -1;
  internal var index: int;
  internal var nestingIndex: int = -1;
  public var outgoing: EdgeList = new EdgeList();
  internal var padding: Insets;
  private var parent: Subgraph;
  internal var rank: int;
  public var sortValue: Number = 0;
  public var outgoingOffset: int = -1;
  public var width: int = 50;
  public var x: int;
  public var y: int;
  public function Node__(): Object {
    return this;
  }
  public function Node__Ljava_lang_Object_2(data: Object): Object {
    return this;
  }
  public function Node__Lorg_eclipse_draw2d_graph_Subgraph_2(parent: Subgraph): Object {
    return this;
  }
  public function Node__Ljava_lang_Object_2Lorg_eclipse_draw2d_graph_Subgraph_2(data: Object, parent: Subgraph): Object {
    this.data = data;
    this.parent = parent;
    if (parent !== null)
      parent.addMember__Lorg_eclipse_draw2d_graph_Node_2(this);
    return this;
  }
  public function getOffsetIncoming__(): int {
    if (incomingOffset == -1)
      return int(width / 2);
    return incomingOffset;
  }
  public function getOffsetOutgoing__(): int {
    if (outgoingOffset == -1)
      return int(width / 2);
    return outgoingOffset;
  }
  public function getPadding__(): Insets {
    return padding;
  }
  public function getParent__(): Subgraph {
    return parent;
  }
  public function isNested__Lorg_eclipse_draw2d_graph_Node_2(node: Node): Boolean {
    return node === this;
  }
  public function setPadding__Lorg_eclipse_draw2d_geometry_Insets_2(padding_1: Insets): void {
    this.padding = padding_1;
  }
  public function setParent__Lorg_eclipse_draw2d_graph_Subgraph_2(parent_1: Subgraph): void {
    this.parent = parent_1;
  }
  public function setRowConstraint__I(value: int): void {
    this.rowOrder = value;
  }
  public function getRowConstraint__(): int {
    return rowOrder;
  }
  public function setSize__Lorg_eclipse_draw2d_geometry_Dimension_2(size: Dimension): void {
    width = size.width;
    height = size.height;
  }
  public function toString__(): String {
    return "N(" + java.lang.System.stringValueOf(data) + ")";
  }
  public function iteratorNeighbors__(): Iterator {
    return new org.eclipse.draw2d.graph.Node$1(this);
  }
  public function getLeft__(): Node {
    return left;
  }
  public function getRight__(): Node {
    return right;
  }
  public function Node(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is Object) {
        args = vargs;
        id = 1;
      } else if (vargs.length == 1 && vargs[0] is Subgraph) {
        args = vargs;
        id = 2;
      } else if (vargs.length == 2 && vargs[0] is Object && vargs[1] is Subgraph) {
        args = vargs;
        id = 3;
      }
    }
    switch (id) {
      case 0:
        break;
      case 1:
        var args1: Array = [args[0]];
        args3 = [args1[0], null];
        break;
      case 2:
        var args2: Array = [args[0]];
        args3 = [null, args2[0]];
        break;
      case 3:
        var args3: Array = [args[0], args[1]];
        break;
    }
    super();
    switch (id) {
      case 0:
        Node__();
        break;
      case 1:
        Node__Ljava_lang_Object_2Lorg_eclipse_draw2d_graph_Subgraph_2(args3[0], args3[1]);
        Node__Ljava_lang_Object_2(args1[0]);
        break;
      case 2:
        Node__Ljava_lang_Object_2Lorg_eclipse_draw2d_graph_Subgraph_2(args3[0], args3[1]);
        Node__Lorg_eclipse_draw2d_graph_Subgraph_2(args2[0]);
        break;
      case 3:
        Node__Ljava_lang_Object_2Lorg_eclipse_draw2d_graph_Subgraph_2(args3[0], args3[1]);
        break;
    }
  }
  public static const Node__ : int = 0;
  public static const Node__Ljava_lang_Object_2 : int = 1;
  public static const Node__Lorg_eclipse_draw2d_graph_Subgraph_2 : int = 2;
  public static const Node__Ljava_lang_Object_2Lorg_eclipse_draw2d_graph_Subgraph_2 : int = 3;
}
}
