package org.eclipse.draw2d.graph {
import java.util.Collection;
import java.lang.System;
import java.util.Collection;
import java.lang.Integer;
import java.lang.Math__;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class NodeCluster extends NodeList {
  internal var hashCode: int = Object(new Object()).hashCode__();
  internal var isSetMember: Boolean;
  internal var isDirty: Boolean;
  internal var leftDirty: Boolean;
  internal var rightDirty: Boolean;
  internal var leftFreedom: int;
  internal var rightFreedom: int;
  internal var leftNonzero: int;
  internal var rightNonzero: int;
  internal var leftCount: int = 0;
  internal var rightCount: int = 0;
  internal var leftLinks: JavaArray = new JavaArray("[Lorg/eclipse/draw2d/graph/CollapsedEdges;").lengths(10);
  internal var rightLinks: JavaArray = new JavaArray("[Lorg/eclipse/draw2d/graph/CollapsedEdges;").lengths(10);
  internal var leftNeighbors: JavaArray = new JavaArray("[Lorg/eclipse/draw2d/graph/NodeCluster;").lengths(10);
  internal var rightNeighbors: JavaArray = new JavaArray("[Lorg/eclipse/draw2d/graph/NodeCluster;").lengths(10);
  internal var effectivePull: int;
  internal var weightedTotal: int;
  internal var weightedDivisor: int;
  internal var unweightedTotal: int;
  internal var unweightedDivisor: int;
  public function addLeftNeighbor__Lorg_eclipse_draw2d_graph_NodeCluster_2Lorg_eclipse_draw2d_graph_CollapsedEdges_2(neighbor: NodeCluster, link: CollapsedEdges): void {
    if (leftNeighbors.length == leftCount) {
      var newSize: int = leftNeighbors.length * 2;
      var newNeighbors: JavaArray = new JavaArray("[Lorg/eclipse/draw2d/graph/NodeCluster;").lengths(newSize);
      var newLinks: JavaArray = new JavaArray("[Lorg/eclipse/draw2d/graph/CollapsedEdges;").lengths(newSize);
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(leftNeighbors, 0, newNeighbors, 0, leftNeighbors.length);
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(leftLinks, 0, newLinks, 0, leftLinks.length);
      leftNeighbors = newNeighbors;
      leftLinks = newLinks;
    }
    leftNeighbors[leftCount] = neighbor;
    leftLinks[leftCount++] = link;
    return;
  }
  public function addRightNeighbor__Lorg_eclipse_draw2d_graph_NodeCluster_2Lorg_eclipse_draw2d_graph_CollapsedEdges_2(neighbor: NodeCluster, link: CollapsedEdges): void {
    if (rightNeighbors.length == rightCount) {
      var newSize: int = rightNeighbors.length * 2;
      var newNeighbors: JavaArray = new JavaArray("[Lorg/eclipse/draw2d/graph/NodeCluster;").lengths(newSize);
      var newLinks: JavaArray = new JavaArray("[Lorg/eclipse/draw2d/graph/CollapsedEdges;").lengths(newSize);
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(rightNeighbors, 0, newNeighbors, 0, rightNeighbors.length);
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(rightLinks, 0, newLinks, 0, rightLinks.length);
      rightNeighbors = newNeighbors;
      rightLinks = newLinks;
    }
    rightNeighbors[rightCount] = neighbor;
    rightLinks[rightCount++] = link;
    return;
  }
  public function adjustRank__ILjava_util_Collection_2(delta: int, affected: Collection): void {
    this.adjustRank__I(delta);
    var neighbor: NodeCluster;
    var edges: CollapsedEdges;
    for (var i: int = 0; i < leftCount; i++) {
      neighbor = leftNeighbors[i];
      if (neighbor.isSetMember)
        continue;
      edges = leftLinks[i];
      neighbor.weightedTotal += delta * edges.collapsedWeight;
      neighbor.unweightedTotal += delta * edges.collapsedCount;
      weightedTotal -= delta * edges.collapsedWeight;
      unweightedTotal -= delta * edges.collapsedCount;
      neighbor.rightDirty = leftDirty = true;
      if (!neighbor.isDirty) {
        neighbor.isDirty = true;
        affected.add__Ljava_lang_Object_2(neighbor);
      }
    }
    for (var i_1: int = 0; i_1 < rightCount; i_1++) {
      neighbor = rightNeighbors[i_1];
      if (neighbor.isSetMember)
        continue;
      edges = rightLinks[i_1];
      neighbor.weightedTotal += delta * edges.collapsedWeight;
      neighbor.unweightedTotal += delta * edges.collapsedCount;
      weightedTotal -= delta * edges.collapsedWeight;
      unweightedTotal -= delta * edges.collapsedCount;
      neighbor.leftDirty = rightDirty = true;
      if (!neighbor.isDirty) {
        neighbor.isDirty = true;
        affected.add__Ljava_lang_Object_2(neighbor);
      }
    }
    isDirty = true;
    affected.add__Ljava_lang_Object_2(this);
    return;
  }
  public override function equals__Ljava_lang_Object_2(o: Object): Boolean {
    return o === this;
  }
  public function getLeftNeighbor__Lorg_eclipse_draw2d_graph_NodeCluster_2(neighbor: NodeCluster): CollapsedEdges {
    for (var i: int = 0; i < leftCount; i++) {
      if (leftNeighbors[i] === neighbor)
        return leftLinks[i];
    }
    return null;
  }
  public function getPull__(): int {
    return effectivePull;
  }
  public function getRightNeighbor__Lorg_eclipse_draw2d_graph_NodeCluster_2(neighbor: NodeCluster): CollapsedEdges {
    for (var i: int = 0; i < rightCount; i++) {
      if (rightNeighbors[i] === neighbor)
        return rightLinks[i];
    }
    return null;
  }
  public override function hashCode__(): int {
    return hashCode;
  }
  public function initValues__(): void {
    weightedTotal = 0;
    weightedDivisor = 0;
    unweightedTotal = 0;
    var slack: int;
    leftNonzero = rightNonzero = leftFreedom = rightFreedom = 2147483647;
    for (var i: int = 0; i < leftCount; i++) {
      var edges: CollapsedEdges = leftLinks[i];
      weightedTotal -= edges.getWeightedPull__();
      unweightedTotal -= edges.tightestEdge.getSlack__();
      unweightedDivisor += edges.collapsedCount;
      weightedDivisor += edges.collapsedWeight;
      slack = edges.tightestEdge.getSlack__();
      leftFreedom = Math__.min__II(slack, leftFreedom);
      if (slack > 0)
        leftNonzero = Math__.min__II(slack, leftNonzero);
    }
    for (var i_1: int = 0; i_1 < rightCount; i_1++) {
      var edges_1: CollapsedEdges = rightLinks[i_1];
      weightedTotal += edges_1.getWeightedPull__();
      unweightedDivisor += edges_1.collapsedCount;
      unweightedTotal += edges_1.tightestEdge.getSlack__();
      weightedDivisor += edges_1.collapsedWeight;
      slack = edges_1.tightestEdge.getSlack__();
      rightFreedom = Math__.min__II(slack, rightFreedom);
      if (slack > 0)
        rightNonzero = Math__.min__II(slack, rightNonzero);
    }
    this.updateEffectivePull__();
    return;
  }
  public function refreshValues__(): void {
    var slack: int;
    isDirty = false;
    if (leftDirty) {
      leftDirty = false;
      leftNonzero = leftFreedom = 2147483647;
      for (var i: int = 0; i < leftCount; i++) {
        var edges: CollapsedEdges = leftLinks[i];
        slack = edges.tightestEdge.getSlack__();
        leftFreedom = Math__.min__II(slack, leftFreedom);
        if (slack > 0)
          leftNonzero = Math__.min__II(slack, leftNonzero);
      }
    }
    if (rightDirty) {
      rightDirty = false;
      rightNonzero = rightFreedom = 2147483647;
      for (var i_1: int = 0; i_1 < rightCount; i_1++) {
        var edges_1: CollapsedEdges = rightLinks[i_1];
        slack = edges_1.tightestEdge.getSlack__();
        rightFreedom = Math__.min__II(slack, rightFreedom);
        if (slack > 0)
          rightNonzero = Math__.min__II(slack, rightNonzero);
      }
    }
    this.updateEffectivePull__();
    return;
  }
  private function updateEffectivePull__(): void {
    if (weightedDivisor != 0)
      effectivePull = int(weightedTotal / weightedDivisor);
    else if (unweightedDivisor != 0)
      effectivePull = int(unweightedTotal / unweightedDivisor);
    else
      effectivePull = 0;
    return;
  }
}
}
