package org.eclipse.draw2d.graph {
import org.eclipse.draw2d.PositionConstants;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import java.lang.Arguments;
dynamic public class Obstacle extends Rectangle {
  internal var exclude: Boolean;
  internal var topLeft: Vertex;
  internal var topRight: Vertex;
  internal var bottomLeft: Vertex;
  internal var bottomRight: Vertex;
  internal var center: Vertex;
  private var router: ShortestPathRouter;
  function Obstacle(rect: Rectangle, router: ShortestPathRouter) {
    this.init__Lorg_eclipse_draw2d_geometry_Rectangle_2(rect);
    this.router = router;
    return;
  }
  public function containsProper__Lorg_eclipse_draw2d_geometry_Point_2(p: Point): Boolean {
    return p.x > this.x && p.x < this.x + this.width - 1 && p.y > this.y && p.y < this.y + this.height - 1;
  }
  public function getSpacing__(): int {
    return router.getSpacing__();
  }
  private function growVertex__Lorg_eclipse_draw2d_graph_Vertex_2(vertex: Vertex): void {
    if (vertex.totalCount > 0)
      vertex.grow__();
  }
  public function growVertices__(): void {
    this.growVertex__Lorg_eclipse_draw2d_graph_Vertex_2(topLeft);
    this.growVertex__Lorg_eclipse_draw2d_graph_Vertex_2(topRight);
    this.growVertex__Lorg_eclipse_draw2d_graph_Vertex_2(bottomLeft);
    this.growVertex__Lorg_eclipse_draw2d_graph_Vertex_2(bottomRight);
  }
  public function init__Lorg_eclipse_draw2d_geometry_Rectangle_2(rect: Rectangle): void {
    this.x = rect.x;
    this.y = rect.y;
    this.width = rect.width;
    this.height = rect.height;
    exclude = false;
    topLeft = new Vertex(new Arguments(org.eclipse.draw2d.graph.Vertex.Vertex__IILorg_eclipse_draw2d_graph_Obstacle_2, [x, y, this]));
    topLeft.positionOnObstacle = 9;
    topRight = new Vertex(new Arguments(org.eclipse.draw2d.graph.Vertex.Vertex__IILorg_eclipse_draw2d_graph_Obstacle_2, [x + width - 1, y, this]));
    topRight.positionOnObstacle = 17;
    bottomLeft = new Vertex(new Arguments(org.eclipse.draw2d.graph.Vertex.Vertex__IILorg_eclipse_draw2d_graph_Obstacle_2, [x, y + height - 1, this]));
    bottomLeft.positionOnObstacle = 12;
    bottomRight = new Vertex(new Arguments(org.eclipse.draw2d.graph.Vertex.Vertex__IILorg_eclipse_draw2d_graph_Obstacle_2, [x + width - 1, y + height - 1, this]));
    bottomRight.positionOnObstacle = 20;
    center = new Vertex(new Arguments(org.eclipse.draw2d.graph.Vertex.Vertex__Lorg_eclipse_draw2d_geometry_Point_2Lorg_eclipse_draw2d_graph_Obstacle_2, [this.getCenter__(), this]));
  }
  public function reset__(): void {
    topLeft.fullReset__();
    bottomLeft.fullReset__();
    bottomRight.fullReset__();
    topRight.fullReset__();
  }
  private function shrinkVertex__Lorg_eclipse_draw2d_graph_Vertex_2(vertex: Vertex): void {
    if (vertex.totalCount > 0)
      vertex.shrink__();
  }
  public function shrinkVertices__(): void {
    this.shrinkVertex__Lorg_eclipse_draw2d_graph_Vertex_2(topLeft);
    this.shrinkVertex__Lorg_eclipse_draw2d_graph_Vertex_2(topRight);
    this.shrinkVertex__Lorg_eclipse_draw2d_graph_Vertex_2(bottomLeft);
    this.shrinkVertex__Lorg_eclipse_draw2d_graph_Vertex_2(bottomRight);
  }
  public override function toString__(): String {
    return "Obstacle(" + x + ", " + y + ", " + width + ", " + height + ")";
  }
}
}
