package org.eclipse.draw2d.graph {
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.draw2d.PositionConstants;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.HashSet;
import java.util.Iterator;
import java.lang.RuntimeException;
import java.lang.Arguments;
dynamic public class Path {
  public static var CURRENT: Point = new Point(new Arguments(org.eclipse.draw2d.geometry.Point.Point__, []));
  public static const EPSILON: Number = 1.04;
  public static var NEXT: Point = new Point(new Arguments(org.eclipse.draw2d.geometry.Point.Point__, []));
  public static const OVAL_CONSTANT: Number = 1.13;
  internal var bendpoints: PointList;
  public var data: Object;
  internal var excludedObstacles: List;
  internal var grownSegments: List;
  public var isDirty: Boolean = true;
  internal var isInverted: Boolean = false;
  internal var isMarked: Boolean = false;
  internal var points: PointList;
  private var prevCostRatio: Number = 0;
  internal var segments: List;
  private var stack: Path$SegmentStack;
  internal var start: Vertex;
  internal var end: Vertex;
  private var subPath: Path;
  internal var threshold: Number = 0;
  internal var visibleObstacles: Set;
  internal var visibleVertices: Set;
  public function Path__(): Object {
    segments = new ArrayList(new Arguments(java.util.ArrayList.ArrayList__, []));
    grownSegments = new ArrayList(new Arguments(java.util.ArrayList.ArrayList__, []));
    points = new PointList(new Arguments(org.eclipse.draw2d.geometry.PointList.PointList__, []));
    visibleVertices = new HashSet(new Arguments(java.util.HashSet.HashSet__, []));
    stack = new Path$SegmentStack();
    visibleObstacles = new HashSet(new Arguments(java.util.HashSet.HashSet__, []));
    excludedObstacles = new ArrayList(new Arguments(java.util.ArrayList.ArrayList__, []));
    return this;
  }
  public function Path__Ljava_lang_Object_2(data: Object): Object {
    this.data = data;
    return this;
  }
  public function Path__Lorg_eclipse_draw2d_geometry_Point_2Lorg_eclipse_draw2d_geometry_Point_2(start: Point, end: Point): Object {
    return this;
  }
  public function Path__Lorg_eclipse_draw2d_graph_Vertex_2Lorg_eclipse_draw2d_graph_Vertex_2(start: Vertex, end: Vertex): Object {
    this.start = start;
    this.end = end;
    return this;
  }
  private function addAllSegmentsBetween__Lorg_eclipse_draw2d_graph_Obstacle_2Lorg_eclipse_draw2d_graph_Obstacle_2(source: Obstacle, target: Obstacle): void {
    this.addConnectingSegment__Lorg_eclipse_draw2d_graph_Segment_2Lorg_eclipse_draw2d_graph_Obstacle_2Lorg_eclipse_draw2d_graph_Obstacle_2ZZ(new Segment(source.bottomLeft, target.bottomLeft), source, target, false, false);
    this.addConnectingSegment__Lorg_eclipse_draw2d_graph_Segment_2Lorg_eclipse_draw2d_graph_Obstacle_2Lorg_eclipse_draw2d_graph_Obstacle_2ZZ(new Segment(source.bottomRight, target.bottomRight), source, target, true, true);
    this.addConnectingSegment__Lorg_eclipse_draw2d_graph_Segment_2Lorg_eclipse_draw2d_graph_Obstacle_2Lorg_eclipse_draw2d_graph_Obstacle_2ZZ(new Segment(source.topLeft, target.topLeft), source, target, true, true);
    this.addConnectingSegment__Lorg_eclipse_draw2d_graph_Segment_2Lorg_eclipse_draw2d_graph_Obstacle_2Lorg_eclipse_draw2d_graph_Obstacle_2ZZ(new Segment(source.topRight, target.topRight), source, target, false, false);
    if (source.bottom__() == target.bottom__()) {
      this.addConnectingSegment__Lorg_eclipse_draw2d_graph_Segment_2Lorg_eclipse_draw2d_graph_Obstacle_2Lorg_eclipse_draw2d_graph_Obstacle_2ZZ(new Segment(source.bottomLeft, target.bottomRight), source, target, false, true);
      this.addConnectingSegment__Lorg_eclipse_draw2d_graph_Segment_2Lorg_eclipse_draw2d_graph_Obstacle_2Lorg_eclipse_draw2d_graph_Obstacle_2ZZ(new Segment(source.bottomRight, target.bottomLeft), source, target, true, false);
    }
    if (source.y == target.y) {
      this.addConnectingSegment__Lorg_eclipse_draw2d_graph_Segment_2Lorg_eclipse_draw2d_graph_Obstacle_2Lorg_eclipse_draw2d_graph_Obstacle_2ZZ(new Segment(source.topLeft, target.topRight), source, target, true, false);
      this.addConnectingSegment__Lorg_eclipse_draw2d_graph_Segment_2Lorg_eclipse_draw2d_graph_Obstacle_2Lorg_eclipse_draw2d_graph_Obstacle_2ZZ(new Segment(source.topRight, target.topLeft), source, target, false, true);
    }
    if (source.x == target.x) {
      this.addConnectingSegment__Lorg_eclipse_draw2d_graph_Segment_2Lorg_eclipse_draw2d_graph_Obstacle_2Lorg_eclipse_draw2d_graph_Obstacle_2ZZ(new Segment(source.bottomLeft, target.topLeft), source, target, false, true);
      this.addConnectingSegment__Lorg_eclipse_draw2d_graph_Segment_2Lorg_eclipse_draw2d_graph_Obstacle_2Lorg_eclipse_draw2d_graph_Obstacle_2ZZ(new Segment(source.topLeft, target.bottomLeft), source, target, true, false);
    }
    if (source.right__() == target.right__()) {
      this.addConnectingSegment__Lorg_eclipse_draw2d_graph_Segment_2Lorg_eclipse_draw2d_graph_Obstacle_2Lorg_eclipse_draw2d_graph_Obstacle_2ZZ(new Segment(source.bottomRight, target.topRight), source, target, true, false);
      this.addConnectingSegment__Lorg_eclipse_draw2d_graph_Segment_2Lorg_eclipse_draw2d_graph_Obstacle_2Lorg_eclipse_draw2d_graph_Obstacle_2ZZ(new Segment(source.topRight, target.bottomRight), source, target, false, true);
    }
    return;
  }
  private function addConnectingSegment__Lorg_eclipse_draw2d_graph_Segment_2Lorg_eclipse_draw2d_graph_Obstacle_2Lorg_eclipse_draw2d_graph_Obstacle_2ZZ(segment: Segment, o1: Obstacle, o2: Obstacle, checkTopRight1: Boolean, checkTopRight2: Boolean): void {
    if (threshold != 0 && (segment.end.getDistance__Lorg_eclipse_draw2d_geometry_Point_2(end) + segment.end.getDistance__Lorg_eclipse_draw2d_geometry_Point_2(start) > threshold || segment.start.getDistance__Lorg_eclipse_draw2d_geometry_Point_2(end) + segment.start.getDistance__Lorg_eclipse_draw2d_geometry_Point_2(start) > threshold))
      return;
    if (o2.containsProper__Lorg_eclipse_draw2d_geometry_Point_2(segment.start) || o1.containsProper__Lorg_eclipse_draw2d_geometry_Point_2(segment.end))
      return;
    if (checkTopRight1 && segment.intersects__IIII(o1.x, o1.bottom__() - 1, o1.right__() - 1, o1.y))
      return;
    if (checkTopRight2 && segment.intersects__IIII(o2.x, o2.bottom__() - 1, o2.right__() - 1, o2.y))
      return;
    if (!checkTopRight1 && segment.intersects__IIII(o1.x, o1.y, o1.right__() - 1, o1.bottom__() - 1))
      return;
    if (!checkTopRight2 && segment.intersects__IIII(o2.x, o2.y, o2.right__() - 1, o2.bottom__() - 1))
      return;
    stack.push__Ljava_lang_Object_2(o1);
    stack.push__Ljava_lang_Object_2(o2);
    stack.push__Ljava_lang_Object_2(segment);
  }
  private function addObstacle__Lorg_eclipse_draw2d_graph_Obstacle_2(newObs: Obstacle): void {
    visibleObstacles.add__Ljava_lang_Object_2(newObs);
    var oItr: Iterator = Iterator(new HashSet(new Arguments(java.util.HashSet.HashSet__Ljava_util_Collection_2, [visibleObstacles])).iterator__());
    while (oItr.hasNext__()) {
      var currObs: Obstacle = Obstacle(oItr.next__());
      if (newObs !== currObs)
        this.addSegmentsFor__Lorg_eclipse_draw2d_graph_Obstacle_2Lorg_eclipse_draw2d_graph_Obstacle_2(newObs, currObs);
    }
    this.addPerimiterSegments__Lorg_eclipse_draw2d_graph_Obstacle_2(newObs);
    this.addSegmentsFor__Lorg_eclipse_draw2d_graph_Vertex_2Lorg_eclipse_draw2d_graph_Obstacle_2(start, newObs);
    this.addSegmentsFor__Lorg_eclipse_draw2d_graph_Vertex_2Lorg_eclipse_draw2d_graph_Obstacle_2(end, newObs);
    return;
  }
  private function addPerimiterSegments__Lorg_eclipse_draw2d_graph_Obstacle_2(obs: Obstacle): void {
    var seg: Segment = new Segment(obs.topLeft, obs.topRight);
    stack.push__Ljava_lang_Object_2(obs);
    stack.push__Ljava_lang_Object_2(null);
    stack.push__Ljava_lang_Object_2(seg);
    seg = new Segment(obs.topRight, obs.bottomRight);
    stack.push__Ljava_lang_Object_2(obs);
    stack.push__Ljava_lang_Object_2(null);
    stack.push__Ljava_lang_Object_2(seg);
    seg = new Segment(obs.bottomRight, obs.bottomLeft);
    stack.push__Ljava_lang_Object_2(obs);
    stack.push__Ljava_lang_Object_2(null);
    stack.push__Ljava_lang_Object_2(seg);
    seg = new Segment(obs.bottomLeft, obs.topLeft);
    stack.push__Ljava_lang_Object_2(obs);
    stack.push__Ljava_lang_Object_2(null);
    stack.push__Ljava_lang_Object_2(seg);
    return;
  }
  private function addSegment__Lorg_eclipse_draw2d_graph_Segment_2Lorg_eclipse_draw2d_graph_Obstacle_2Lorg_eclipse_draw2d_graph_Obstacle_2Ljava_util_List_2(segment: Segment, exclude1: Obstacle, exclude2: Obstacle, allObstacles: List): void {
    if (threshold != 0 && (segment.end.getDistance__Lorg_eclipse_draw2d_geometry_Point_2(end) + segment.end.getDistance__Lorg_eclipse_draw2d_geometry_Point_2(start) > threshold || segment.start.getDistance__Lorg_eclipse_draw2d_geometry_Point_2(end) + segment.start.getDistance__Lorg_eclipse_draw2d_geometry_Point_2(start) > threshold))
      return;
    for (var i: int = 0; i < allObstacles.size__(); i++) {
      var obs: Obstacle = Obstacle(allObstacles.get__I(i));
      if (obs === exclude1 || obs === exclude2 || obs.exclude)
        continue;
      if (segment.intersects__IIII(obs.x, obs.y, obs.right__() - 1, obs.bottom__() - 1) || segment.intersects__IIII(obs.x, obs.bottom__() - 1, obs.right__() - 1, obs.y) || obs.containsProper__Lorg_eclipse_draw2d_geometry_Point_2(segment.start) || obs.containsProper__Lorg_eclipse_draw2d_geometry_Point_2(segment.end)) {
        if (!visibleObstacles.contains__Ljava_lang_Object_2(obs))
          this.addObstacle__Lorg_eclipse_draw2d_graph_Obstacle_2(obs);
        return;
      }
    }
    this.linkVertices__Lorg_eclipse_draw2d_graph_Segment_2(segment);
    return;
  }
  private function addSegmentsFor__Lorg_eclipse_draw2d_graph_Obstacle_2Lorg_eclipse_draw2d_graph_Obstacle_2(source: Obstacle, target: Obstacle): void {
    if (source.intersects__Lorg_eclipse_draw2d_geometry_Rectangle_2(target))
      this.addAllSegmentsBetween__Lorg_eclipse_draw2d_graph_Obstacle_2Lorg_eclipse_draw2d_graph_Obstacle_2(source, target);
    else if (target.bottom__() - 1 < source.y)
      this.addSegmentsTargetAboveSource__Lorg_eclipse_draw2d_graph_Obstacle_2Lorg_eclipse_draw2d_graph_Obstacle_2(source, target);
    else if (source.bottom__() - 1 < target.y)
      this.addSegmentsTargetAboveSource__Lorg_eclipse_draw2d_graph_Obstacle_2Lorg_eclipse_draw2d_graph_Obstacle_2(target, source);
    else if (target.right__() - 1 < source.x)
      this.addSegmentsTargetBesideSource__Lorg_eclipse_draw2d_graph_Obstacle_2Lorg_eclipse_draw2d_graph_Obstacle_2(source, target);
    else
      this.addSegmentsTargetBesideSource__Lorg_eclipse_draw2d_graph_Obstacle_2Lorg_eclipse_draw2d_graph_Obstacle_2(target, source);
    return;
  }
  private function addSegmentsFor__Lorg_eclipse_draw2d_graph_Vertex_2Lorg_eclipse_draw2d_graph_Obstacle_2(vertex: Vertex, obs: Obstacle): void {
    var seg: Segment = null;
    var seg2: Segment = null;
    switch (obs.getPosition__Lorg_eclipse_draw2d_geometry_Point_2(vertex)) {
      case 12 :
      case 17 :
        seg = new Segment(vertex, obs.topLeft);
        seg2 = new Segment(vertex, obs.bottomRight);
        break;
      case 20 :
      case 9 :
        seg = new Segment(vertex, obs.topRight);
        seg2 = new Segment(vertex, obs.bottomLeft);
        break;
      case 1 :
        seg = new Segment(vertex, obs.topLeft);
        seg2 = new Segment(vertex, obs.topRight);
        break;
      case 16 :
        seg = new Segment(vertex, obs.bottomRight);
        seg2 = new Segment(vertex, obs.topRight);
        break;
      case 4 :
        seg = new Segment(vertex, obs.bottomRight);
        seg2 = new Segment(vertex, obs.bottomLeft);
        break;
      case 8 :
        seg = new Segment(vertex, obs.topLeft);
        seg2 = new Segment(vertex, obs.bottomLeft);
        break;
      default :
        if (vertex.x == obs.x) {
          seg = new Segment(vertex, obs.topLeft);
          seg2 = new Segment(vertex, obs.bottomLeft);
        } else if (vertex.y == obs.y) {
          seg = new Segment(vertex, obs.topLeft);
          seg2 = new Segment(vertex, obs.topRight);
        } else if (vertex.y == obs.bottom__() - 1) {
          seg = new Segment(vertex, obs.bottomLeft);
          seg2 = new Segment(vertex, obs.bottomRight);
        } else if (vertex.x == obs.right__() - 1) {
          seg = new Segment(vertex, obs.topRight);
          seg2 = new Segment(vertex, obs.bottomRight);
        } else {
          throw new RuntimeException(new Arguments(java.lang.RuntimeException.RuntimeException__Ljava_lang_String_2, ["Unexpected vertex conditions"]));
        }
    }
    stack.push__Ljava_lang_Object_2(obs);
    stack.push__Ljava_lang_Object_2(null);
    stack.push__Ljava_lang_Object_2(seg);
    stack.push__Ljava_lang_Object_2(obs);
    stack.push__Ljava_lang_Object_2(null);
    stack.push__Ljava_lang_Object_2(seg2);
    return;
  }
  private function addSegmentsTargetAboveSource__Lorg_eclipse_draw2d_graph_Obstacle_2Lorg_eclipse_draw2d_graph_Obstacle_2(source: Obstacle, target: Obstacle): void {
    var seg: Segment = null;
    var seg2: Segment = null;
    if (target.x > source.x) {
      seg = new Segment(source.topLeft, target.topLeft);
      if (target.x < source.right__() - 1)
        seg2 = new Segment(source.topRight, target.bottomLeft);
      else
        seg2 = new Segment(source.bottomRight, target.topLeft);
    } else if (source.x == target.x) {
      seg = new Segment(source.topLeft, target.bottomLeft);
      seg2 = new Segment(source.topRight, target.bottomLeft);
    } else {
      seg = new Segment(source.bottomLeft, target.bottomLeft);
      seg2 = new Segment(source.topRight, target.bottomLeft);
    }
    stack.push__Ljava_lang_Object_2(source);
    stack.push__Ljava_lang_Object_2(target);
    stack.push__Ljava_lang_Object_2(seg);
    stack.push__Ljava_lang_Object_2(source);
    stack.push__Ljava_lang_Object_2(target);
    stack.push__Ljava_lang_Object_2(seg2);
    seg = null;
    seg2 = null;
    if (target.right__() < source.right__()) {
      seg = new Segment(source.topRight, target.topRight);
      if (target.right__() - 1 > source.x)
        seg2 = new Segment(source.topLeft, target.bottomRight);
      else
        seg2 = new Segment(source.bottomLeft, target.topRight);
    } else if (source.right__() == target.right__()) {
      seg = new Segment(source.topRight, target.bottomRight);
      seg2 = new Segment(source.topLeft, target.bottomRight);
    } else {
      seg = new Segment(source.bottomRight, target.bottomRight);
      seg2 = new Segment(source.topLeft, target.bottomRight);
    }
    stack.push__Ljava_lang_Object_2(source);
    stack.push__Ljava_lang_Object_2(target);
    stack.push__Ljava_lang_Object_2(seg);
    stack.push__Ljava_lang_Object_2(source);
    stack.push__Ljava_lang_Object_2(target);
    stack.push__Ljava_lang_Object_2(seg2);
    return;
  }
  private function addSegmentsTargetBesideSource__Lorg_eclipse_draw2d_graph_Obstacle_2Lorg_eclipse_draw2d_graph_Obstacle_2(source: Obstacle, target: Obstacle): void {
    var seg: Segment = null;
    var seg2: Segment = null;
    if (target.y > source.y) {
      seg = new Segment(source.topLeft, target.topLeft);
      if (target.y < source.bottom__() - 1)
        seg2 = new Segment(source.bottomLeft, target.topRight);
      else
        seg2 = new Segment(source.bottomRight, target.topLeft);
    } else if (source.y == target.y) {
      seg = new Segment(source.topLeft, target.topRight);
      seg2 = new Segment(source.bottomLeft, target.topRight);
    } else {
      seg = new Segment(source.topRight, target.topRight);
      seg2 = new Segment(source.bottomLeft, target.topRight);
    }
    stack.push__Ljava_lang_Object_2(source);
    stack.push__Ljava_lang_Object_2(target);
    stack.push__Ljava_lang_Object_2(seg);
    stack.push__Ljava_lang_Object_2(source);
    stack.push__Ljava_lang_Object_2(target);
    stack.push__Ljava_lang_Object_2(seg2);
    seg = null;
    seg2 = null;
    if (target.bottom__() < source.bottom__()) {
      seg = new Segment(source.bottomLeft, target.bottomLeft);
      if (target.bottom__() - 1 > source.y)
        seg2 = new Segment(source.topLeft, target.bottomRight);
      else
        seg2 = new Segment(source.topRight, target.bottomLeft);
    } else if (source.bottom__() == target.bottom__()) {
      seg = new Segment(source.bottomLeft, target.bottomRight);
      seg2 = new Segment(source.topLeft, target.bottomRight);
    } else {
      seg = new Segment(source.bottomRight, target.bottomRight);
      seg2 = new Segment(source.topLeft, target.bottomRight);
    }
    stack.push__Ljava_lang_Object_2(source);
    stack.push__Ljava_lang_Object_2(target);
    stack.push__Ljava_lang_Object_2(seg);
    stack.push__Ljava_lang_Object_2(source);
    stack.push__Ljava_lang_Object_2(target);
    stack.push__Ljava_lang_Object_2(seg2);
    return;
  }
  public function cleanup__(): void {
    visibleVertices.clear__();
    return;
  }
  private function createVisibilityGraph__Ljava_util_List_2(allObstacles: List): void {
    stack.push__Ljava_lang_Object_2(null);
    stack.push__Ljava_lang_Object_2(null);
    stack.push__Ljava_lang_Object_2(new Segment(start, end));
    while (!stack.isEmpty__())
      this.addSegment__Lorg_eclipse_draw2d_graph_Segment_2Lorg_eclipse_draw2d_graph_Obstacle_2Lorg_eclipse_draw2d_graph_Obstacle_2Ljava_util_List_2(stack.pop__(), stack.popObstacle__(), stack.popObstacle__(), allObstacles);
    return;
  }
  private function determineShortestPath__(): Boolean {
    if (!this.labelGraph__())
      return false;
    var vertex: Vertex = end;
    prevCostRatio = end.cost / start.getDistance__Lorg_eclipse_draw2d_geometry_Point_2(end);
    var nextVertex: Vertex;
    while (!vertex.equals__Ljava_lang_Object_2(start)) {
      nextVertex = vertex.label;
      if (nextVertex === null)
        return false;
      var s: Segment = new Segment(nextVertex, vertex);
      segments.add__Ljava_lang_Object_2(s);
      vertex = nextVertex;
    }
    Collections.reverse__Ljava_util_List_2(segments);
    return true;
  }
  public function fullReset__(): void {
    visibleVertices.clear__();
    segments.clear__();
    if (prevCostRatio == 0) {
      var distance: Number = start.getDistance__Lorg_eclipse_draw2d_geometry_Point_2(end);
      threshold = distance * 1.13;
    } else
      threshold = prevCostRatio * 1.04 * start.getDistance__Lorg_eclipse_draw2d_geometry_Point_2(end);
    visibleObstacles.clear__();
    this.resetPartial__();
    return;
  }
  public function generateShortestPath__Ljava_util_List_2(allObstacles: List): Boolean {
    this.createVisibilityGraph__Ljava_util_List_2(allObstacles);
    if (visibleVertices.size__() == 0)
      return false;
    return this.determineShortestPath__();
  }
  public function getBendPoints__(): PointList {
    return bendpoints;
  }
  public function getEndPoint__(): Point {
    return end;
  }
  public function getPoints__(): PointList {
    return points;
  }
  public function getStartPoint__(): Point {
    return start;
  }
  public function getSubPath__Lorg_eclipse_draw2d_graph_Segment_2(currentSegment: Segment): Path {
    var newPath: Path = new Path(new Arguments(org.eclipse.draw2d.graph.Path.Path__Lorg_eclipse_draw2d_graph_Vertex_2Lorg_eclipse_draw2d_graph_Vertex_2, [currentSegment.start, end]));
    newPath.grownSegments = new ArrayList(new Arguments(java.util.ArrayList.ArrayList__Ljava_util_Collection_2, [grownSegments.subList__II(grownSegments.indexOf__Ljava_lang_Object_2(currentSegment), grownSegments.size__())]));
    grownSegments = new ArrayList(new Arguments(java.util.ArrayList.ArrayList__Ljava_util_Collection_2, [grownSegments.subList__II(0, grownSegments.indexOf__Ljava_lang_Object_2(currentSegment) + 1)]));
    end = currentSegment.end;
    subPath = newPath;
    return newPath;
  }
  public function invertPriorVertices__Lorg_eclipse_draw2d_graph_Segment_2(currentSegment: Segment): void {
    var stop: int = grownSegments.indexOf__Ljava_lang_Object_2(currentSegment);
    for (var i: int = 0; i < stop; i++) {
      var vertex: Vertex = (Segment(grownSegments.get__I(i))).end;
      if (vertex.type == 1)
        vertex.type = 2;
      else
        vertex.type = 1;
    }
    return;
  }
  public function isObstacleVisible__Lorg_eclipse_draw2d_graph_Obstacle_2(obs: Obstacle): Boolean {
    return visibleObstacles.contains__Ljava_lang_Object_2(obs);
  }
  private function labelGraph__(): Boolean {
    var numPermanentNodes: int = 1;
    var vertex: Vertex = start;
    var neighborVertex: Vertex = null;
    vertex.isPermanent = true;
    var newCost: Number = 0;
    while (numPermanentNodes != visibleVertices.size__()) {
      var neighbors: List = vertex.neighbors;
      if (neighbors === null)
        return false;
      for (var i: int = 0; i < neighbors.size__(); i++) {
        neighborVertex = Vertex(neighbors.get__I(i));
        if (!neighborVertex.isPermanent) {
          newCost = vertex.cost + vertex.getDistance__Lorg_eclipse_draw2d_geometry_Point_2(neighborVertex);
          if (neighborVertex.label === null) {
            neighborVertex.label = vertex;
            neighborVertex.cost = newCost;
          } else if (neighborVertex.cost > newCost) {
            neighborVertex.label = vertex;
            neighborVertex.cost = newCost;
          }
        }
      }
      var smallestCost: Number = 0;
      var tempVertex: Vertex = null;
      var v: Iterator = Iterator(visibleVertices.iterator__());
      while (v.hasNext__()) {
        tempVertex = Vertex(v.next__());
        if (!tempVertex.isPermanent && tempVertex.label !== null && (tempVertex.cost < smallestCost || smallestCost == 0)) {
          smallestCost = tempVertex.cost;
          vertex = tempVertex;
        }
      }
      vertex.isPermanent = true;
      numPermanentNodes++;
    }
    return true;
  }
  private function linkVertices__Lorg_eclipse_draw2d_graph_Segment_2(segment: Segment): void {
    if (segment.start.neighbors === null)
      segment.start.neighbors = new ArrayList(new Arguments(java.util.ArrayList.ArrayList__, []));
    if (segment.end.neighbors === null)
      segment.end.neighbors = new ArrayList(new Arguments(java.util.ArrayList.ArrayList__, []));
    if (!segment.start.neighbors.contains__Ljava_lang_Object_2(segment.end)) {
      segment.start.neighbors.add__Ljava_lang_Object_2(segment.end);
      segment.end.neighbors.add__Ljava_lang_Object_2(segment.start);
    }
    visibleVertices.add__Ljava_lang_Object_2(segment.start);
    visibleVertices.add__Ljava_lang_Object_2(segment.end);
    return;
  }
  public function reconnectSubPaths__(): void {
    if (subPath !== null) {
      subPath.reconnectSubPaths__();
      var changedSegment: Segment = Segment(subPath.grownSegments.remove__I(0));
      var oldSegment: Segment = Segment(grownSegments.get__I(grownSegments.size__() - 1));
      oldSegment.end = changedSegment.end;
      grownSegments.addAll__Ljava_util_Collection_2(subPath.grownSegments);
      subPath.points.removePoint__I(0);
      points.removePoint__I(points.size__() - 1);
      points.addAll__Lorg_eclipse_draw2d_geometry_PointList_2(subPath.points);
      visibleObstacles.addAll__Ljava_util_Collection_2(subPath.visibleObstacles);
      end = subPath.end;
      subPath = null;
    }
    return;
  }
  public function refreshExcludedObstacles__Ljava_util_List_2(allObstacles: List): void {
    excludedObstacles.clear__();
    for (var i: int = 0; i < allObstacles.size__(); i++) {
      var o: Obstacle = Obstacle(allObstacles.get__I(i));
      o.exclude = false;
      if (o.contains__Lorg_eclipse_draw2d_geometry_Point_2(start)) {
        if (o.containsProper__Lorg_eclipse_draw2d_geometry_Point_2(start))
          o.exclude = true;
        else {
        }
      }
      if (o.contains__Lorg_eclipse_draw2d_geometry_Point_2(end)) {
        if (o.containsProper__Lorg_eclipse_draw2d_geometry_Point_2(end))
          o.exclude = true;
        else {
        }
      }
      if (o.exclude && !excludedObstacles.contains__Ljava_lang_Object_2(o))
        excludedObstacles.add__Ljava_lang_Object_2(o);
    }
    return;
  }
  public function resetPartial__(): void {
    isMarked = false;
    isInverted = false;
    subPath = null;
    isDirty = false;
    grownSegments.clear__();
    points.removeAllPoints__();
    return;
  }
  public function setBendPoints__Lorg_eclipse_draw2d_geometry_PointList_2(bendPoints: PointList): void {
    this.bendpoints = bendPoints;
    isDirty = true;
    return;
  }
  public function setEndPoint__Lorg_eclipse_draw2d_geometry_Point_2(end_1: Point): void {
    if (end_1.equals__Ljava_lang_Object_2(this.end))
      return;
    this.end = new Vertex(new Arguments(org.eclipse.draw2d.graph.Vertex.Vertex__Lorg_eclipse_draw2d_geometry_Point_2Lorg_eclipse_draw2d_graph_Obstacle_2, [end_1, null]));
    isDirty = true;
  }
  public function setStartPoint__Lorg_eclipse_draw2d_geometry_Point_2(start_1: Point): void {
    if (start_1.equals__Ljava_lang_Object_2(this.start))
      return;
    this.start = new Vertex(new Arguments(org.eclipse.draw2d.graph.Vertex.Vertex__Lorg_eclipse_draw2d_geometry_Point_2Lorg_eclipse_draw2d_graph_Obstacle_2, [start_1, null]));
    isDirty = true;
  }
  public function testAndSet__Lorg_eclipse_draw2d_graph_Obstacle_2(obs: Obstacle): Boolean {
    if (isDirty)
      return false;
    if (excludedObstacles.contains__Ljava_lang_Object_2(obs))
      return false;
    var seg1: Segment = new Segment(obs.topLeft, obs.bottomRight);
    var seg2: Segment = new Segment(obs.topRight, obs.bottomLeft);
    for (var s: int = 0; s < points.size__() - 1; s++) {
      points.getPoint__Lorg_eclipse_draw2d_geometry_Point_2I(CURRENT, s);
      points.getPoint__Lorg_eclipse_draw2d_geometry_Point_2I(NEXT, s + 1);
      if (seg1.intersects__Lorg_eclipse_draw2d_geometry_Point_2Lorg_eclipse_draw2d_geometry_Point_2(CURRENT, NEXT) || seg2.intersects__Lorg_eclipse_draw2d_geometry_Point_2Lorg_eclipse_draw2d_geometry_Point_2(CURRENT, NEXT) || obs.contains__Lorg_eclipse_draw2d_geometry_Point_2(CURRENT) || obs.contains__Lorg_eclipse_draw2d_geometry_Point_2(NEXT)) {
        isDirty = true;
        return true;
      }
    }
    return false;
  }
  public function Path(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is Object) {
        args = vargs;
        id = 1;
      } else if (vargs.length == 2 && vargs[0] is Point && vargs[1] is Point) {
        args = vargs;
        id = 2;
      } else if (vargs.length == 2 && vargs[0] is Vertex && vargs[1] is Vertex) {
        args = vargs;
        id = 3;
      }
    }
    switch (id) {
      case 0:
        break;
      case 1:
        var args1: Array = [args[0]];
        break;
      case 2:
        var args2: Array = [args[0], args[1]];
        args3 = [new Vertex(new Arguments(org.eclipse.draw2d.graph.Vertex.Vertex__Lorg_eclipse_draw2d_geometry_Point_2Lorg_eclipse_draw2d_graph_Obstacle_2, [args2[0], null])), new Vertex(new Arguments(org.eclipse.draw2d.graph.Vertex.Vertex__Lorg_eclipse_draw2d_geometry_Point_2Lorg_eclipse_draw2d_graph_Obstacle_2, [args2[1], null]))];
        break;
      case 3:
        var args3: Array = [args[0], args[1]];
        break;
    }
    super();
    switch (id) {
      case 0:
        Path__();
        break;
      case 1:
        Path__();
        Path__Ljava_lang_Object_2(args1[0]);
        break;
      case 2:
        Path__();
        Path__Lorg_eclipse_draw2d_graph_Vertex_2Lorg_eclipse_draw2d_graph_Vertex_2(args3[0], args3[1]);
        Path__Lorg_eclipse_draw2d_geometry_Point_2Lorg_eclipse_draw2d_geometry_Point_2(args2[0], args2[1]);
        break;
      case 3:
        Path__();
        Path__Lorg_eclipse_draw2d_graph_Vertex_2Lorg_eclipse_draw2d_graph_Vertex_2(args3[0], args3[1]);
        break;
    }
  }
  public static const Path__ : int = 0;
  public static const Path__Ljava_lang_Object_2 : int = 1;
  public static const Path__Lorg_eclipse_draw2d_geometry_Point_2Lorg_eclipse_draw2d_geometry_Point_2 : int = 2;
  public static const Path__Lorg_eclipse_draw2d_graph_Vertex_2Lorg_eclipse_draw2d_graph_Vertex_2 : int = 3;
}
}
