package org.eclipse.draw2d.graph {
import java.util.Iterator;
import java.util.Stack;
import java.lang.Integer;
import java.util.Stack;
import java.util.Iterator;
import java.lang.Arguments;
dynamic public class RankAssignmentSolver extends SpanningTreeVisitor {
  internal var graph: DirectedGraph;
  internal var spanningTree: EdgeList;
  internal var searchDirection: Boolean;
  public function depthFirstCutValue__Lorg_eclipse_draw2d_graph_Edge_2I(edge: Edge, count: int): int {
    var n: Node = this.getTreeTail__Lorg_eclipse_draw2d_graph_Edge_2(edge);
    this.setTreeMin__Lorg_eclipse_draw2d_graph_Node_2I(n, count);
    var cutvalue: int = 0;
    var multiplier: int = (edge.target === n) ? 1 : -1;
    var list: EdgeList;
    list = n.outgoing;
    var e: Edge;
    for (var i: int = 0; i < list.size__(); i++) {
      e = list.getEdge__I(i);
      if (e.tree && e !== edge) {
        count = this.depthFirstCutValue__Lorg_eclipse_draw2d_graph_Edge_2I(e, count);
        cutvalue += (e.cut - e.weight) * multiplier;
      } else {
        cutvalue -= e.weight * multiplier;
      }
    }
    list = n.incoming;
    for (var i_1: int = 0; i_1 < list.size__(); i_1++) {
      e = list.getEdge__I(i_1);
      if (e.tree && e !== edge) {
        count = this.depthFirstCutValue__Lorg_eclipse_draw2d_graph_Edge_2I(e, count);
        cutvalue -= (e.cut - e.weight) * multiplier;
      } else {
        cutvalue += e.weight * multiplier;
      }
    }
    edge.cut = cutvalue;
    if (cutvalue < 0)
      spanningTree.add__Ljava_lang_Object_2(edge);
    this.setTreeMax__Lorg_eclipse_draw2d_graph_Node_2I(n, count);
    return count + 1;
  }
  public function enter__Lorg_eclipse_draw2d_graph_Node_2(branch: Node): Edge {
    var n: Node;
    var result: Edge = null;
    var minSlack: int = 2147483647;
    var incoming: Boolean = this.getParentEdge__Lorg_eclipse_draw2d_graph_Node_2(branch).target !== branch;
    for (var i: int = 0; i < graph.nodes.size__(); i++) {
      if (searchDirection)
        n = graph.nodes.getNode__I(i);
      else
        n = graph.nodes.getNode__I(graph.nodes.size__() - 1 - i);
      if (this.subtreeContains__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Node_2(branch, n)) {
        var edges: EdgeList;
        if (incoming)
          edges = n.incoming;
        else
          edges = n.outgoing;
        for (var j: int = 0; j < edges.size__(); j++) {
          var e: Edge = edges.getEdge__I(j);
          if (!this.subtreeContains__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Node_2(branch, e.opposite__Lorg_eclipse_draw2d_graph_Node_2(n)) && !e.tree && e.getSlack__() < minSlack) {
            result = e;
            minSlack = e.getSlack__();
          }
        }
      }
    }
    return result;
  }
  public function getTreeMax__Lorg_eclipse_draw2d_graph_Node_2(n: Node): int {
    return n.workingInts[1];
  }
  public function getTreeMin__Lorg_eclipse_draw2d_graph_Node_2(n: Node): int {
    return n.workingInts[0];
  }
  public function initCutValues__(): void {
    var root: Node = graph.nodes.getNode__I(0);
    spanningTree = new EdgeList();
    var e: Edge;
    this.setTreeMin__Lorg_eclipse_draw2d_graph_Node_2I(root, 1);
    this.setTreeMax__Lorg_eclipse_draw2d_graph_Node_2I(root, 1);
    for (var i: int = 0; i < root.outgoing.size__(); i++) {
      e = root.outgoing.getEdge__I(i);
      if (!this.getSpanningTreeChildren__Lorg_eclipse_draw2d_graph_Node_2(root).contains__Ljava_lang_Object_2(e))
        continue;
      this.setTreeMax__Lorg_eclipse_draw2d_graph_Node_2I(root, this.depthFirstCutValue__Lorg_eclipse_draw2d_graph_Edge_2I(e, this.getTreeMax__Lorg_eclipse_draw2d_graph_Node_2(root)));
    }
    for (var i_1: int = 0; i_1 < root.incoming.size__(); i_1++) {
      e = root.incoming.getEdge__I(i_1);
      if (!this.getSpanningTreeChildren__Lorg_eclipse_draw2d_graph_Node_2(root).contains__Ljava_lang_Object_2(e))
        continue;
      this.setTreeMax__Lorg_eclipse_draw2d_graph_Node_2I(root, this.depthFirstCutValue__Lorg_eclipse_draw2d_graph_Edge_2I(e, this.getTreeMax__Lorg_eclipse_draw2d_graph_Node_2(root)));
    }
    return;
  }
  public function leave__(): Edge {
    var result: Edge = null;
    var e: Edge;
    var minCut: int = 0;
    var weight: int = -1;
    for (var i: int = 0; i < spanningTree.size__(); i++) {
      e = spanningTree.getEdge__I(i);
      if (e.cut < minCut) {
        result = e;
        minCut = result.cut;
        weight = result.weight;
      } else if (e.cut == minCut && e.weight > weight) {
        result = e;
        weight = result.weight;
      }
    }
    return result;
  }
  public function networkSimplexLoop__(): void {
    var leave: Edge;
    var enter: Edge;
    var count: int = 0;
    while ((leave = this.leave__()) !== null && count < 900) {
      count++;
      var leaveTail: Node = this.getTreeTail__Lorg_eclipse_draw2d_graph_Edge_2(leave);
      var leaveHead: Node = this.getTreeHead__Lorg_eclipse_draw2d_graph_Edge_2(leave);
      enter = this.enter__Lorg_eclipse_draw2d_graph_Node_2(leaveTail);
      if (enter === null)
        break;
      this.getSpanningTreeChildren__Lorg_eclipse_draw2d_graph_Node_2(leaveHead).remove__Ljava_lang_Object_2(leave);
      this.setParentEdge__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Edge_2(leaveTail, null);
      leave.tree = false;
      spanningTree.remove__Ljava_lang_Object_2(leave);
      var enterTail: Node = enter.source;
      if (!this.subtreeContains__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Node_2(leaveTail, enterTail))
        enterTail = enter.target;
      var enterHead: Node = enter.opposite__Lorg_eclipse_draw2d_graph_Node_2(enterTail);
      this.updateSubgraph__Lorg_eclipse_draw2d_graph_Node_2(enterTail);
      this.getSpanningTreeChildren__Lorg_eclipse_draw2d_graph_Node_2(enterHead).add__Ljava_lang_Object_2(enter);
      this.setParentEdge__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Edge_2(enterTail, enter);
      enter.tree = true;
      this.repairCutValues__Lorg_eclipse_draw2d_graph_Edge_2(enter);
      var commonAncestor: Node = enterHead;
      while (!this.subtreeContains__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Node_2(commonAncestor, leaveHead)) {
        this.repairCutValues__Lorg_eclipse_draw2d_graph_Edge_2(this.getParentEdge__Lorg_eclipse_draw2d_graph_Node_2(commonAncestor));
        commonAncestor = this.getTreeParent__Lorg_eclipse_draw2d_graph_Node_2(commonAncestor);
      }
      while (leaveHead !== commonAncestor) {
        this.repairCutValues__Lorg_eclipse_draw2d_graph_Edge_2(this.getParentEdge__Lorg_eclipse_draw2d_graph_Node_2(leaveHead));
        leaveHead = this.getTreeParent__Lorg_eclipse_draw2d_graph_Node_2(leaveHead);
      }
      this.updateMinMax__Lorg_eclipse_draw2d_graph_Node_2I(commonAncestor, this.getTreeMin__Lorg_eclipse_draw2d_graph_Node_2(commonAncestor));
      this.tightenEdge__Lorg_eclipse_draw2d_graph_Edge_2(enter);
    }
    return;
  }
  public function repairCutValues__Lorg_eclipse_draw2d_graph_Edge_2(edge: Edge): void {
    spanningTree.remove__Ljava_lang_Object_2(edge);
    var n: Node = this.getTreeTail__Lorg_eclipse_draw2d_graph_Edge_2(edge);
    var cutvalue: int = 0;
    var multiplier: int = (edge.target === n) ? 1 : -1;
    var list: EdgeList;
    list = n.outgoing;
    var e: Edge;
    for (var i: int = 0; i < list.size__(); i++) {
      e = list.getEdge__I(i);
      if (e.tree && e !== edge)
        cutvalue += (e.cut - e.weight) * multiplier;
      else
        cutvalue -= e.weight * multiplier;
    }
    list = n.incoming;
    for (var i_1: int = 0; i_1 < list.size__(); i_1++) {
      e = list.getEdge__I(i_1);
      if (e.tree && e !== edge)
        cutvalue -= (e.cut - e.weight) * multiplier;
      else
        cutvalue += e.weight * multiplier;
    }
    edge.cut = cutvalue;
    if (cutvalue < 0)
      spanningTree.add__Ljava_lang_Object_2(edge);
    return;
  }
  public function setTreeMax__Lorg_eclipse_draw2d_graph_Node_2I(n: Node, value: int): void {
    n.workingInts[1] = value;
    return;
  }
  public function setTreeMin__Lorg_eclipse_draw2d_graph_Node_2I(n: Node, value: int): void {
    n.workingInts[0] = value;
    return;
  }
  public function subtreeContains__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Node_2(parent: Node, child: Node): Boolean {
    return parent.workingInts[0] <= child.workingInts[1] && child.workingInts[1] <= parent.workingInts[1];
  }
  public function tightenEdge__Lorg_eclipse_draw2d_graph_Edge_2(edge: Edge): void {
    var tail: Node = this.getTreeTail__Lorg_eclipse_draw2d_graph_Edge_2(edge);
    var delta: int = edge.getSlack__();
    if (tail === edge.target)
      delta = -delta;
    var n: Node;
    for (var i: int = 0; i < graph.nodes.size__(); i++) {
      n = graph.nodes.getNode__I(i);
      if (this.subtreeContains__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Node_2(tail, n))
        n.rank += delta;
    }
    return;
  }
  public function updateMinMax__Lorg_eclipse_draw2d_graph_Node_2I(root: Node, count: int): int {
    this.setTreeMin__Lorg_eclipse_draw2d_graph_Node_2I(root, count);
    var edges: EdgeList = this.getSpanningTreeChildren__Lorg_eclipse_draw2d_graph_Node_2(root);
    for (var i: int = 0; i < edges.size__(); i++)
      count = this.updateMinMax__Lorg_eclipse_draw2d_graph_Node_2I(this.getTreeTail__Lorg_eclipse_draw2d_graph_Edge_2(edges.getEdge__I(i)), count);
    this.setTreeMax__Lorg_eclipse_draw2d_graph_Node_2I(root, count);
    return count + 1;
  }
  public function updateSubgraph__Lorg_eclipse_draw2d_graph_Node_2(root: Node): void {
    var flip: Edge = this.getParentEdge__Lorg_eclipse_draw2d_graph_Node_2(root);
    if (flip !== null) {
      var rootParent: Node = this.getTreeParent__Lorg_eclipse_draw2d_graph_Node_2(root);
      this.getSpanningTreeChildren__Lorg_eclipse_draw2d_graph_Node_2(rootParent).remove__Ljava_lang_Object_2(flip);
      this.updateSubgraph__Lorg_eclipse_draw2d_graph_Node_2(rootParent);
      this.setParentEdge__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Edge_2(root, null);
      this.setParentEdge__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Edge_2(rootParent, flip);
      this.repairCutValues__Lorg_eclipse_draw2d_graph_Edge_2(flip);
      this.getSpanningTreeChildren__Lorg_eclipse_draw2d_graph_Node_2(root).add__Ljava_lang_Object_2(flip);
    }
    return;
  }
  public override function visit__Lorg_eclipse_draw2d_graph_DirectedGraph_2(graph_1: DirectedGraph): void {
    this.graph = graph_1;
    this.initCutValues__();
    this.networkSimplexLoop__();
    if (graph_1.forestRoot === null)
      graph_1.nodes.normalizeRanks__();
    else
      this.normalizeForest__();
    return;
  }
  private function normalizeForest__(): void {
    var tree: NodeList = new NodeList(new Arguments(org.eclipse.draw2d.graph.NodeList.NodeList__, []));
    graph.nodes.resetFlags__();
    graph.forestRoot.flag = true;
    var rootEdges: EdgeList = graph.forestRoot.outgoing;
    var stack: Stack = new Stack();
    for (var i: int = 0; i < rootEdges.size__(); i++) {
      var node: Node = rootEdges.getEdge__I(i).target;
      node.flag = true;
      stack.push__Ljava_lang_Object_2(node);
      while (!stack.isEmpty__()) {
        node = Node(stack.pop__());
        tree.add__Ljava_lang_Object_2(node);
        var neighbors: Iterator = node.iteratorNeighbors__();
        while (neighbors.hasNext__()) {
          var neighbor: Node = Node(neighbors.next__());
          if (!neighbor.flag) {
            neighbor.flag = true;
            stack.push__Ljava_lang_Object_2(neighbor);
          }
        }
      }
      tree.normalizeRanks__();
      tree.clear__();
    }
    return;
  }
}
}
