package org.eclipse.draw2d.graph {
import java.util.Collections;
import java.util.Comparator;
import java.util.Random;
import java.util.Comparator;
import java.lang.Arguments;
dynamic public class RankSorter {
  internal var flipflop: Random = new Random(new Arguments(java.util.Random.Random__J, [3]));
  internal var node: Node;
  internal var rankSize: Number = 0;
  internal var prevRankSize: Number = 0;
  internal var nextRankSize: Number = 0;
  internal var currentRow: int;
  internal var rank: Rank;
  internal var progress: Number = 0;
  internal var g: DirectedGraph;
  public function assignIncomingSortValues__(): void {
    rankSize = rank.total;
    prevRankSize = g.ranks.getRank__I(currentRow - 1).total;
    if (currentRow < g.ranks.size__() - 1)
      nextRankSize = g.ranks.getRank__I(currentRow + 1).total;
    for (var n: int = 0; n < rank.count__(); n++) {
      node = rank.getNode__I(n);
      this.sortValueIncoming__();
    }
    return;
  }
  public function assignOutgoingSortValues__(): void {
    rankSize = rank.total;
    prevRankSize = g.ranks.getRank__I(currentRow + 1).total;
    if (currentRow > 1)
      nextRankSize = g.ranks.getRank__I(currentRow - 1).total;
    for (var n: int = 0; n < rank.count__(); n++) {
      node = rank.getNode__I(n);
      this.sortValueOutgoing__();
    }
    return;
  }
  public function evaluateNodeIncoming__(): Number {
    var change: Boolean = false;
    var incoming: EdgeList = node.incoming;
    do {
      change = false;
      for (var i: int = 0; i < incoming.size__() - 1; i++) {
        if (incoming.getSourceIndex__I(i) > incoming.getSourceIndex__I(i + 1)) {
          var e: Edge = incoming.getEdge__I(i);
          incoming.set__ILjava_lang_Object_2(i, incoming.get__I(i + 1));
          incoming.set__ILjava_lang_Object_2(i + 1, e);
          change = true;
        }
      }
    } while (change);
    var n: int = incoming.size__();
    if (n == 0) {
      return node.index * prevRankSize / rankSize;
    }
    if (n % 2 == 1)
      return incoming.getSourceIndex__I(int(n / 2));
    var l: int = incoming.getSourceIndex__I(int(n / 2) - 1);
    var r: int = incoming.getSourceIndex__I(int(n / 2));
    if (progress >= 0.8 && n > 2) {
      var dl: int = l - incoming.getSourceIndex__I(0);
      var dr: int = incoming.getSourceIndex__I(n - 1) - r;
      if (dl < dr)
        return l;
      if (dl > dr)
        return r;
    }
    if (progress > 0.25 && progress < 0.75) {
      if (flipflop.nextBoolean__())
        return (l + l + r) / 3.0;
      else
        return (r + r + l) / 3.0;
    }
    return (l + r) / 2.0;
  }
  public function evaluateNodeOutgoing__(): Number {
    var change: Boolean = false;
    var outgoing: EdgeList = node.outgoing;
    do {
      change = false;
      for (var i: int = 0; i < outgoing.size__() - 1; i++) {
        if (outgoing.getTargetIndex__I(i) > outgoing.getTargetIndex__I(i + 1)) {
          var e: Edge = outgoing.getEdge__I(i);
          outgoing.set__ILjava_lang_Object_2(i, outgoing.get__I(i + 1));
          outgoing.set__ILjava_lang_Object_2(i + 1, e);
          change = true;
        }
      }
    } while (change);
    var n: int = outgoing.size__();
    if (n == 0)
      return node.index * prevRankSize / rankSize;
    if (n % 2 == 1)
      return outgoing.getTargetIndex__I(int(n / 2));
    var l: int = outgoing.getTargetIndex__I(int(n / 2) - 1);
    var r: int = outgoing.getTargetIndex__I(int(n / 2));
    if (progress >= 0.8 && n > 2) {
      var dl: int = l - outgoing.getTargetIndex__I(0);
      var dr: int = outgoing.getTargetIndex__I(n - 1) - r;
      if (dl < dr)
        return l;
      if (dl > dr)
        return r;
    }
    if (progress > 0.25 && progress < 0.75) {
      if (flipflop.nextBoolean__())
        return (l + l + r) / 3.0;
      else
        return (r + r + l) / 3.0;
    }
    return (l + r) / 2.0;
  }
  public function sortRankIncoming__Lorg_eclipse_draw2d_graph_DirectedGraph_2Lorg_eclipse_draw2d_graph_Rank_2ID(g_1: DirectedGraph, rank_1: Rank, row: int, progress_1: Number): void {
    this.currentRow = row;
    this.rank = rank_1;
    this.progress = progress_1;
    this.assignIncomingSortValues__();
    this.sort__();
    this.postSort__();
  }
  public function init__Lorg_eclipse_draw2d_graph_DirectedGraph_2(g_1: DirectedGraph): void {
    this.g = g_1;
    for (var i: int = 0; i < g_1.ranks.size__(); i++) {
      rank = g_1.ranks.getRank__I(i);
      Collections.sort__Ljava_util_List_2Ljava_util_Comparator_2(rank, new org.eclipse.draw2d.graph.RankSorter$1(this));
      this.postSort__();
    }
    return;
  }
  public function optimize__Lorg_eclipse_draw2d_graph_DirectedGraph_2(g_1: DirectedGraph): void {
  }
  public function postSort__(): void {
    rank.assignIndices__();
    return;
  }
  public function sort__(): void {
    var change: Boolean;
    do {
      change = false;
      for (var i: int = 0; i < rank.size__() - 1; i++)
        change = (change) ? (this.swap__I(i), true) : (this.swap__I(i));
      if (!change)
        break;
      change = false;
      for (var i_1: int = rank.size__() - 2; i_1 >= 0; i_1--)
        change = (change) ? (this.swap__I(i_1), true) : (this.swap__I(i_1));
    } while (change);
    return;
  }
  public function swap__I(i: int): Boolean {
    var left: Node = rank.getNode__I(i);
    var right: Node = rank.getNode__I(i + 1);
    if (GraphUtilities.isConstrained__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Node_2(left, right))
      return false;
    if (left.sortValue <= right.sortValue)
      return false;
    rank.set__ILjava_lang_Object_2(i, right);
    rank.set__ILjava_lang_Object_2(i + 1, left);
    return true;
  }
  public function sortRankOutgoing__Lorg_eclipse_draw2d_graph_DirectedGraph_2Lorg_eclipse_draw2d_graph_Rank_2ID(g_1: DirectedGraph, rank_1: Rank, row: int, progress_1: Number): void {
    this.currentRow = row;
    this.rank = rank_1;
    this.progress = progress_1;
    this.assignOutgoingSortValues__();
    this.sort__();
    this.postSort__();
  }
  public function sortValueIncoming__(): void {
    node.sortValue = this.evaluateNodeIncoming__();
    var value: Number = this.evaluateNodeOutgoing__();
    if (value < 0)
      value = node.index * nextRankSize / rankSize;
    node.sortValue += value * progress;
  }
  public function sortValueOutgoing__(): void {
    node.sortValue = this.evaluateNodeOutgoing__();
    var value: Number = this.evaluateNodeIncoming__();
    if (value < 0)
      value = node.index * nextRankSize / rankSize;
    node.sortValue += value * progress;
  }
}
}
