package org.eclipse.draw2d.graph {
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import java.lang.Arguments;
dynamic public class RouteEdges extends GraphVisitor {
  public override function revisit__Lorg_eclipse_draw2d_graph_DirectedGraph_2(g: DirectedGraph): void {
    for (var i: int = 0; i < g.edges.size__(); i++) {
      var edge: Edge = Edge(g.edges.get__I(i));
      edge.start = new Point(new Arguments(org.eclipse.draw2d.geometry.Point.Point__II, [edge.getSourceOffset__() + edge.source.x, edge.source.y + edge.source.height]));
      if (edge.source is SubgraphBoundary) {
        var boundary: SubgraphBoundary = SubgraphBoundary(edge.source);
        if (boundary.getParent__().head === boundary)
          edge.start.y = boundary.getParent__().y + boundary.getParent__().insets.top;
      }
      edge.end = new Point(new Arguments(org.eclipse.draw2d.geometry.Point.Point__II, [edge.getTargetOffset__() + edge.target.x, edge.target.y]));
      if (edge.vNodes !== null)
        RouteEdges.routeLongEdge__Lorg_eclipse_draw2d_graph_Edge_2Lorg_eclipse_draw2d_graph_DirectedGraph_2(edge, g);
      else {
        var list: PointList = new PointList(new Arguments(org.eclipse.draw2d.geometry.PointList.PointList__, []));
        list.addPoint__Lorg_eclipse_draw2d_geometry_Point_2(edge.start);
        list.addPoint__Lorg_eclipse_draw2d_geometry_Point_2(edge.end);
        edge.setPoints__Lorg_eclipse_draw2d_geometry_PointList_2(list);
      }
    }
    return;
  }
  public static function routeLongEdge__Lorg_eclipse_draw2d_graph_Edge_2Lorg_eclipse_draw2d_graph_DirectedGraph_2(edge: Edge, g: DirectedGraph): void {
    var router: ShortestPathRouter = new ShortestPathRouter();
    var path: Path = new Path(new Arguments(org.eclipse.draw2d.graph.Path.Path__Lorg_eclipse_draw2d_geometry_Point_2Lorg_eclipse_draw2d_geometry_Point_2, [edge.start, edge.end]));
    router.addPath__Lorg_eclipse_draw2d_graph_Path_2(path);
    var o: Rectangle;
    var padding: Insets;
    for (var i: int = 0; i < edge.vNodes.size__(); i++) {
      var node: VirtualNode = VirtualNode(edge.vNodes.get__I(i));
      var neighbor: Node;
      if (node.left !== null) {
        neighbor = node.left;
        o = new Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__IIII, [neighbor.x, neighbor.y, neighbor.width, neighbor.height]));
        padding = g.getPadding__Lorg_eclipse_draw2d_graph_Node_2(neighbor);
        o.width += padding.right + padding.left;
        o.width += (edge.getPadding__() * 2);
        o.x -= (padding.left + edge.getPadding__());
        o.union__Lorg_eclipse_draw2d_geometry_Point_2(o.getLocation__().translate__II(-100000, 2));
        router.addObstacle__Lorg_eclipse_draw2d_geometry_Rectangle_2(o);
      }
      if (node.right !== null) {
        neighbor = node.right;
        o = new Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__IIII, [neighbor.x, neighbor.y, neighbor.width, neighbor.height]));
        padding = g.getPadding__Lorg_eclipse_draw2d_graph_Node_2(neighbor);
        o.width += padding.right + padding.left;
        o.width += (edge.getPadding__() * 2);
        o.x -= (padding.left + edge.getPadding__());
        o.union__Lorg_eclipse_draw2d_geometry_Point_2(o.getLocation__().translate__II(100000, 2));
        router.addObstacle__Lorg_eclipse_draw2d_geometry_Rectangle_2(o);
      }
    }
    router.setSpacing__I(0);
    router.solve__();
    edge.setPoints__Lorg_eclipse_draw2d_geometry_PointList_2(path.getPoints__());
    return;
  }
}
}
