package org.eclipse.draw2d.graph {
import org.eclipse.draw2d.geometry.Geometry;
import org.eclipse.draw2d.geometry.Point;
import java.lang.System;
dynamic public class Segment {
  internal var start: Vertex;
  internal var end: Vertex;
  function Segment(start: Vertex, end: Vertex) {
    this.start = start;
    this.end = end;
    return;
  }
  public function cosine__Lorg_eclipse_draw2d_graph_Segment_2(otherSegment: Segment): Number {
    var cos: Number = (((start.x - end.x) * (otherSegment.end.x - otherSegment.start.x)) + ((start.y - end.y) * (otherSegment.end.y - otherSegment.start.y))) / (this.getLength__() * otherSegment.getLength__());
    var sin: Number = (((start.x - end.x) * (otherSegment.end.y - otherSegment.start.y)) - ((start.y - end.y) * (otherSegment.end.x - otherSegment.start.x)));
    if (sin < 0.0)
      return (1 + cos);
    return -(1 + cos);
  }
  public function crossProduct__Lorg_eclipse_draw2d_graph_Segment_2(otherSegment: Segment): Number {
    return (((start.x - end.x) * (otherSegment.end.y - end.y)) - ((start.y - end.y) * (otherSegment.end.x - end.x)));
  }
  private function getLength__(): Number {
    return (end.getDistance__Lorg_eclipse_draw2d_geometry_Point_2(start));
  }
  public function getSlope__(): Number {
    if (end.x - start.x >= 0)
      return (end.y - start.y);
    else
      return -(end.y - start.y);
  }
  public function intersects__IIII(sx: int, sy: int, tx: int, ty: int): Boolean {
    return Geometry.linesIntersect__IIIIIIII(start.x, start.y, end.x, end.y, sx, sy, tx, ty);
  }
  public function intersects__Lorg_eclipse_draw2d_geometry_Point_2Lorg_eclipse_draw2d_geometry_Point_2(s: Point, t: Point): Boolean {
    return this.intersects__IIII(s.x, s.y, t.x, t.y);
  }
  public function toString__(): String {
    return java.lang.System.stringValueOf(start) + "---" + java.lang.System.stringValueOf(end);
  }
}
}
