package org.eclipse.draw2d.graph {
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.PositionConstants;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.lang.Math__;
import java.lang.Double;
import java.util.Iterator;
import java.lang.Arguments;
dynamic public class ShortestPathRouter {
  public static const NUM_GROW_PASSES: int = 2;
  private var spacing: int = 4;
  private var growPassChangedObstacles: Boolean;
  private var orderedPaths: List;
  private var pathsToChildPaths: Map;
  private var stack: ShortestPathRouter$PathStack;
  private var subPaths: List;
  private var userObstacles: List;
  private var userPaths: List;
  private var workingPaths: List;
  public function ShortestPathRouter() {
    userPaths = new ArrayList(new Arguments(java.util.ArrayList.ArrayList__, []));
    workingPaths = new ArrayList(new Arguments(java.util.ArrayList.ArrayList__, []));
    pathsToChildPaths = new HashMap(new Arguments(java.util.HashMap.HashMap__, []));
    userObstacles = new ArrayList(new Arguments(java.util.ArrayList.ArrayList__, []));
    return;
  }
  public function addObstacle__Lorg_eclipse_draw2d_geometry_Rectangle_2(rect: Rectangle): Boolean {
    return this.internalAddObstacle__Lorg_eclipse_draw2d_graph_Obstacle_2(new Obstacle(rect, this));
  }
  public function addPath__Lorg_eclipse_draw2d_graph_Path_2(path: Path): void {
    userPaths.add__Ljava_lang_Object_2(path);
    workingPaths.add__Ljava_lang_Object_2(path);
  }
  private function bendPaths__(): void {
    for (var i: int = 0; i < orderedPaths.size__(); i++) {
      var path: Path = Path(orderedPaths.get__I(i));
      var segment: Segment = null;
      path.points.addPoint__Lorg_eclipse_draw2d_geometry_Point_2(new Point(new Arguments(org.eclipse.draw2d.geometry.Point.Point__II, [path.start.x, path.start.y])));
      for (var v: int = 0; v < path.grownSegments.size__(); v++) {
        segment = Segment(path.grownSegments.get__I(v));
        var vertex: Vertex = segment.end;
        if (vertex !== null && v < path.grownSegments.size__() - 1) {
          if (vertex.type == 1) {
            vertex.count++;
            path.points.addPoint__Lorg_eclipse_draw2d_geometry_Point_2(vertex.bend__I(vertex.count));
          } else {
            path.points.addPoint__Lorg_eclipse_draw2d_geometry_Point_2(vertex.bend__I(vertex.totalCount));
            vertex.totalCount--;
          }
        }
      }
      path.points.addPoint__Lorg_eclipse_draw2d_geometry_Point_2(new Point(new Arguments(org.eclipse.draw2d.geometry.Point.Point__II, [path.end.x, path.end.y])));
    }
    return;
  }
  private function checkVertexForIntersections__Lorg_eclipse_draw2d_graph_Vertex_2(vertex: Vertex): void {
    if (vertex.nearestObstacle != 0 || vertex.nearestObstacleChecked)
      return;
    var sideLength: int;
    var x: int;
    var y: int;
    sideLength = 2 * (vertex.totalCount * this.getSpacing__()) + 1;
    if ((vertex.positionOnObstacle & 1) > 0)
      y = vertex.y - sideLength;
    else
      y = vertex.y;
    if ((vertex.positionOnObstacle & 16) > 0)
      x = vertex.x;
    else
      x = vertex.x - sideLength;
    var r: Rectangle = new Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__IIII, [x, y, sideLength, sideLength]));
    var xDist: int;
    var yDist: int;
    for (var o: int = 0; o < userObstacles.size__(); o++) {
      var obs: Obstacle = Obstacle(userObstacles.get__I(o));
      if (obs !== vertex.obs && r.intersects__Lorg_eclipse_draw2d_geometry_Rectangle_2(obs)) {
        var pos: int = obs.getPosition__Lorg_eclipse_draw2d_geometry_Point_2(vertex);
        if (pos == 0)
          continue;
        if ((pos & 1) > 0)
          yDist = obs.y - vertex.y;
        else
          yDist = vertex.y - obs.bottom__() + 1;
        if ((pos & 16) > 0)
          xDist = vertex.x - obs.right__() + 1;
        else
          xDist = obs.x - vertex.x;
        if (Math__.max__II(xDist, yDist) < vertex.nearestObstacle || vertex.nearestObstacle == 0) {
          vertex.nearestObstacle = Math__.max__II(xDist, yDist);
          vertex.updateOffset__();
        }
      }
    }
    vertex.nearestObstacleChecked = true;
    return;
  }
  private function checkVertexIntersections__(): void {
    for (var i: int = 0; i < workingPaths.size__(); i++) {
      var path: Path = Path(workingPaths.get__I(i));
      for (var s: int = 0; s < path.segments.size__() - 1; s++) {
        var vertex: Vertex = (Segment(path.segments.get__I(s))).end;
        this.checkVertexForIntersections__Lorg_eclipse_draw2d_graph_Vertex_2(vertex);
      }
    }
    return;
  }
  private function cleanup__(): void {
    for (var i: int = 0; i < workingPaths.size__(); i++) {
      var path: Path = Path(workingPaths.get__I(i));
      path.cleanup__();
    }
    return;
  }
  private function countVertices__(): void {
    for (var i: int = 0; i < workingPaths.size__(); i++) {
      var path: Path = Path(workingPaths.get__I(i));
      for (var v: int = 0; v < path.segments.size__() - 1; v++)
        (Segment(path.segments.get__I(v))).end.totalCount++;
    }
    return;
  }
  private function dirtyPathsOn__Lorg_eclipse_draw2d_graph_Vertex_2(vertex: Vertex): Boolean {
    var paths: List = vertex.paths;
    if (paths !== null && paths.size__() != 0) {
      for (var i: int = 0; i < paths.size__(); i++)
        (Path(paths.get__I(i))).isDirty = true;
      return true;
    }
    return false;
  }
  private function getNearestVertex__Lorg_eclipse_draw2d_graph_Vertex_2Lorg_eclipse_draw2d_graph_Vertex_2Lorg_eclipse_draw2d_graph_Segment_2(v1: Vertex, v2: Vertex, segment: Segment): Vertex {
    if (segment.start.getDistance__Lorg_eclipse_draw2d_geometry_Point_2(v1) + segment.end.getDistance__Lorg_eclipse_draw2d_geometry_Point_2(v1) > segment.start.getDistance__Lorg_eclipse_draw2d_geometry_Point_2(v2) + segment.end.getDistance__Lorg_eclipse_draw2d_geometry_Point_2(v2))
      return v2;
    else
      return v1;
  }
  public function getSpacing__(): int {
    return spacing;
  }
  private function getSubpathForSplit__Lorg_eclipse_draw2d_graph_Path_2Lorg_eclipse_draw2d_graph_Segment_2(path: Path, segment: Segment): Path {
    var newPath: Path = path.getSubPath__Lorg_eclipse_draw2d_graph_Segment_2(segment);
    workingPaths.add__Ljava_lang_Object_2(newPath);
    subPaths.add__Ljava_lang_Object_2(newPath);
    return newPath;
  }
  private function growObstacles__(): void {
    growPassChangedObstacles = false;
    for (var i: int = 0; i < 2; i++) {
      if (i == 0 || growPassChangedObstacles)
        this.growObstaclesPass__();
    }
    return;
  }
  private function growObstaclesPass__(): void {
    for (var i: int = 0; i < userObstacles.size__(); i++)
      (Obstacle(userObstacles.get__I(i))).growVertices__();
    for (var i_1: int = 0; i_1 < workingPaths.size__(); i_1++) {
      var path: Path = Path(workingPaths.get__I(i_1));
      for (var e: int = 0; e < path.excludedObstacles.size__(); e++)
        (Obstacle(path.excludedObstacles.get__I(e))).exclude = true;
      if (path.grownSegments.size__() == 0) {
        for (var s: int = 0; s < path.segments.size__(); s++)
          this.testOffsetSegmentForIntersections__Lorg_eclipse_draw2d_graph_Segment_2ILorg_eclipse_draw2d_graph_Path_2(Segment(path.segments.get__I(s)), -1, path);
      } else {
        var counter: int = 0;
        var currentSegments: List = new ArrayList(new Arguments(java.util.ArrayList.ArrayList__Ljava_util_Collection_2, [path.grownSegments]));
        for (var s_1: int = 0; s_1 < currentSegments.size__(); s_1++)
          counter += this.testOffsetSegmentForIntersections__Lorg_eclipse_draw2d_graph_Segment_2ILorg_eclipse_draw2d_graph_Path_2(Segment(currentSegments.get__I(s_1)), s_1 + counter, path);
      }
      for (var e_1: int = 0; e_1 < path.excludedObstacles.size__(); e_1++)
        (Obstacle(path.excludedObstacles.get__I(e_1))).exclude = false;
    }
    for (var i_2: int = 0; i_2 < userObstacles.size__(); i_2++)
      (Obstacle(userObstacles.get__I(i_2))).shrinkVertices__();
    return;
  }
  private function internalAddObstacle__Lorg_eclipse_draw2d_graph_Obstacle_2(obs: Obstacle): Boolean {
    userObstacles.add__Ljava_lang_Object_2(obs);
    return this.testAndDirtyPaths__Lorg_eclipse_draw2d_graph_Obstacle_2(obs);
  }
  private function internalRemoveObstacle__Lorg_eclipse_draw2d_geometry_Rectangle_2(rect: Rectangle): Boolean {
    var obs: Obstacle = null;
    var index: int = -1;
    for (var i: int = 0; i < userObstacles.size__(); i++) {
      obs = Obstacle(userObstacles.get__I(i));
      if (obs.equals__Ljava_lang_Object_2(rect)) {
        index = i;
        break;
      }
    }
    userObstacles.remove__I(index);
    var result: Boolean = false;
    result = (result) ? (this.dirtyPathsOn__Lorg_eclipse_draw2d_graph_Vertex_2(obs.bottomLeft), true) : (this.dirtyPathsOn__Lorg_eclipse_draw2d_graph_Vertex_2(obs.bottomLeft));
    result = (result) ? (this.dirtyPathsOn__Lorg_eclipse_draw2d_graph_Vertex_2(obs.topLeft), true) : (this.dirtyPathsOn__Lorg_eclipse_draw2d_graph_Vertex_2(obs.topLeft));
    result = (result) ? (this.dirtyPathsOn__Lorg_eclipse_draw2d_graph_Vertex_2(obs.bottomRight), true) : (this.dirtyPathsOn__Lorg_eclipse_draw2d_graph_Vertex_2(obs.bottomRight));
    result = (result) ? (this.dirtyPathsOn__Lorg_eclipse_draw2d_graph_Vertex_2(obs.topRight), true) : (this.dirtyPathsOn__Lorg_eclipse_draw2d_graph_Vertex_2(obs.topRight));
    for (var p: int = 0; p < workingPaths.size__(); p++) {
      var path: Path = Path(workingPaths.get__I(p));
      if (path.isDirty)
        continue;
      if (path.isObstacleVisible__Lorg_eclipse_draw2d_graph_Obstacle_2(obs))
        path.isDirty = result = true;
    }
    return result;
  }
  private function labelPath__Lorg_eclipse_draw2d_graph_Path_2(path: Path): void {
    var segment: Segment = null;
    var nextSegment: Segment = null;
    var vertex: Vertex = null;
    var agree: Boolean = false;
    for (var v: int = 0; v < path.grownSegments.size__() - 1; v++) {
      segment = Segment(path.grownSegments.get__I(v));
      nextSegment = Segment(path.grownSegments.get__I(v + 1));
      vertex = segment.end;
      var crossProduct: Number = segment.crossProduct__Lorg_eclipse_draw2d_graph_Segment_2(new Segment(vertex, vertex.obs.center));
      if (vertex.type == 0) {
        this.labelVertex__Lorg_eclipse_draw2d_graph_Segment_2JLorg_eclipse_draw2d_graph_Path_2(segment, crossProduct, path);
      } else if (!path.isInverted && ((crossProduct > 0 && vertex.type == 2) || (crossProduct < 0 && vertex.type == 1))) {
        if (agree) {
          stack.push__Lorg_eclipse_draw2d_graph_Path_2(this.getSubpathForSplit__Lorg_eclipse_draw2d_graph_Path_2Lorg_eclipse_draw2d_graph_Segment_2(path, segment));
          return;
        } else {
          path.isInverted = true;
          path.invertPriorVertices__Lorg_eclipse_draw2d_graph_Segment_2(segment);
        }
      } else if (path.isInverted && ((crossProduct < 0 && vertex.type == 2) || (crossProduct > 0 && vertex.type == 1))) {
        stack.push__Lorg_eclipse_draw2d_graph_Path_2(this.getSubpathForSplit__Lorg_eclipse_draw2d_graph_Path_2Lorg_eclipse_draw2d_graph_Segment_2(path, segment));
        return;
      } else
        agree = true;
      if (vertex.paths !== null) {
        for (var i: int = 0; i < vertex.paths.size__(); i++) {
          var nextPath: Path = Path(vertex.paths.get__I(i));
          if (!nextPath.isMarked) {
            nextPath.isMarked = true;
            stack.push__Lorg_eclipse_draw2d_graph_Path_2(nextPath);
          }
        }
      }
      vertex.addPath__Lorg_eclipse_draw2d_graph_Path_2Lorg_eclipse_draw2d_graph_Segment_2Lorg_eclipse_draw2d_graph_Segment_2(path, segment, nextSegment);
    }
    return;
  }
  private function labelPaths__(): void {
    var path: Path = null;
    for (var i: int = 0; i < workingPaths.size__(); i++) {
      path = Path(workingPaths.get__I(i));
      stack.push__Lorg_eclipse_draw2d_graph_Path_2(path);
    }
    while (!stack.isEmpty__()) {
      path = stack.pop__();
      if (!path.isMarked) {
        path.isMarked = true;
        this.labelPath__Lorg_eclipse_draw2d_graph_Path_2(path);
      }
    }
    for (var i_1: int = 0; i_1 < workingPaths.size__(); i_1++) {
      path = Path(workingPaths.get__I(i_1));
      path.isMarked = false;
    }
    return;
  }
  private function labelVertex__Lorg_eclipse_draw2d_graph_Segment_2JLorg_eclipse_draw2d_graph_Path_2(segment: Segment, crossProduct: Number, path: Path): void {
    if (crossProduct > 0) {
      if (path.isInverted)
        segment.end.type = 2;
      else
        segment.end.type = 1;
    } else if (crossProduct < 0) {
      if (path.isInverted)
        segment.end.type = 1;
      else
        segment.end.type = 2;
    } else if (segment.start.type != 0)
      segment.end.type = segment.start.type;
    else
      segment.end.type = 1;
    return;
  }
  private function orderPath__Lorg_eclipse_draw2d_graph_Path_2(path: Path): void {
    if (path.isMarked)
      return;
    path.isMarked = true;
    var segment: Segment = null;
    var vertex: Vertex = null;
    for (var v: int = 0; v < path.grownSegments.size__() - 1; v++) {
      segment = Segment(path.grownSegments.get__I(v));
      vertex = segment.end;
      var thisAngle: Number = (Double(vertex.cachedCosines.get__Ljava_lang_Object_2(path))).doubleValue__();
      if (path.isInverted)
        thisAngle = -thisAngle;
      for (var i: int = 0; i < vertex.paths.size__(); i++) {
        var vPath: Path = Path(vertex.paths.get__I(i));
        if (!vPath.isMarked) {
          var otherAngle: Number = (Double(vertex.cachedCosines.get__Ljava_lang_Object_2(vPath))).doubleValue__();
          if (vPath.isInverted)
            otherAngle = -otherAngle;
          if (otherAngle < thisAngle)
            this.orderPath__Lorg_eclipse_draw2d_graph_Path_2(vPath);
        }
      }
    }
    orderedPaths.add__Ljava_lang_Object_2(path);
    return;
  }
  private function orderPaths__(): void {
    for (var i: int = 0; i < workingPaths.size__(); i++) {
      var path: Path = Path(workingPaths.get__I(i));
      this.orderPath__Lorg_eclipse_draw2d_graph_Path_2(path);
    }
    return;
  }
  private function recombineChildrenPaths__(): void {
    var keyItr: Iterator = Iterator(pathsToChildPaths.keySet__().iterator__());
    while (keyItr.hasNext__()) {
      var path: Path = Path(keyItr.next__());
      path.fullReset__();
      var childPaths: List = List(pathsToChildPaths.get__Ljava_lang_Object_2(path));
      var childPath: Path = null;
      for (var i: int = 0; i < childPaths.size__(); i++) {
        childPath = Path(childPaths.get__I(i));
        path.points.addAll__Lorg_eclipse_draw2d_geometry_PointList_2(childPath.getPoints__());
        path.points.removePoint__I(path.points.size__() - 1);
        path.segments.addAll__Ljava_util_Collection_2(childPath.segments);
        path.visibleObstacles.addAll__Ljava_util_Collection_2(childPath.visibleObstacles);
      }
      path.points.addPoint__Lorg_eclipse_draw2d_geometry_Point_2(childPath.points.getLastPoint__());
    }
    return;
  }
  private function recombineSubpaths__(): void {
    for (var p: int = 0; p < orderedPaths.size__(); p++) {
      var path: Path = Path(orderedPaths.get__I(p));
      path.reconnectSubPaths__();
    }
    orderedPaths.removeAll__Ljava_util_Collection_2(subPaths);
    workingPaths.removeAll__Ljava_util_Collection_2(subPaths);
    subPaths = null;
    return;
  }
  public function removeObstacle__Lorg_eclipse_draw2d_geometry_Rectangle_2(rect: Rectangle): Boolean {
    return this.internalRemoveObstacle__Lorg_eclipse_draw2d_geometry_Rectangle_2(rect);
  }
  public function removePath__Lorg_eclipse_draw2d_graph_Path_2(path: Path): Boolean {
    userPaths.remove__Ljava_lang_Object_2(path);
    var children: List = List(pathsToChildPaths.get__Ljava_lang_Object_2(path));
    if (children === null)
      workingPaths.remove__Ljava_lang_Object_2(path);
    else
      workingPaths.removeAll__Ljava_util_Collection_2(children);
    return true;
  }
  private function resetObstacleExclusions__(): void {
    for (var i: int = 0; i < userObstacles.size__(); i++)
      (Obstacle(userObstacles.get__I(i))).exclude = false;
  }
  private function resetVertices__(): void {
    for (var i: int = 0; i < userObstacles.size__(); i++) {
      var obs: Obstacle = Obstacle(userObstacles.get__I(i));
      obs.reset__();
    }
    for (var i_1: int = 0; i_1 < workingPaths.size__(); i_1++) {
      var path: Path = Path(workingPaths.get__I(i_1));
      path.start.fullReset__();
      path.end.fullReset__();
    }
    return;
  }
  public function setSpacing__I(spacing_1: int): void {
    this.spacing = spacing_1;
    return;
  }
  public function solve__(): List {
    this.solveDirtyPaths__();
    this.countVertices__();
    this.checkVertexIntersections__();
    this.growObstacles__();
    subPaths = new ArrayList(new Arguments(java.util.ArrayList.ArrayList__, []));
    stack = new ShortestPathRouter$PathStack();
    this.labelPaths__();
    stack = null;
    orderedPaths = new ArrayList(new Arguments(java.util.ArrayList.ArrayList__, []));
    this.orderPaths__();
    this.bendPaths__();
    this.recombineSubpaths__();
    orderedPaths = null;
    subPaths = null;
    this.recombineChildrenPaths__();
    this.cleanup__();
    return Collections.unmodifiableList__Ljava_util_List_2(userPaths);
  }
  private function solveDirtyPaths__(): int {
    var numSolved: int = 0;
    for (var i: int = 0; i < userPaths.size__(); i++) {
      var path: Path = Path(userPaths.get__I(i));
      if (!path.isDirty)
        continue;
      var children: List = List(pathsToChildPaths.get__Ljava_lang_Object_2(path));
      var prevCount: int = 1;
      var newCount: int = 1;
      if (children === null)
        children = Collections.EMPTY_LIST;
      else
        prevCount = children.size__();
      if (path.getBendPoints__() !== null)
        newCount = path.getBendPoints__().size__() + 1;
      if (prevCount != newCount)
        children = this.regenerateChildPaths__Lorg_eclipse_draw2d_graph_Path_2Ljava_util_List_2II(path, children, prevCount, newCount);
      this.refreshChildrenEndpoints__Lorg_eclipse_draw2d_graph_Path_2Ljava_util_List_2(path, children);
    }
    for (var i_1: int = 0; i_1 < workingPaths.size__(); i_1++) {
      var path_1: Path = Path(workingPaths.get__I(i_1));
      path_1.refreshExcludedObstacles__Ljava_util_List_2(userObstacles);
      if (!path_1.isDirty) {
        path_1.resetPartial__();
        continue;
      }
      numSolved++;
      path_1.fullReset__();
      var pathFoundCheck: Boolean = path_1.generateShortestPath__Ljava_util_List_2(userObstacles);
      if (!pathFoundCheck || path_1.end.cost > path_1.threshold) {
        this.resetVertices__();
        path_1.fullReset__();
        path_1.threshold = 0;
        pathFoundCheck = path_1.generateShortestPath__Ljava_util_List_2(userObstacles);
      }
      this.resetVertices__();
    }
    this.resetObstacleExclusions__();
    if (numSolved == 0)
      this.resetVertices__();
    return numSolved;
  }
  private function refreshChildrenEndpoints__Lorg_eclipse_draw2d_graph_Path_2Ljava_util_List_2(path: Path, children: List): void {
    var previous: Point = path.getStartPoint__();
    var next: Point;
    var bendpoints: PointList = path.getBendPoints__();
    var child: Path;
    for (var i: int = 0; i < children.size__(); i++) {
      if (i < bendpoints.size__())
        next = bendpoints.getPoint__I(i);
      else
        next = path.getEndPoint__();
      child = Path(children.get__I(i));
      child.setStartPoint__Lorg_eclipse_draw2d_geometry_Point_2(previous);
      child.setEndPoint__Lorg_eclipse_draw2d_geometry_Point_2(next);
      previous = next;
    }
    return;
  }
  private function regenerateChildPaths__Lorg_eclipse_draw2d_graph_Path_2Ljava_util_List_2II(path: Path, children: List, currentSize: int, newSize: int): List {
    if (currentSize == 1) {
      workingPaths.remove__Ljava_lang_Object_2(path);
      currentSize = 0;
      children = new ArrayList(new Arguments(java.util.ArrayList.ArrayList__I, [newSize]));
      pathsToChildPaths.put__Ljava_lang_Object_2Ljava_lang_Object_2(path, children);
    } else if (newSize == 1) {
      workingPaths.removeAll__Ljava_util_Collection_2(children);
      workingPaths.add__Ljava_lang_Object_2(path);
      pathsToChildPaths.remove__Ljava_lang_Object_2(path);
      return Collections.EMPTY_LIST;
    }
    while (currentSize < newSize) {
      var child: Path = new Path(new Arguments(org.eclipse.draw2d.graph.Path.Path__, []));
      workingPaths.add__Ljava_lang_Object_2(child);
      children.add__Ljava_lang_Object_2(child);
      currentSize++;
    }
    while (currentSize > newSize) {
      var child_1: Path = Path(children.remove__I(children.size__() - 1));
      workingPaths.remove__Ljava_lang_Object_2(child_1);
      currentSize--;
    }
    return children;
  }
  private function testOffsetSegmentForIntersections__Lorg_eclipse_draw2d_graph_Segment_2ILorg_eclipse_draw2d_graph_Path_2(segment: Segment, index: int, path: Path): int {
    for (var i: int = 0; i < userObstacles.size__(); i++) {
      var obs: Obstacle = Obstacle(userObstacles.get__I(i));
      if (segment.end.obs === obs || segment.start.obs === obs || obs.exclude)
        continue;
      var vertex: Vertex = null;
      var offset: int = this.getSpacing__();
      if (segment.getSlope__() < 0) {
        if (segment.intersects__IIII(obs.topLeft.x - offset, obs.topLeft.y - offset, obs.bottomRight.x + offset, obs.bottomRight.y + offset))
          vertex = this.getNearestVertex__Lorg_eclipse_draw2d_graph_Vertex_2Lorg_eclipse_draw2d_graph_Vertex_2Lorg_eclipse_draw2d_graph_Segment_2(obs.topLeft, obs.bottomRight, segment);
        else if (segment.intersects__IIII(obs.bottomLeft.x - offset, obs.bottomLeft.y + offset, obs.topRight.x + offset, obs.topRight.y - offset))
          vertex = this.getNearestVertex__Lorg_eclipse_draw2d_graph_Vertex_2Lorg_eclipse_draw2d_graph_Vertex_2Lorg_eclipse_draw2d_graph_Segment_2(obs.bottomLeft, obs.topRight, segment);
      } else {
        if (segment.intersects__IIII(obs.bottomLeft.x - offset, obs.bottomLeft.y + offset, obs.topRight.x + offset, obs.topRight.y - offset))
          vertex = this.getNearestVertex__Lorg_eclipse_draw2d_graph_Vertex_2Lorg_eclipse_draw2d_graph_Vertex_2Lorg_eclipse_draw2d_graph_Segment_2(obs.bottomLeft, obs.topRight, segment);
        else if (segment.intersects__IIII(obs.topLeft.x - offset, obs.topLeft.y - offset, obs.bottomRight.x + offset, obs.bottomRight.y + offset))
          vertex = this.getNearestVertex__Lorg_eclipse_draw2d_graph_Vertex_2Lorg_eclipse_draw2d_graph_Vertex_2Lorg_eclipse_draw2d_graph_Segment_2(obs.topLeft, obs.bottomRight, segment);
      }
      if (vertex !== null) {
        var vRect: Rectangle = vertex.getDeformedRectangle__I(offset);
        if (segment.end.obs !== null) {
          var endRect: Rectangle = segment.end.getDeformedRectangle__I(offset);
          if (vRect.intersects__Lorg_eclipse_draw2d_geometry_Rectangle_2(endRect))
            continue;
        }
        if (segment.start.obs !== null) {
          var startRect: Rectangle = segment.start.getDeformedRectangle__I(offset);
          if (vRect.intersects__Lorg_eclipse_draw2d_geometry_Rectangle_2(startRect))
            continue;
        }
        var newSegmentStart: Segment = new Segment(segment.start, vertex);
        var newSegmentEnd: Segment = new Segment(vertex, segment.end);
        vertex.totalCount++;
        vertex.nearestObstacleChecked = false;
        vertex.shrink__();
        this.checkVertexForIntersections__Lorg_eclipse_draw2d_graph_Vertex_2(vertex);
        vertex.grow__();
        if (vertex.nearestObstacle != 0)
          vertex.updateOffset__();
        growPassChangedObstacles = true;
        if (index != -1) {
          path.grownSegments.remove__Ljava_lang_Object_2(segment);
          path.grownSegments.add__ILjava_lang_Object_2(index, newSegmentStart);
          path.grownSegments.add__ILjava_lang_Object_2(index + 1, newSegmentEnd);
        } else {
          path.grownSegments.add__Ljava_lang_Object_2(newSegmentStart);
          path.grownSegments.add__Ljava_lang_Object_2(newSegmentEnd);
        }
        return 1;
      }
    }
    if (index == -1)
      path.grownSegments.add__Ljava_lang_Object_2(segment);
    return 0;
  }
  private function testAndDirtyPaths__Lorg_eclipse_draw2d_graph_Obstacle_2(obs: Obstacle): Boolean {
    var result: Boolean = false;
    for (var i: int = 0; i < workingPaths.size__(); i++) {
      var path: Path = Path(workingPaths.get__I(i));
      result = (result) ? (path.testAndSet__Lorg_eclipse_draw2d_graph_Obstacle_2(obs), true) : (path.testAndSet__Lorg_eclipse_draw2d_graph_Obstacle_2(obs));
    }
    return result;
  }
  public function updateObstacle__Lorg_eclipse_draw2d_geometry_Rectangle_2Lorg_eclipse_draw2d_geometry_Rectangle_2(oldBounds: Rectangle, newBounds: Rectangle): Boolean {
    var result: Boolean = this.internalRemoveObstacle__Lorg_eclipse_draw2d_geometry_Rectangle_2(oldBounds);
    result = (result) ? (this.addObstacle__Lorg_eclipse_draw2d_geometry_Rectangle_2(newBounds), true) : (this.addObstacle__Lorg_eclipse_draw2d_geometry_Rectangle_2(newBounds));
    return result;
  }
}
}
