package org.eclipse.draw2d.graph {
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Set;
import java.util.HashSet;
import java.util.List;
import java.util.ArrayList;
import java.util.Iterator;
import java.lang.Double;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class SortSubgraphs extends GraphVisitor {
  internal var g: CompoundDirectedGraph;
  internal var nestingTrees: JavaArray;
  internal var orderingGraphEdges: Set = new HashSet(new Arguments(java.util.HashSet.HashSet__, []));
  internal var orderingGraphNodes: Set = new HashSet(new Arguments(java.util.HashSet.HashSet__, []));
  internal var pair: NodePair = new NodePair(new Arguments(org.eclipse.draw2d.graph.NodePair.NodePair__, []));
  private function breakSubgraphCycles__(): void {
    var noLefts: List = new ArrayList(new Arguments(java.util.ArrayList.ArrayList__, []));
    var index: int = 1;
    for (var iter: Iterator = Iterator(orderingGraphNodes.iterator__()); iter.hasNext__();) {
      var node: Node = Node(iter.next__());
      if (node.x == 0)
        this.sortedInsert__Ljava_util_List_2Lorg_eclipse_draw2d_graph_Node_2(noLefts, node);
    }
    var cycleRoot: Node;
    do {
      while (noLefts.size__() > 0) {
        var node_1: Node = Node(noLefts.remove__I(noLefts.size__() - 1));
        node_1.sortValue = index++;
        orderingGraphNodes.remove__Ljava_lang_Object_2(node_1);
        var rightOf: NodeList = this.rightOf__Lorg_eclipse_draw2d_graph_Node_2(node_1);
        if (rightOf === null)
          continue;
        for (var i: int = 0; i < rightOf.size__(); i++) {
          var right: Node = rightOf.getNode__I(i);
          right.x--;
          if (right.x == 0)
            this.sortedInsert__Ljava_util_List_2Lorg_eclipse_draw2d_graph_Node_2(noLefts, right);
        }
      }
      cycleRoot = null;
      var min: Number = -1;
      for (var iter_1: Iterator = Iterator(orderingGraphNodes.iterator__()); iter_1.hasNext__();) {
        var node_2: Node = Node(iter_1.next__());
        if (node_2.sortValue < min) {
          cycleRoot = node_2;
          min = node_2.sortValue;
        }
      }
      if (cycleRoot !== null) {
        this.sortedInsert__Ljava_util_List_2Lorg_eclipse_draw2d_graph_Node_2(noLefts, cycleRoot);
        cycleRoot.x = -1;
      }
    } while (cycleRoot !== null);
    return;
  }
  private function buildSubgraphOrderingGraph__(): void {
    var ranks: RankList = g.ranks;
    nestingTrees = new JavaArray("[Lorg/eclipse/draw2d/graph/NestingTree;").lengths(ranks.size__());
    for (var r: int = 0; r < ranks.size__(); r++) {
      var entry: NestingTree = NestingTree.buildNestingTreeForRank__Lorg_eclipse_draw2d_graph_Rank_2(ranks.getRank__I(r));
      nestingTrees[r] = entry;
      entry.calculateSortValues__();
      entry.recursiveSort__Z(false);
    }
    for (var i: int = 0; i < nestingTrees.length; i++) {
      var entry_1: NestingTree = nestingTrees[i];
      this.buildSubgraphOrderingGraph__Lorg_eclipse_draw2d_graph_NestingTree_2(entry_1);
    }
    return;
  }
  private function buildSubgraphOrderingGraph__Lorg_eclipse_draw2d_graph_NestingTree_2(entry: NestingTree): void {
    var pair_1: NodePair = new NodePair(new Arguments(org.eclipse.draw2d.graph.NodePair.NodePair__, []));
    if (entry.isLeaf)
      return;
    for (var i: int = 0; i < entry.contents.size__(); i++) {
      var right: Object = entry.contents.get__I(i);
      if (right is Node)
        pair_1.n2 = Node(right);
      else {
        pair_1.n2 = (NestingTree(right)).subgraph;
        this.buildSubgraphOrderingGraph__Lorg_eclipse_draw2d_graph_NestingTree_2(NestingTree(right));
      }
      if (pair_1.n1 !== null && !orderingGraphEdges.contains__Ljava_lang_Object_2(pair_1)) {
        orderingGraphEdges.add__Ljava_lang_Object_2(pair_1);
        this.leftToRight__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Node_2(pair_1.n1, pair_1.n2);
        orderingGraphNodes.add__Ljava_lang_Object_2(pair_1.n1);
        orderingGraphNodes.add__Ljava_lang_Object_2(pair_1.n2);
        pair_1.n2.x++;
        pair_1 = new NodePair(new Arguments(org.eclipse.draw2d.graph.NodePair.NodePair__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Node_2, [pair_1.n2, null]));
      } else {
        pair_1.n1 = pair_1.n2;
      }
    }
    return;
  }
  private function calculateSortValues__(): void {
    var ranks: RankList = g.ranks;
    g.subgraphs.resetSortValues__();
    g.subgraphs.resetIndices__();
    for (var r: int = 0; r < ranks.size__(); r++) {
      var rank: Rank = ranks.getRank__I(r);
      for (var j: int = 0; j < rank.count__(); j++) {
        var node: Node = rank.getNode__I(j);
        node.sortValue = node.index;
        var parent: Subgraph = node.getParent__();
        while (parent !== null) {
          parent.sortValue += node.sortValue;
          parent.index++;
          parent = parent.getParent__();
        }
      }
    }
    for (var i: int = 0; i < g.subgraphs.size__(); i++) {
      var subgraph: Subgraph = Subgraph(g.subgraphs.get__I(i));
      subgraph.sortValue /= subgraph.index;
    }
    return;
  }
  private function repopulateRanks__(): void {
    for (var i: int = 0; i < nestingTrees.length; i++) {
      var rank: Rank = g.ranks.getRank__I(i);
      rank.clear__();
      nestingTrees[i].repopulateRank__Lorg_eclipse_draw2d_graph_Rank_2(rank);
    }
    return;
  }
  private function rightOf__Lorg_eclipse_draw2d_graph_Node_2(left: Node): NodeList {
    return NodeList(left.workingData[0]);
  }
  private function leftToRight__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Node_2(left: Node, right: Node): void {
    this.rightOf__Lorg_eclipse_draw2d_graph_Node_2(left).add__Ljava_lang_Object_2(right);
  }
  public function sortedInsert__Ljava_util_List_2Lorg_eclipse_draw2d_graph_Node_2(list: List, node: Node): void {
    var insert: int = 0;
    while (insert < list.size__() && (Node(list.get__I(insert))).sortValue > node.sortValue)
      insert++;
    list.add__ILjava_lang_Object_2(insert, node);
  }
  private function topologicalSort__(): void {
    for (var i: int = 0; i < nestingTrees.length; i++) {
      nestingTrees[i].getSortValueFromSubgraph__();
      nestingTrees[i].recursiveSort__Z(false);
    }
    return;
  }
  public function init__(): void {
    for (var r: int = 0; r < g.ranks.size__(); r++) {
      var rank: Rank = g.ranks.getRank__I(r);
      for (var i: int = 0; i < rank.count__(); i++) {
        var n: Node = Node(rank.get__I(i));
        n.workingData[0] = new NodeList(new Arguments(org.eclipse.draw2d.graph.NodeList.NodeList__, []));
      }
    }
    for (var i_1: int = 0; i_1 < g.subgraphs.size__(); i_1++) {
      var s: Subgraph = Subgraph(g.subgraphs.get__I(i_1));
      s.workingData[0] = new NodeList(new Arguments(org.eclipse.draw2d.graph.NodeList.NodeList__, []));
    }
    return;
  }
  public override function visit__Lorg_eclipse_draw2d_graph_DirectedGraph_2(dg: DirectedGraph): void {
    g = CompoundDirectedGraph(dg);
    this.init__();
    this.buildSubgraphOrderingGraph__();
    this.calculateSortValues__();
    this.breakSubgraphCycles__();
    this.topologicalSort__();
    this.repopulateRanks__();
    return;
  }
}
}
