package org.eclipse.draw2d.graph {
import org.eclipse.draw2d.geometry.Insets;
import java.lang.Arguments;
import java.lang.System;
dynamic public class SubgraphBoundary extends Node {
  public static const TOP: int = 0;
  public static const LEFT: int = 1;
  public static const BOTTOM: int = 2;
  public static const RIGHT: int = 3;
  public function SubgraphBoundary(s: Subgraph, p: Insets, side: int) {
    super(new Arguments(org.eclipse.draw2d.graph.Node.Node__Ljava_lang_Object_2Lorg_eclipse_draw2d_graph_Subgraph_2, [null, s]));
    this.width = s.width;
    this.height = s.height;
    this.padding = new Insets(new Arguments(org.eclipse.draw2d.geometry.Insets.Insets__, []));
    switch (side) {
      case 1 :
        width = s.insets.left;
        y = s.y;
        padding.left = p.left;
        padding.right = s.innerPadding.left;
        padding.top = padding.bottom = 0;
        this.setParent__Lorg_eclipse_draw2d_graph_Subgraph_2(s.getParent__());
        data = "left(" + java.lang.System.stringValueOf(s) + ")";
        break;
      case 3 :
        width = s.insets.right;
        y = s.y;
        padding.right = p.right;
        padding.left = s.innerPadding.right;
        padding.top = padding.bottom = 0;
        this.setParent__Lorg_eclipse_draw2d_graph_Subgraph_2(s.getParent__());
        data = "right(" + java.lang.System.stringValueOf(s) + ")";
        break;
      case 0 :
        height = s.insets.top;
        width = 5;
        padding.top = p.top;
        padding.bottom = s.innerPadding.top;
        padding.left = padding.right = 0;
        data = "top(" + java.lang.System.stringValueOf(s) + ")";
        break;
      case 2 :
        height = s.insets.bottom;
        width = 5;
        padding.top = s.innerPadding.bottom;
        padding.bottom = p.bottom;
        padding.left = padding.right = 0;
        data = "bottom(" + java.lang.System.stringValueOf(s) + ")";
        break;
    }
    return;
  }
}
}
