package org.eclipse.draw2d.graph {
import java.lang.System;
import java.lang.RuntimeException;
import java.lang.Integer;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class TightSpanningTreeSolver extends SpanningTreeVisitor {
  public var graph: DirectedGraph;
  public var candidates: TightSpanningTreeSolver$CandidateList = new TightSpanningTreeSolver$CandidateList();
  public var members: NodeList = new NodeList(new Arguments(org.eclipse.draw2d.graph.NodeList.NodeList__, []));
  public override function visit__Lorg_eclipse_draw2d_graph_DirectedGraph_2(graph_1: DirectedGraph): void {
    this.graph = graph_1;
    this.init__();
    this.solve__();
  }
  public function addEdge__Lorg_eclipse_draw2d_graph_Edge_2(edge: Edge): Node {
    var delta: int = edge.getSlack__();
    edge.tree = true;
    var node: Node;
    if (edge.target.flag) {
      delta = -delta;
      node = edge.source;
      this.setParentEdge__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Edge_2(node, edge);
      this.getSpanningTreeChildren__Lorg_eclipse_draw2d_graph_Node_2(edge.target).add__Ljava_lang_Object_2(edge);
    } else {
      node = edge.target;
      this.setParentEdge__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Edge_2(node, edge);
      this.getSpanningTreeChildren__Lorg_eclipse_draw2d_graph_Node_2(edge.source).add__Ljava_lang_Object_2(edge);
    }
    members.adjustRank__I(delta);
    this.addNode__Lorg_eclipse_draw2d_graph_Node_2(node);
    return node;
  }
  private function isNodeReachable__Lorg_eclipse_draw2d_graph_Node_2(node: Node): Boolean {
    return node.flag;
  }
  private function setNodeReachable__Lorg_eclipse_draw2d_graph_Node_2(node: Node): void {
    node.flag = true;
  }
  private function isCandidate__Lorg_eclipse_draw2d_graph_Edge_2(e: Edge): Boolean {
    return e.flag;
  }
  private function setCandidate__Lorg_eclipse_draw2d_graph_Edge_2(e: Edge): void {
    e.flag = true;
  }
  public function addNode__Lorg_eclipse_draw2d_graph_Node_2(node: Node): void {
    this.setNodeReachable__Lorg_eclipse_draw2d_graph_Node_2(node);
    var list: EdgeList = node.incoming;
    var e: Edge;
    for (var i: int = 0; i < list.size__(); i++) {
      e = list.getEdge__I(i);
      if (!this.isNodeReachable__Lorg_eclipse_draw2d_graph_Node_2(e.source)) {
        if (!this.isCandidate__Lorg_eclipse_draw2d_graph_Edge_2(e)) {
          this.setCandidate__Lorg_eclipse_draw2d_graph_Edge_2(e);
          candidates.add__Lorg_eclipse_draw2d_graph_Edge_2(e);
        }
      } else
        candidates.remove__Lorg_eclipse_draw2d_graph_Edge_2(e);
    }
    list = node.outgoing;
    for (var i_1: int = 0; i_1 < list.size__(); i_1++) {
      e = list.getEdge__I(i_1);
      if (!this.isNodeReachable__Lorg_eclipse_draw2d_graph_Node_2(e.target)) {
        if (!this.isCandidate__Lorg_eclipse_draw2d_graph_Edge_2(e)) {
          this.setCandidate__Lorg_eclipse_draw2d_graph_Edge_2(e);
          candidates.add__Lorg_eclipse_draw2d_graph_Edge_2(e);
        }
      } else
        candidates.remove__Lorg_eclipse_draw2d_graph_Edge_2(e);
    }
    members.add__Ljava_lang_Object_2(node);
    return;
  }
  public function init__(): void {
    graph.edges.resetFlags__Z(true);
    graph.nodes.resetFlags__();
    for (var i: int = 0; i < graph.nodes.size__(); i++) {
      var node: Node = Node(graph.nodes.get__I(i));
      node.workingData[0] = new EdgeList();
    }
    return;
  }
  public function solve__(): void {
    var root: Node = graph.nodes.getNode__I(0);
    this.setParentEdge__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Edge_2(root, null);
    this.addNode__Lorg_eclipse_draw2d_graph_Node_2(root);
    while (members.size__() < graph.nodes.size__()) {
      if (candidates.size__() == 0)
        throw new RuntimeException(new Arguments(java.lang.RuntimeException.RuntimeException__Ljava_lang_String_2, ["graph is not fully connected"]));
      var minSlack: int = 2147483647;
      var slack: int;
      var minEdge: Edge = null;
      var edge: Edge;
      for (var i: int = 0; i < candidates.size__() && minSlack > 0; i++) {
        edge = candidates.getEdge__I(i);
        slack = edge.getSlack__();
        if (slack < minSlack) {
          minSlack = slack;
          minEdge = edge;
        }
      }
      this.addEdge__Lorg_eclipse_draw2d_graph_Edge_2(minEdge);
    }
    graph.nodes.normalizeRanks__();
    return;
  }
}
}
